/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Architecture;
import com.badlogic.gdx.utils.Architecture$Bitness;
import com.badlogic.gdx.utils.Os;
import com.badlogic.gdx.utils.SharedLibraryLoadRuntimeException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SharedLibraryLoader {
    public static Os os;
    public static Architecture$Bitness bitness;
    public static Architecture architecture;
    @Deprecated
    public static boolean isWindows;
    @Deprecated
    public static boolean isLinux;
    @Deprecated
    public static boolean isMac;
    @Deprecated
    public static boolean isIos;
    @Deprecated
    public static boolean isAndroid;
    @Deprecated
    public static boolean isARM;
    @Deprecated
    public static boolean is64Bit;
    private static final HashSet<String> loadedLibraries;
    private static final Random random;
    private String nativesJar;

    public SharedLibraryLoader() {
    }

    static String randomUUID() {
        return new UUID(random.nextLong(), random.nextLong()).toString();
    }

    public SharedLibraryLoader(String string) {
        this.nativesJar = string;
    }

    public String crc(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        CRC32 cRC32 = new CRC32();
        byte[] byArray = new byte[4096];
        try {
            int n2;
            while ((n2 = inputStream.read(byArray)) != -1) {
                cRC32.update(byArray, 0, n2);
            }
        }
        catch (Exception exception) {
        }
        finally {
            SharedLibraryLoader.closeQuietly(inputStream);
        }
        return Long.toString(cRC32.getValue(), 16);
    }

    public String mapLibraryName(String string) {
        if (os == Os.Android) {
            return string;
        }
        return os.getLibPrefix() + string + architecture.toSuffix() + bitness.toSuffix() + "." + os.getLibExtension();
    }

    public void load(String string) {
        if (os == Os.IOS) {
            return;
        }
        Class<SharedLibraryLoader> clazz = SharedLibraryLoader.class;
        synchronized (SharedLibraryLoader.class) {
            if (SharedLibraryLoader.isLoaded(string)) {
                // ** MonitorExit[var2_4] (shouldn't be in output)
                return;
            }
            String string2 = this.mapLibraryName(string);
            try {
                if (os == Os.Android) {
                    System.loadLibrary(string2);
                } else {
                    this.loadFile(string2);
                }
                SharedLibraryLoader.setLoaded(string);
            }
            catch (Throwable throwable) {
                throw new SharedLibraryLoadRuntimeException("Couldn't load shared library '" + string2 + "' for target: " + (os == Os.Android ? "Android" : System.getProperty("os.name") + ", " + architecture.name() + ", " + bitness.name().substring(1) + "-bit"), throwable);
            }
            return;
        }
    }

    private InputStream readFile(String string) {
        if (this.nativesJar == null) {
            InputStream inputStream = SharedLibraryLoader.class.getResourceAsStream("/" + string);
            if (inputStream == null) {
                throw new SharedLibraryLoadRuntimeException("Unable to read file for extraction: " + string);
            }
            return inputStream;
        }
        try {
            ZipFile zipFile = new ZipFile(this.nativesJar);
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry == null) {
                throw new SharedLibraryLoadRuntimeException("Couldn't find '" + string + "' in JAR: " + this.nativesJar);
            }
            return zipFile.getInputStream(zipEntry);
        }
        catch (IOException iOException) {
            throw new SharedLibraryLoadRuntimeException("Error reading '" + string + "' in JAR: " + this.nativesJar, iOException);
        }
    }

    public File extractFile(String string, String object) {
        try {
            SharedLibraryLoader sharedLibraryLoader = this;
            String string2 = sharedLibraryLoader.crc(sharedLibraryLoader.readFile(string));
            if (object == null) {
                object = string2;
            }
            if ((object = this.getExtractedFile((String)object, new File(string).getName())) == null && (object = this.getExtractedFile(SharedLibraryLoader.randomUUID(), new File(string).getName())) == null) {
                throw new SharedLibraryLoadRuntimeException("Unable to find writable path to extract file. Is the user home directory writable?");
            }
            return this.extractFile(string, string2, (File)object);
        }
        catch (RuntimeException runtimeException) {
            object = new File(System.getProperty("java.library.path"), string);
            if (((File)object).exists()) {
                return object;
            }
            throw runtimeException;
        }
    }

    public void extractFileTo(String string, File file) {
        SharedLibraryLoader sharedLibraryLoader = this;
        this.extractFile(string, sharedLibraryLoader.crc(sharedLibraryLoader.readFile(string)), new File(file, new File(string).getName()));
    }

    private File getExtractedFile(String string, String string2) {
        File file;
        File file2 = new File(System.getProperty("java.io.tmpdir") + "/libgdx" + System.getProperty("user.name") + "/" + string, string2);
        if (this.canWrite(file2)) {
            return file2;
        }
        try {
            file = File.createTempFile(string, null);
            if (file.delete() && this.canWrite(file = new File(file, string2))) {
                return file;
            }
        }
        catch (IOException iOException) {}
        file = new File(System.getProperty("user.home") + "/.libgdx/" + string, string2);
        if (this.canWrite(file)) {
            return file;
        }
        file = new File(".temp/" + string, string2);
        if (this.canWrite(file)) {
            return file;
        }
        if (System.getenv("APP_SANDBOX_CONTAINER_ID") != null) {
            return file2;
        }
        return null;
    }

    private boolean canWrite(File file) {
        File file2 = file.getParentFile();
        if (file.exists()) {
            if (!file.canWrite() || !this.canExecute(file)) {
                return false;
            }
            file = new File(file2, SharedLibraryLoader.randomUUID().toString());
        } else {
            file2.mkdirs();
            if (!file2.isDirectory()) {
                return false;
            }
        }
        try {
            new FileOutputStream(file).close();
            return this.canExecute(file);
            {
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        finally {
            file.delete();
        }
    }

    private boolean canExecute(File file) {
        try {
            Method method = File.class.getMethod("canExecute", new Class[0]);
            if (((Boolean)method.invoke((Object)file, new Object[0])).booleanValue()) {
                return true;
            }
            Method method2 = File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
            method2.invoke((Object)file, Boolean.TRUE, Boolean.FALSE);
            return (Boolean)method.invoke((Object)file, new Object[0]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private File extractFile(String string, String object, File file) {
        Object object2 = null;
        if (file.exists()) {
            try {
                object2 = this.crc(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        if (object2 == null || !((String)object2).equals(object)) {
            object = null;
            object2 = null;
            try {
                int n2;
                object = this.readFile(string);
                file.getParentFile().mkdirs();
                object2 = new FileOutputStream(file);
                byte[] byArray = new byte[4096];
                while ((n2 = ((InputStream)object).read(byArray)) != -1) {
                    ((FileOutputStream)object2).write(byArray, 0, n2);
                }
            }
            catch (IOException iOException) {
                throw new SharedLibraryLoadRuntimeException("Error extracting file: " + string + "\nTo: " + file.getAbsolutePath(), iOException);
            }
            finally {
                SharedLibraryLoader.closeQuietly((Closeable)object);
                SharedLibraryLoader.closeQuietly((Closeable)object2);
            }
        }
        return file;
    }

    private void loadFile(String string) {
        SharedLibraryLoader sharedLibraryLoader = this;
        String string2 = sharedLibraryLoader.crc(sharedLibraryLoader.readFile(string));
        String string3 = new File(string).getName();
        File file = new File(System.getProperty("java.io.tmpdir") + "/libgdx" + System.getProperty("user.name") + "/" + string2, string3);
        Throwable throwable = this.loadFile(string, string2, file);
        if (throwable == null) {
            return;
        }
        try {
            file = File.createTempFile(string2, null);
            if (file.delete() && this.loadFile(string, string2, file) == null) {
                return;
            }
        }
        catch (Throwable throwable2) {}
        file = new File(System.getProperty("user.home") + "/.libgdx/" + string2, string3);
        if (this.loadFile(string, string2, file) == null) {
            return;
        }
        file = new File(".temp/" + string2, string3);
        if (this.loadFile(string, string2, file) == null) {
            return;
        }
        file = new File(System.getProperty("java.library.path"), string);
        if (file.exists()) {
            System.load(file.getAbsolutePath());
            return;
        }
        throw new SharedLibraryLoadRuntimeException(throwable);
    }

    private Throwable loadFile(String object, String string, File file) {
        try {
            System.load(this.extractFile((String)object, string, file).getAbsolutePath());
            return null;
        }
        catch (Throwable throwable) {
            object = throwable;
            return throwable;
        }
    }

    public static synchronized void setLoaded(String string) {
        loadedLibraries.add(string);
    }

    public static synchronized boolean isLoaded(String string) {
        return loadedLibraries.contains(string);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (Throwable throwable) {}
        }
    }

    static {
        bitness = Architecture$Bitness._32;
        architecture = Architecture.x86;
        if (System.getProperty("os.name").contains("Windows")) {
            os = Os.Windows;
        } else if (System.getProperty("os.name").contains("Linux")) {
            os = Os.Linux;
        } else if (System.getProperty("os.name").contains("Mac")) {
            os = Os.MacOsX;
        }
        if (System.getProperty("os.arch").startsWith("arm") || System.getProperty("os.arch").startsWith("aarch64")) {
            architecture = Architecture.ARM;
        } else if (System.getProperty("os.arch").startsWith("riscv")) {
            architecture = Architecture.RISCV;
        } else if (System.getProperty("os.arch").startsWith("loongarch")) {
            architecture = Architecture.LOONGARCH;
        }
        if (System.getProperty("os.arch").contains("64") || System.getProperty("os.arch").startsWith("armv8")) {
            bitness = Architecture$Bitness._64;
        } else if (System.getProperty("os.arch").contains("128")) {
            bitness = Architecture$Bitness._128;
        }
        boolean bl = System.getProperty("moe.platform.name") != null;
        String string = System.getProperty("java.runtime.name");
        if (string != null && string.contains("Android Runtime")) {
            os = Os.Android;
            bitness = Architecture$Bitness._32;
            architecture = Architecture.x86;
        }
        if (bl || os != Os.Android && os != Os.Windows && os != Os.Linux && os != Os.MacOsX) {
            os = Os.IOS;
            bitness = Architecture$Bitness._32;
            architecture = Architecture.x86;
        }
        isWindows = os == Os.Windows;
        isLinux = os == Os.Linux;
        isMac = os == Os.MacOsX;
        isIos = os == Os.IOS;
        isAndroid = os == Os.Android;
        isARM = architecture == Architecture.ARM;
        is64Bit = bitness == Architecture$Bitness._64;
        loadedLibraries = new HashSet();
        random = new Random();
    }
}

