/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.Timer$Task;
import com.badlogic.gdx.utils.Timer$TimerThread$1;

class Timer$TimerThread
implements LifecycleListener,
Runnable {
    final Files files;
    final Application app;
    final Array<Timer> instances = new Array(1);
    Timer instance;
    long pauseTimeMillis;
    final Array<Timer$Task> postedTasks = new Array(2);
    final Array<Timer$Task> runTasks = new Array(2);
    private final Runnable runPostedTasks = new Timer$TimerThread$1(this);

    public Timer$TimerThread() {
        this.files = Gdx.files;
        this.app = Gdx.app;
        this.app.addLifecycleListener(this);
        this.resume();
        Thread thread = new Thread((Runnable)this, "Timer");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void run() {
        while (true) {
            Object object = Timer.threadLock;
            synchronized (object) {
                if (Timer.thread != this || this.files != Gdx.files) {
                    break;
                }
                long l2 = 5000L;
                if (this.pauseTimeMillis == 0L) {
                    long l3 = System.nanoTime() / 1000000L;
                    int n2 = this.instances.size;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        try {
                            l2 = this.instances.get(i2).update(this, l3, l2);
                            continue;
                        }
                        catch (Throwable throwable) {
                            throw new GdxRuntimeException("Task failed: " + this.instances.get(i2).getClass().getName(), throwable);
                        }
                    }
                }
                if (Timer.thread != this || this.files != Gdx.files) {
                    break;
                }
                try {
                    if (l2 > 0L) {
                        Timer.threadLock.wait(l2);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.dispose();
    }

    void runPostedTasks() {
        T[] TArray = this.postedTasks;
        synchronized (this.postedTasks) {
            this.runTasks.addAll(this.postedTasks);
            this.postedTasks.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            TArray = this.runTasks.items;
            int n2 = this.runTasks.size;
            for (int i2 = 0; i2 < n2; ++i2) {
                ((Timer$Task)TArray[i2]).run();
            }
            this.runTasks.clear();
            return;
        }
    }

    void addPostedTask(Timer$Task timer$Task) {
        Array<Timer$Task> array = this.postedTasks;
        synchronized (array) {
            if (this.postedTasks.isEmpty()) {
                timer$Task.app.postRunnable(this.runPostedTasks);
            }
            this.postedTasks.add(timer$Task);
            return;
        }
    }

    void removePostedTask(Timer$Task timer$Task) {
        Array<Timer$Task> array = this.postedTasks;
        synchronized (array) {
            T[] TArray = this.postedTasks.items;
            for (int i2 = this.postedTasks.size - 1; i2 >= 0; --i2) {
                if (TArray[i2] != timer$Task) continue;
                this.postedTasks.removeIndex(i2);
            }
            return;
        }
    }

    @Override
    public void resume() {
        Object object = Timer.threadLock;
        synchronized (object) {
            long l2 = System.nanoTime() / 1000000L - this.pauseTimeMillis;
            int n2 = this.instances.size;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.instances.get(i2).delay(l2);
            }
            this.pauseTimeMillis = 0L;
            Timer.threadLock.notifyAll();
            return;
        }
    }

    @Override
    public void pause() {
        Object object = Timer.threadLock;
        synchronized (object) {
            this.pauseTimeMillis = System.nanoTime() / 1000000L;
            Timer.threadLock.notifyAll();
            return;
        }
    }

    @Override
    public void dispose() {
        Object object = Timer.threadLock;
        synchronized (object) {
            Array<Timer$Task> array = this.postedTasks;
            synchronized (array) {
                this.postedTasks.clear();
            }
            if (Timer.thread == this) {
                Timer.thread = null;
            }
            this.instances.clear();
            Timer.threadLock.notifyAll();
        }
        this.app.removeLifecycleListener(this);
    }
}

