/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.BaseJsonReader;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.JsonValue$ValueType;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UBJsonReader
implements BaseJsonReader {
    public boolean oldFormat = true;

    @Override
    public JsonValue parse(InputStream object) {
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream((InputStream)object);
            object = this.parse(dataInputStream);
        }
        catch (IOException iOException) {
            try {
                throw new SerializationException(iOException);
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(dataInputStream);
                throw throwable;
            }
        }
        StreamUtils.closeQuietly(dataInputStream);
        return object;
    }

    @Override
    public JsonValue parse(FileHandle fileHandle) {
        try {
            return this.parse(fileHandle.read(8192));
        }
        catch (Exception exception) {
            throw new SerializationException("Error parsing file: " + fileHandle, exception);
        }
    }

    public JsonValue parse(DataInputStream dataInputStream) {
        try {
            DataInputStream dataInputStream2 = dataInputStream;
            JsonValue jsonValue = this.parse(dataInputStream2, dataInputStream2.readByte());
            return jsonValue;
        }
        finally {
            StreamUtils.closeQuietly(dataInputStream);
        }
    }

    protected JsonValue parse(DataInputStream dataInputStream, byte by) {
        if (by == 91) {
            return this.parseArray(dataInputStream);
        }
        if (by == 123) {
            return this.parseObject(dataInputStream);
        }
        if (by == 90) {
            return new JsonValue(JsonValue$ValueType.nullValue);
        }
        if (by == 84) {
            return new JsonValue(true);
        }
        if (by == 70) {
            return new JsonValue(false);
        }
        if (by == 66) {
            return new JsonValue(this.readUChar(dataInputStream));
        }
        if (by == 85) {
            return new JsonValue(this.readUChar(dataInputStream));
        }
        if (by == 105) {
            return new JsonValue(this.oldFormat ? (long)dataInputStream.readShort() : (long)dataInputStream.readByte());
        }
        if (by == 73) {
            return new JsonValue(this.oldFormat ? (long)dataInputStream.readInt() : (long)dataInputStream.readShort());
        }
        if (by == 108) {
            return new JsonValue(dataInputStream.readInt());
        }
        if (by == 76) {
            return new JsonValue(dataInputStream.readLong());
        }
        if (by == 100) {
            return new JsonValue(dataInputStream.readFloat());
        }
        if (by == 68) {
            return new JsonValue(dataInputStream.readDouble());
        }
        if (by == 115 || by == 83) {
            return new JsonValue(this.parseString(dataInputStream, by));
        }
        if (by == 97 || by == 65) {
            return this.parseData(dataInputStream, by);
        }
        if (by == 67) {
            return new JsonValue(dataInputStream.readChar());
        }
        throw new GdxRuntimeException("Unrecognized data type");
    }

    protected JsonValue parseArray(DataInputStream dataInputStream) {
        JsonValue jsonValue = new JsonValue(JsonValue$ValueType.array);
        byte by = dataInputStream.readByte();
        byte by2 = 0;
        if (by == 36) {
            by2 = dataInputStream.readByte();
            by = dataInputStream.readByte();
        }
        long l2 = -1L;
        if (by == 35) {
            l2 = this.parseSize(dataInputStream, false, -1L);
            if (l2 < 0L) {
                throw new GdxRuntimeException("Unrecognized data type");
            }
            if (l2 == 0L) {
                return jsonValue;
            }
            by = by2 == 0 ? dataInputStream.readByte() : by2;
        }
        JsonValue jsonValue2 = null;
        long l3 = 0L;
        while (dataInputStream.available() > 0 && by != 93) {
            JsonValue jsonValue3 = this.parse(dataInputStream, by);
            this.parse(dataInputStream, by).parent = jsonValue;
            if (jsonValue2 != null) {
                jsonValue3.prev = jsonValue2;
                jsonValue2.next = jsonValue3;
                ++jsonValue.size;
            } else {
                jsonValue.child = jsonValue3;
                jsonValue.size = 1;
            }
            jsonValue2 = jsonValue3;
            if (l2 > 0L && ++l3 >= l2) break;
            by = by2 == 0 ? dataInputStream.readByte() : by2;
        }
        return jsonValue;
    }

    protected JsonValue parseObject(DataInputStream dataInputStream) {
        JsonValue jsonValue = new JsonValue(JsonValue$ValueType.object);
        byte by = dataInputStream.readByte();
        byte by2 = 0;
        if (by == 36) {
            by2 = dataInputStream.readByte();
            by = dataInputStream.readByte();
        }
        long l2 = -1L;
        if (by == 35) {
            l2 = this.parseSize(dataInputStream, false, -1L);
            if (l2 < 0L) {
                throw new GdxRuntimeException("Unrecognized data type");
            }
            if (l2 == 0L) {
                return jsonValue;
            }
            by = dataInputStream.readByte();
        }
        JsonValue jsonValue2 = null;
        long l3 = 0L;
        while (dataInputStream.available() > 0 && by != 125) {
            String string = this.parseString(dataInputStream, true, by);
            JsonValue jsonValue3 = this.parse(dataInputStream, by2 == 0 ? dataInputStream.readByte() : by2);
            jsonValue3.setName(string);
            jsonValue3.parent = jsonValue;
            if (jsonValue2 != null) {
                jsonValue3.prev = jsonValue2;
                jsonValue2.next = jsonValue3;
                ++jsonValue.size;
            } else {
                jsonValue.child = jsonValue3;
                jsonValue.size = 1;
            }
            jsonValue2 = jsonValue3;
            if (l2 > 0L && ++l3 >= l2) break;
            by = dataInputStream.readByte();
        }
        return jsonValue;
    }

    protected JsonValue parseData(DataInputStream dataInputStream, byte by) {
        byte by2 = dataInputStream.readByte();
        long l2 = by == 65 ? this.readUInt(dataInputStream) : (long)this.readUChar(dataInputStream);
        JsonValue jsonValue = new JsonValue(JsonValue$ValueType.array);
        JsonValue jsonValue2 = null;
        for (long i2 = 0L; i2 < l2; ++i2) {
            JsonValue jsonValue3 = this.parse(dataInputStream, by2);
            this.parse(dataInputStream, by2).parent = jsonValue;
            if (jsonValue2 != null) {
                jsonValue2.next = jsonValue3;
                ++jsonValue.size;
            } else {
                jsonValue.child = jsonValue3;
                jsonValue.size = 1;
            }
            jsonValue2 = jsonValue3;
        }
        return jsonValue;
    }

    protected String parseString(DataInputStream dataInputStream, byte by) {
        return this.parseString(dataInputStream, false, by);
    }

    protected String parseString(DataInputStream dataInputStream, boolean bl, byte by) {
        long l2 = -1L;
        if (by == 83) {
            l2 = this.parseSize(dataInputStream, true, -1L);
        } else if (by == 115) {
            l2 = this.readUChar(dataInputStream);
        } else if (bl) {
            l2 = this.parseSize(dataInputStream, by, false, -1L);
        }
        if (l2 < 0L) {
            throw new GdxRuntimeException("Unrecognized data type, string expected");
        }
        if (l2 > 0L) {
            return this.readString(dataInputStream, l2);
        }
        return "";
    }

    protected long parseSize(DataInputStream dataInputStream, boolean bl, long l2) {
        DataInputStream dataInputStream2 = dataInputStream;
        return this.parseSize(dataInputStream2, dataInputStream2.readByte(), bl, l2);
    }

    protected long parseSize(DataInputStream dataInputStream, byte by, boolean bl, long l2) {
        if (by == 105) {
            return this.readUChar(dataInputStream);
        }
        if (by == 73) {
            return this.readUShort(dataInputStream);
        }
        if (by == 108) {
            return this.readUInt(dataInputStream);
        }
        if (by == 76) {
            return dataInputStream.readLong();
        }
        if (bl) {
            long l3 = (long)((short)by & 0xFF) << 24;
            l3 |= (long)((short)dataInputStream.readByte() & 0xFF) << 16;
            l3 |= (long)((short)dataInputStream.readByte() & 0xFF) << 8;
            return l3 |= (long)((short)dataInputStream.readByte() & 0xFF);
        }
        return l2;
    }

    protected short readUChar(DataInputStream dataInputStream) {
        return (short)((short)dataInputStream.readByte() & 0xFF);
    }

    protected int readUShort(DataInputStream dataInputStream) {
        return dataInputStream.readShort() & 0xFFFF;
    }

    protected long readUInt(DataInputStream dataInputStream) {
        return dataInputStream.readInt();
    }

    protected String readString(DataInputStream dataInputStream, long l2) {
        byte[] byArray = new byte[(int)l2];
        dataInputStream.readFully(byArray);
        return new String(byArray, "UTF-8");
    }
}

