/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectMap$Entry;
import com.badlogic.gdx.utils.StringBuilder;

public class XmlReader$Element {
    private final String name;
    private ObjectMap<String, String> attributes;
    private Array<XmlReader$Element> children;
    private String text;
    private XmlReader$Element parent;

    public XmlReader$Element(String string, XmlReader$Element xmlReader$Element) {
        this.name = string;
        this.parent = xmlReader$Element;
    }

    public String getName() {
        return this.name;
    }

    public ObjectMap<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String string) {
        if (this.attributes == null) {
            throw new GdxRuntimeException("Element " + this.name + " doesn't have attribute: " + string);
        }
        String string2 = this.attributes.get(string);
        if (string2 == null) {
            throw new GdxRuntimeException("Element " + this.name + " doesn't have attribute: " + string);
        }
        return string2;
    }

    public String getAttribute(String string, String string2) {
        if (this.attributes == null) {
            return string2;
        }
        if ((string = this.attributes.get(string)) == null) {
            return string2;
        }
        return string;
    }

    public boolean hasAttribute(String string) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.containsKey(string);
    }

    public void setAttribute(String string, String string2) {
        if (this.attributes == null) {
            this.attributes = new ObjectMap(8);
        }
        this.attributes.put(string, string2);
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size;
    }

    public XmlReader$Element getChild(int n2) {
        if (this.children == null) {
            throw new GdxRuntimeException("Element has no children: " + this.name);
        }
        return this.children.get(n2);
    }

    public void addChild(XmlReader$Element xmlReader$Element) {
        if (this.children == null) {
            this.children = new Array(8);
        }
        this.children.add(xmlReader$Element);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void removeChild(int n2) {
        if (this.children != null) {
            this.children.removeIndex(n2);
        }
    }

    public void removeChild(XmlReader$Element xmlReader$Element) {
        if (this.children != null) {
            this.children.removeValue(xmlReader$Element, true);
        }
    }

    public void remove() {
        this.parent.removeChild(this);
    }

    public XmlReader$Element getParent() {
        return this.parent;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(string);
        stringBuilder.append('<');
        stringBuilder.append(this.name);
        if (this.attributes != null) {
            for (ObjectMap$Entry object : this.attributes.entries()) {
                stringBuilder.append(' ');
                stringBuilder.append((String)object.key);
                stringBuilder.append("=\"");
                stringBuilder.append((String)object.value);
                stringBuilder.append('\"');
            }
        }
        if (this.children == null && (this.text == null || this.text.length() == 0)) {
            stringBuilder.append("/>");
        } else {
            stringBuilder.append(">\n");
            String string2 = string + '\t';
            if (this.text != null && this.text.length() > 0) {
                stringBuilder.append(string2);
                stringBuilder.append(this.text);
                stringBuilder.append('\n');
            }
            if (this.children != null) {
                for (XmlReader$Element xmlReader$Element : this.children) {
                    stringBuilder.append(xmlReader$Element.toString(string2));
                    stringBuilder.append('\n');
                }
            }
            stringBuilder.append(string);
            stringBuilder.append("</");
            stringBuilder.append(this.name);
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    @Null
    public XmlReader$Element getChildByName(String string) {
        if (this.children == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.children.size; ++i2) {
            XmlReader$Element xmlReader$Element = this.children.get(i2);
            if (!xmlReader$Element.name.equals(string)) continue;
            return xmlReader$Element;
        }
        return null;
    }

    public boolean hasChild(String string) {
        if (this.children == null) {
            return false;
        }
        return this.getChildByName(string) != null;
    }

    @Null
    public XmlReader$Element getChildByNameRecursive(String string) {
        if (this.children == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.children.size; ++i2) {
            XmlReader$Element xmlReader$Element = this.children.get(i2);
            if (xmlReader$Element.name.equals(string)) {
                return xmlReader$Element;
            }
            if ((xmlReader$Element = xmlReader$Element.getChildByNameRecursive(string)) == null) continue;
            return xmlReader$Element;
        }
        return null;
    }

    public boolean hasChildRecursive(String string) {
        if (this.children == null) {
            return false;
        }
        return this.getChildByNameRecursive(string) != null;
    }

    public Array<XmlReader$Element> getChildrenByName(String string) {
        Array<XmlReader$Element> array = new Array<XmlReader$Element>();
        if (this.children == null) {
            return array;
        }
        for (int i2 = 0; i2 < this.children.size; ++i2) {
            XmlReader$Element xmlReader$Element = this.children.get(i2);
            if (!xmlReader$Element.name.equals(string)) continue;
            array.add(xmlReader$Element);
        }
        return array;
    }

    public Array<XmlReader$Element> getChildrenByNameRecursively(String string) {
        Array<XmlReader$Element> array = new Array<XmlReader$Element>();
        this.getChildrenByNameRecursively(string, array);
        return array;
    }

    private void getChildrenByNameRecursively(String string, Array<XmlReader$Element> array) {
        if (this.children == null) {
            return;
        }
        for (int i2 = 0; i2 < this.children.size; ++i2) {
            XmlReader$Element xmlReader$Element = this.children.get(i2);
            if (xmlReader$Element.name.equals(string)) {
                array.add(xmlReader$Element);
            }
            xmlReader$Element.getChildrenByNameRecursively(string, array);
        }
    }

    public float getFloatAttribute(String string) {
        return Float.parseFloat(this.getAttribute(string));
    }

    public float getFloatAttribute(String string, float f2) {
        if ((string = this.getAttribute(string, null)) == null) {
            return f2;
        }
        return Float.parseFloat(string);
    }

    public int getIntAttribute(String string) {
        return Integer.parseInt(this.getAttribute(string));
    }

    public int getIntAttribute(String string, int n2) {
        if ((string = this.getAttribute(string, null)) == null) {
            return n2;
        }
        return Integer.parseInt(string);
    }

    public boolean getBooleanAttribute(String string) {
        return Boolean.parseBoolean(this.getAttribute(string));
    }

    public boolean getBooleanAttribute(String string, boolean bl) {
        if ((string = this.getAttribute(string, null)) == null) {
            return bl;
        }
        return Boolean.parseBoolean(string);
    }

    public String get(String string) {
        String string2 = this.get(string, null);
        if (string2 == null) {
            throw new GdxRuntimeException("Element " + this.name + " doesn't have attribute or child: " + string);
        }
        return string2;
    }

    public String get(String string, String string2) {
        Object object;
        if (this.attributes != null && (object = this.attributes.get(string)) != null) {
            return object;
        }
        object = this.getChildByName(string);
        if (object == null) {
            return string2;
        }
        string = ((XmlReader$Element)object).getText();
        if (string == null) {
            return string2;
        }
        return string;
    }

    public int getInt(String string) {
        String string2 = this.get(string, null);
        if (string2 == null) {
            throw new GdxRuntimeException("Element " + this.name + " doesn't have attribute or child: " + string);
        }
        return Integer.parseInt(string2);
    }

    public int getInt(String string, int n2) {
        if ((string = this.get(string, null)) == null) {
            return n2;
        }
        return Integer.parseInt(string);
    }

    public float getFloat(String string) {
        String string2 = this.get(string, null);
        if (string2 == null) {
            throw new GdxRuntimeException("Element " + this.name + " doesn't have attribute or child: " + string);
        }
        return Float.parseFloat(string2);
    }

    public float getFloat(String string, float f2) {
        if ((string = this.get(string, null)) == null) {
            return f2;
        }
        return Float.parseFloat(string);
    }

    public boolean getBoolean(String string) {
        String string2 = this.get(string, null);
        if (string2 == null) {
            throw new GdxRuntimeException("Element " + this.name + " doesn't have attribute or child: " + string);
        }
        return Boolean.parseBoolean(string2);
    }

    public boolean getBoolean(String string, boolean bl) {
        if ((string = this.get(string, null)) == null) {
            return bl;
        }
        return Boolean.parseBoolean(string);
    }
}

