/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.StreamUtils;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.XmlReader$Element;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class XmlReader {
    private final Array<XmlReader$Element> elements = new Array(8);
    private XmlReader$Element root;
    private XmlReader$Element current;
    private final StringBuilder textBuffer = new StringBuilder(64);
    private String entitiesText;
    private static final byte[] _xml_actions = XmlReader.init__xml_actions_0();
    private static final byte[] _xml_key_offsets = XmlReader.init__xml_key_offsets_0();
    private static final char[] _xml_trans_keys = XmlReader.init__xml_trans_keys_0();
    private static final byte[] _xml_single_lengths = XmlReader.init__xml_single_lengths_0();
    private static final byte[] _xml_range_lengths = XmlReader.init__xml_range_lengths_0();
    private static final short[] _xml_index_offsets = XmlReader.init__xml_index_offsets_0();
    private static final byte[] _xml_indicies = XmlReader.init__xml_indicies_0();
    private static final byte[] _xml_trans_targs = XmlReader.init__xml_trans_targs_0();
    private static final byte[] _xml_trans_actions = XmlReader.init__xml_trans_actions_0();
    static final int xml_start = 1;
    static final int xml_first_final = 34;
    static final int xml_error = 0;
    static final int xml_en_elementBody = 15;
    static final int xml_en_main = 1;

    public XmlReader$Element parse(String object) {
        object = ((String)object).toCharArray();
        return this.parse((char[])object, 0, ((Object)object).length);
    }

    public XmlReader$Element parse(Reader reader) {
        try {
            int n2;
            char[] cArray = new char[1024];
            int n3 = 0;
            while ((n2 = reader.read(cArray, n3, cArray.length - n3)) != -1) {
                if (n2 == 0) {
                    char[] cArray2 = new char[cArray.length << 1];
                    System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
                    cArray = cArray2;
                    continue;
                }
                n3 += n2;
            }
            XmlReader$Element xmlReader$Element = this.parse(cArray, 0, n3);
            return xmlReader$Element;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        finally {
            StreamUtils.closeQuietly(reader);
        }
    }

    public XmlReader$Element parse(InputStream inputStream) {
        try {
            XmlReader$Element xmlReader$Element = this.parse(new InputStreamReader(inputStream, "UTF-8"));
            return xmlReader$Element;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        finally {
            StreamUtils.closeQuietly(inputStream);
        }
    }

    public XmlReader$Element parse(FileHandle fileHandle) {
        try {
            return this.parse(fileHandle.reader("UTF-8"));
        }
        catch (Exception exception) {
            throw new SerializationException("Error parsing file: " + fileHandle, exception);
        }
    }

    /*
     * Unable to fully structure code
     */
    public XmlReader$Element parse(char[] var1_1, int var2_2, int var3_3) {
        var4_4 = var2_2;
        var5_5 = 0;
        var6_7 = null;
        var7_8 = false;
        var2_2 = 1;
        var8_9 = 0;
        block19: while (true) {
            switch (var8_9) {
                case 0: {
                    if (var4_4 == var3_3) {
                        var8_9 = 4;
                        continue block19;
                    }
                    if (var2_2 == 0) {
                        var8_9 = 5;
                        continue block19;
                    }
                }
                case 1: {
                    var10_13 = XmlReader._xml_key_offsets[var2_2];
                    var9_12 = XmlReader._xml_index_offsets[var2_2];
                    var8_9 = XmlReader._xml_single_lengths[var2_2];
                    if (var8_9 <= 0) ** GOTO lbl35
                    var11_15 = var10_13;
                    var13_17 = var10_13 + var8_9 - 1;
                    while (var13_17 >= var11_15) {
                        var12_16 = var11_15 + (var13_17 - var11_15 >> 1);
                        if (var1_1[var4_4] < XmlReader._xml_trans_keys[var12_16]) {
                            var13_17 = var12_16 - 1;
                            continue;
                        }
                        if (var1_1[var4_4] > XmlReader._xml_trans_keys[var12_16]) {
                            var11_15 = var12_16 + 1;
                            continue;
                        }
                        var9_12 += var12_16 - var10_13;
                        ** GOTO lbl49
                    }
                    var10_13 += var8_9;
                    var9_12 += var8_9;
lbl35:
                    // 2 sources

                    if ((var8_9 = XmlReader._xml_range_lengths[var2_2]) > 0) {
                        var11_15 = var10_13;
                        var13_17 = var10_13 + (var8_9 << 1) - 2;
                        while (var13_17 >= var11_15) {
                            var12_16 = var11_15 + (var13_17 - var11_15 >> 1 & -2);
                            if (var1_1[var4_4] < XmlReader._xml_trans_keys[var12_16]) {
                                var13_17 = var12_16 - 2;
                                continue;
                            }
                            if (var1_1[var4_4] > XmlReader._xml_trans_keys[var12_16 + 1]) {
                                var11_15 = var12_16 + 2;
                                continue;
                            }
                            var9_12 += var12_16 - var10_13 >> 1;
                            ** GOTO lbl49
                        }
                        var9_12 += var8_9;
                    }
lbl49:
                    // 5 sources

                    var9_12 = XmlReader._xml_indicies[var9_12];
                    var2_2 = XmlReader._xml_trans_targs[var9_12];
                    if (XmlReader._xml_trans_actions[var9_12] != 0) {
                        var8_9 = XmlReader._xml_trans_actions[var9_12];
                        var9_12 = XmlReader._xml_actions[var8_9++];
                        while (var9_12-- > 0) {
                            switch (XmlReader._xml_actions[var8_9++]) {
                                case 0: {
                                    var5_5 = var4_4;
                                    break;
                                }
                                case 1: {
                                    var11_15 = var1_1[var5_5];
                                    if (var11_15 == 63 || var11_15 == 33) {
                                        if (var1_1[var5_5 + 1] == '[' && var1_1[var5_5 + 2] == 'C' && var1_1[var5_5 + 3] == 'D' && var1_1[var5_5 + 4] == 'A' && var1_1[var5_5 + 5] == 'T' && var1_1[var5_5 + 6] == 'A' && var1_1[var5_5 + 7] == '[') {
                                            var4_4 = (var5_5 += 8) + 2;
                                            while (var1_1[var4_4 - 2] != ']' || var1_1[var4_4 - 1] != ']' || var1_1[var4_4] != '>') {
                                                ++var4_4;
                                            }
                                            this.text(new String(var1_1, var5_5, var4_4 - var5_5 - 2));
                                        } else if (var11_15 == 33 && var1_1[var5_5 + 1] == '-' && var1_1[var5_5 + 2] == '-') {
                                            var4_4 = var5_5 + 3;
                                            while (var1_1[var4_4] != '-' || var1_1[var4_4 + 1] != '-' || var1_1[var4_4 + 2] != '>') {
                                                ++var4_4;
                                            }
                                            var4_4 += 2;
                                        } else {
                                            while (var1_1[var4_4] != '>') {
                                                ++var4_4;
                                            }
                                        }
                                        var2_2 = 15;
                                        var8_9 = 2;
                                        continue block19;
                                    }
                                    var7_8 = true;
                                    this.open(new String(var1_1, var5_5, var4_4 - var5_5));
                                    break;
                                }
                                case 2: {
                                    var7_8 = false;
                                    this.close();
                                    var2_2 = 15;
                                    var8_9 = 2;
                                    continue block19;
                                }
                                case 3: {
                                    this.close();
                                    var2_2 = 15;
                                    var8_9 = 2;
                                    continue block19;
                                }
                                case 4: {
                                    if (!var7_8) break;
                                    var2_2 = 15;
                                    var8_9 = 2;
                                    continue block19;
                                }
                                case 5: {
                                    var6_7 = new String(var1_1, var5_5, var4_4 - var5_5);
                                    break;
                                }
                                case 6: {
                                    block26: for (var11_15 = var4_4; var11_15 != var5_5; --var11_15) {
                                        switch (var1_1[var11_15 - 1]) {
                                            case '\t': 
                                            case '\n': 
                                            case '\r': 
                                            case ' ': {
                                                continue block26;
                                            }
                                        }
                                    }
                                    var12_16 = var5_5;
                                    var13_17 = 0;
                                    block27: while (var12_16 != var11_15) {
                                        if (var1_1[var12_16++] != '&') continue;
                                        var10_13 = var12_16;
                                        while (var12_16 != var11_15) {
                                            if (var1_1[var12_16++] != ';') continue;
                                            this.textBuffer.append(var1_1, var5_5, var10_13 - var5_5 - 1);
                                            var5_6 = new String(var1_1, var10_13, var12_16 - var10_13 - 1);
                                            var10_14 = this.entity(var5_6);
                                            this.textBuffer.append(var10_14 != null ? var10_14 : var5_6);
                                            var5_5 = var12_16;
                                            var13_17 = 1;
                                            continue block27;
                                        }
                                    }
                                    if (var13_17 != 0) {
                                        if (var5_5 < var11_15) {
                                            this.textBuffer.append(var1_1, var5_5, var11_15 - var5_5);
                                        }
                                        this.entitiesText = this.textBuffer.toString();
                                        this.textBuffer.setLength(0);
                                        break;
                                    }
                                    this.entitiesText = new String(var1_1, var5_5, var11_15 - var5_5);
                                    break;
                                }
                                case 7: {
                                    this.attribute(var6_7, this.entitiesText);
                                    break;
                                }
                                case 8: {
                                    v0 = this;
                                    v0.text(v0.entitiesText);
                                }
                            }
                        }
                    }
                }
                case 2: {
                    if (var2_2 == 0) {
                        var8_9 = 5;
                        continue block19;
                    }
                    if (++var4_4 == var3_3) break block19;
                    var8_9 = 1;
                    continue block19;
                }
            }
            break;
        }
        this.entitiesText = null;
        if (var4_4 < var3_3) {
            var8_9 = 1;
            for (var9_12 = 0; var9_12 < var4_4; ++var9_12) {
                if (var1_1[var9_12] != '\n') continue;
                ++var8_9;
            }
            throw new SerializationException("Error parsing XML on line " + var8_9 + " near: " + new String(var1_1, var4_4, Math.min(32, var3_3 - var4_4)));
        }
        if (this.elements.size != 0) {
            var8_10 = this.elements.peek();
            this.elements.clear();
            throw new SerializationException("Error parsing XML, unclosed element: " + var8_10.getName());
        }
        var8_11 = this.root;
        this.root = null;
        return var8_11;
    }

    private static byte[] init__xml_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 2, 1, 4, 2, 2, 4, 2, 6, 7, 2, 6, 8, 3, 0, 6, 7};
    }

    private static byte[] init__xml_key_offsets_0() {
        return new byte[]{0, 0, 4, 9, 14, 20, 26, 30, 35, 36, 37, 42, 46, 50, 51, 52, 56, 57, 62, 67, 73, 79, 83, 88, 89, 90, 95, 99, 103, 104, 108, 109, 110, 111, 112, 115};
    }

    private static char[] init__xml_trans_keys_0() {
        return new char[]{' ', '<', '\t', '\r', ' ', '/', '>', '\t', '\r', ' ', '/', '>', '\t', '\r', ' ', '/', '=', '>', '\t', '\r', ' ', '/', '=', '>', '\t', '\r', ' ', '=', '\t', '\r', ' ', '\"', '\'', '\t', '\r', '\"', '\"', ' ', '/', '>', '\t', '\r', ' ', '>', '\t', '\r', ' ', '>', '\t', '\r', '\'', '\'', ' ', '<', '\t', '\r', '<', ' ', '/', '>', '\t', '\r', ' ', '/', '>', '\t', '\r', ' ', '/', '=', '>', '\t', '\r', ' ', '/', '=', '>', '\t', '\r', ' ', '=', '\t', '\r', ' ', '\"', '\'', '\t', '\r', '\"', '\"', ' ', '/', '>', '\t', '\r', ' ', '>', '\t', '\r', ' ', '>', '\t', '\r', '<', ' ', '/', '\t', '\r', '>', '>', '\'', '\'', ' ', '\t', '\r', '\u0000'};
    }

    private static byte[] init__xml_single_lengths_0() {
        return new byte[]{0, 2, 3, 3, 4, 4, 2, 3, 1, 1, 3, 2, 2, 1, 1, 2, 1, 3, 3, 4, 4, 2, 3, 1, 1, 3, 2, 2, 1, 2, 1, 1, 1, 1, 1, 0};
    }

    private static byte[] init__xml_range_lengths_0() {
        return new byte[]{0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0};
    }

    private static short[] init__xml_index_offsets_0() {
        return new short[]{0, 0, 4, 9, 14, 20, 26, 30, 35, 37, 39, 44, 48, 52, 54, 56, 60, 62, 67, 72, 78, 84, 88, 93, 95, 97, 102, 106, 110, 112, 116, 118, 120, 122, 124, 127};
    }

    private static byte[] init__xml_indicies_0() {
        return new byte[]{0, 2, 0, 1, 2, 1, 1, 2, 3, 5, 6, 7, 5, 4, 9, 10, 1, 11, 9, 8, 13, 1, 14, 1, 13, 12, 15, 16, 15, 1, 16, 17, 18, 16, 1, 20, 19, 22, 21, 9, 10, 11, 9, 1, 23, 24, 23, 1, 25, 11, 25, 1, 20, 26, 22, 27, 29, 30, 29, 28, 32, 31, 30, 34, 1, 30, 33, 36, 37, 38, 36, 35, 40, 41, 1, 42, 40, 39, 44, 1, 45, 1, 44, 43, 46, 47, 46, 1, 47, 48, 49, 47, 1, 51, 50, 53, 52, 40, 41, 42, 40, 1, 54, 55, 54, 1, 56, 42, 56, 1, 57, 1, 57, 34, 57, 1, 1, 58, 59, 58, 51, 60, 53, 61, 62, 62, 1, 1, 0};
    }

    private static byte[] init__xml_trans_targs_0() {
        return new byte[]{1, 0, 2, 3, 3, 4, 11, 34, 5, 4, 11, 34, 5, 6, 7, 6, 7, 8, 13, 9, 10, 9, 10, 12, 34, 12, 14, 14, 16, 15, 17, 16, 17, 18, 30, 18, 19, 26, 28, 20, 19, 26, 28, 20, 21, 22, 21, 22, 23, 32, 24, 25, 24, 25, 27, 28, 27, 29, 31, 35, 33, 33, 34};
    }

    private static byte[] init__xml_trans_actions_0() {
        return new byte[]{0, 0, 0, 1, 0, 3, 3, 13, 1, 0, 0, 9, 0, 11, 11, 0, 0, 0, 0, 1, 25, 0, 19, 5, 16, 0, 1, 0, 1, 0, 0, 0, 22, 1, 0, 0, 3, 3, 13, 1, 0, 0, 9, 0, 11, 11, 0, 0, 0, 0, 1, 25, 0, 19, 5, 16, 0, 0, 0, 7, 1, 0, 0};
    }

    protected void open(String object) {
        object = new XmlReader$Element((String)object, this.current);
        XmlReader$Element xmlReader$Element = this.current;
        if (xmlReader$Element != null) {
            xmlReader$Element.addChild((XmlReader$Element)object);
        }
        this.elements.add((XmlReader$Element)object);
        this.current = object;
    }

    protected void attribute(String string, String string2) {
        this.current.setAttribute(string, string2);
    }

    @Null
    protected String entity(String string) {
        if (string.equals("lt")) {
            return "<";
        }
        if (string.equals("gt")) {
            return ">";
        }
        if (string.equals("amp")) {
            return "&";
        }
        if (string.equals("apos")) {
            return "'";
        }
        if (string.equals("quot")) {
            return "\"";
        }
        if (string.startsWith("#x")) {
            return Character.toString((char)Integer.parseInt(string.substring(2), 16));
        }
        return null;
    }

    protected void text(String string) {
        String string2 = this.current.getText();
        this.current.setText(string2 != null ? string2 + string : string);
    }

    protected void close() {
        this.root = this.elements.pop();
        this.current = this.elements.size > 0 ? this.elements.peek() : null;
    }
}

