/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.async;

import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.async.AsyncExecutor$1;
import com.badlogic.gdx.utils.async.AsyncExecutor$2;
import com.badlogic.gdx.utils.async.AsyncResult;
import com.badlogic.gdx.utils.async.AsyncTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class AsyncExecutor
implements Disposable {
    private final ExecutorService executor;

    public AsyncExecutor(int n2) {
        this(n2, "AsynchExecutor-Thread");
    }

    public AsyncExecutor(int n2, String string) {
        this.executor = Executors.newFixedThreadPool(n2, new AsyncExecutor$1(this, string));
    }

    public <T> AsyncResult<T> submit(AsyncTask<T> asyncTask) {
        if (this.executor.isShutdown()) {
            throw new GdxRuntimeException("Cannot run tasks on an executor that has been shutdown (disposed)");
        }
        return new AsyncResult(this.executor.submit(new AsyncExecutor$2(this, asyncTask)));
    }

    @Override
    public void dispose() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            throw new GdxRuntimeException("Couldn't shutdown loading thread", interruptedException);
        }
    }
}

