/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.compression;

import com.badlogic.gdx.utils.compression.Lzma$CommandLine;
import com.badlogic.gdx.utils.compression.lzma.Decoder;
import com.badlogic.gdx.utils.compression.lzma.Encoder;
import java.io.InputStream;
import java.io.OutputStream;

public class Lzma {
    public static void compress(InputStream inputStream, OutputStream outputStream) {
        long l2;
        Encoder encoder;
        Lzma$CommandLine lzma$CommandLine = new Lzma$CommandLine();
        boolean bl = false;
        if (lzma$CommandLine.Eos) {
            bl = true;
        }
        if (!(encoder = new Encoder()).SetAlgorithm(lzma$CommandLine.Algorithm)) {
            throw new RuntimeException("Incorrect compression mode");
        }
        if (!encoder.SetDictionarySize(lzma$CommandLine.DictionarySize)) {
            throw new RuntimeException("Incorrect dictionary size");
        }
        if (!encoder.SetNumFastBytes(lzma$CommandLine.Fb)) {
            throw new RuntimeException("Incorrect -fb value");
        }
        if (!encoder.SetMatchFinder(lzma$CommandLine.MatchFinder)) {
            throw new RuntimeException("Incorrect -mf value");
        }
        if (!encoder.SetLcLpPb(lzma$CommandLine.Lc, lzma$CommandLine.Lp, lzma$CommandLine.Pb)) {
            throw new RuntimeException("Incorrect -lc or -lp or -pb value");
        }
        encoder.SetEndMarkerMode(bl);
        encoder.WriteCoderProperties(outputStream);
        if (bl) {
            l2 = -1L;
        } else {
            l2 = inputStream.available();
            if (l2 == 0L) {
                l2 = -1L;
            }
        }
        for (int i2 = 0; i2 < 8; ++i2) {
            outputStream.write((int)(l2 >>> i2 * 8) & 0xFF);
        }
        encoder.Code(inputStream, outputStream, -1L, -1L, null);
    }

    public static void decompress(InputStream inputStream, OutputStream outputStream) {
        byte[] byArray = new byte[5];
        if (inputStream.read(byArray, 0, 5) != 5) {
            throw new RuntimeException("input .lzma file is too short");
        }
        Decoder decoder = new Decoder();
        if (!decoder.SetDecoderProperties(byArray)) {
            throw new RuntimeException("Incorrect stream properties");
        }
        long l2 = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            int n2 = inputStream.read();
            if (n2 < 0) {
                throw new RuntimeException("Can't read stream size");
            }
            l2 |= (long)n2 << i2 * 8;
        }
        if (!decoder.Code(inputStream, outputStream, l2)) {
            throw new RuntimeException("Error in data stream");
        }
    }
}

