/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.compression.lzma;

import com.badlogic.gdx.utils.compression.lz.OutWindow;
import com.badlogic.gdx.utils.compression.lzma.Base;
import com.badlogic.gdx.utils.compression.lzma.Decoder$LenDecoder;
import com.badlogic.gdx.utils.compression.lzma.Decoder$LiteralDecoder;
import com.badlogic.gdx.utils.compression.lzma.Decoder$LiteralDecoder$Decoder2;
import com.badlogic.gdx.utils.compression.rangecoder.BitTreeDecoder;
import java.io.InputStream;
import java.io.OutputStream;

public class Decoder {
    OutWindow m_OutWindow = new OutWindow();
    com.badlogic.gdx.utils.compression.rangecoder.Decoder m_RangeDecoder = new com.badlogic.gdx.utils.compression.rangecoder.Decoder();
    short[] m_IsMatchDecoders = new short[192];
    short[] m_IsRepDecoders = new short[12];
    short[] m_IsRepG0Decoders = new short[12];
    short[] m_IsRepG1Decoders = new short[12];
    short[] m_IsRepG2Decoders = new short[12];
    short[] m_IsRep0LongDecoders = new short[192];
    BitTreeDecoder[] m_PosSlotDecoder = new BitTreeDecoder[4];
    short[] m_PosDecoders = new short[114];
    BitTreeDecoder m_PosAlignDecoder = new BitTreeDecoder(4);
    Decoder$LenDecoder m_LenDecoder = new Decoder$LenDecoder(this);
    Decoder$LenDecoder m_RepLenDecoder = new Decoder$LenDecoder(this);
    Decoder$LiteralDecoder m_LiteralDecoder = new Decoder$LiteralDecoder(this);
    int m_DictionarySize = -1;
    int m_DictionarySizeCheck = -1;
    int m_PosStateMask;

    public Decoder() {
        for (int i2 = 0; i2 < 4; ++i2) {
            this.m_PosSlotDecoder[i2] = new BitTreeDecoder(6);
        }
    }

    boolean SetDictionarySize(int n2) {
        if (n2 < 0) {
            return false;
        }
        if (this.m_DictionarySize != n2) {
            this.m_DictionarySize = n2;
            this.m_DictionarySizeCheck = Math.max(this.m_DictionarySize, 1);
            this.m_OutWindow.Create(Math.max(this.m_DictionarySizeCheck, 4096));
        }
        return true;
    }

    boolean SetLcLpPb(int n2, int n3, int n4) {
        if (n2 > 8 || n3 > 4 || n4 > 4) {
            return false;
        }
        this.m_LiteralDecoder.Create(n3, n2);
        n2 = 1 << n4;
        this.m_LenDecoder.Create(n2);
        this.m_RepLenDecoder.Create(n2);
        this.m_PosStateMask = n2 - 1;
        return true;
    }

    void Init() {
        this.m_OutWindow.Init(false);
        com.badlogic.gdx.utils.compression.rangecoder.Decoder.InitBitModels(this.m_IsMatchDecoders);
        com.badlogic.gdx.utils.compression.rangecoder.Decoder.InitBitModels(this.m_IsRep0LongDecoders);
        com.badlogic.gdx.utils.compression.rangecoder.Decoder.InitBitModels(this.m_IsRepDecoders);
        com.badlogic.gdx.utils.compression.rangecoder.Decoder.InitBitModels(this.m_IsRepG0Decoders);
        com.badlogic.gdx.utils.compression.rangecoder.Decoder.InitBitModels(this.m_IsRepG1Decoders);
        com.badlogic.gdx.utils.compression.rangecoder.Decoder.InitBitModels(this.m_IsRepG2Decoders);
        com.badlogic.gdx.utils.compression.rangecoder.Decoder.InitBitModels(this.m_PosDecoders);
        this.m_LiteralDecoder.Init();
        for (int i2 = 0; i2 < 4; ++i2) {
            this.m_PosSlotDecoder[i2].Init();
        }
        this.m_LenDecoder.Init();
        this.m_RepLenDecoder.Init();
        this.m_PosAlignDecoder.Init();
        this.m_RangeDecoder.Init();
    }

    public boolean Code(InputStream inputStream, OutputStream outputStream, long l2) {
        this.m_RangeDecoder.SetStream(inputStream);
        this.m_OutWindow.SetStream(outputStream);
        this.Init();
        int n2 = Base.StateInit();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        long l3 = 0L;
        int n7 = 0;
        while (l2 < 0L || l3 < l2) {
            int n8;
            int n9 = (int)l3 & this.m_PosStateMask;
            if (this.m_RangeDecoder.DecodeBit(this.m_IsMatchDecoders, (n2 << 4) + n9) == 0) {
                Decoder$LiteralDecoder$Decoder2 decoder$LiteralDecoder$Decoder2 = this.m_LiteralDecoder.GetDecoder((int)l3, (byte)n7);
                n7 = !Base.StateIsCharState(n2) ? decoder$LiteralDecoder$Decoder2.DecodeWithMatchByte(this.m_RangeDecoder, this.m_OutWindow.GetByte(n3)) : decoder$LiteralDecoder$Decoder2.DecodeNormal(this.m_RangeDecoder);
                this.m_OutWindow.PutByte((byte)n7);
                n2 = Base.StateUpdateChar(n2);
                ++l3;
                continue;
            }
            if (this.m_RangeDecoder.DecodeBit(this.m_IsRepDecoders, n2) == 1) {
                n7 = 0;
                if (this.m_RangeDecoder.DecodeBit(this.m_IsRepG0Decoders, n2) == 0) {
                    if (this.m_RangeDecoder.DecodeBit(this.m_IsRep0LongDecoders, (n2 << 4) + n9) == 0) {
                        n2 = Base.StateUpdateShortRep(n2);
                        n7 = 1;
                    }
                } else {
                    if (this.m_RangeDecoder.DecodeBit(this.m_IsRepG1Decoders, n2) == 0) {
                        n8 = n4;
                    } else {
                        if (this.m_RangeDecoder.DecodeBit(this.m_IsRepG2Decoders, n2) == 0) {
                            n8 = n5;
                        } else {
                            n8 = n6;
                            n6 = n5;
                        }
                        n5 = n4;
                    }
                    n4 = n3;
                    n3 = n8;
                }
                if (n7 == 0) {
                    n7 = this.m_RepLenDecoder.Decode(this.m_RangeDecoder, n9) + 2;
                    n2 = Base.StateUpdateRep(n2);
                }
            } else {
                n6 = n5;
                n5 = n4;
                n4 = n3;
                n7 = 2 + this.m_LenDecoder.Decode(this.m_RangeDecoder, n9);
                n2 = Base.StateUpdateMatch(n2);
                n8 = this.m_PosSlotDecoder[Base.GetLenToPosState(n7)].Decode(this.m_RangeDecoder);
                if (n8 >= 4) {
                    n9 = (n8 >> 1) - 1;
                    n3 = (2 | n8 & 1) << n9;
                    if (n8 < 14) {
                        n3 += BitTreeDecoder.ReverseDecode(this.m_PosDecoders, n3 - n8 - 1, this.m_RangeDecoder, n9);
                    } else {
                        n3 += this.m_RangeDecoder.DecodeDirectBits(n9 - 4) << 4;
                        if ((n3 += this.m_PosAlignDecoder.ReverseDecode(this.m_RangeDecoder)) < 0) {
                            if (n3 == -1) break;
                            return false;
                        }
                    }
                } else {
                    n3 = n8;
                }
            }
            if ((long)n3 >= l3 || n3 >= this.m_DictionarySizeCheck) {
                return false;
            }
            this.m_OutWindow.CopyBlock(n3, n7);
            l3 += (long)n7;
            n7 = this.m_OutWindow.GetByte(0);
        }
        this.m_OutWindow.Flush();
        this.m_OutWindow.ReleaseStream();
        this.m_RangeDecoder.ReleaseStream();
        return true;
    }

    public boolean SetDecoderProperties(byte[] byArray) {
        if (byArray.length < 5) {
            return false;
        }
        int n2 = byArray[0] & 0xFF;
        int n3 = n2 % 9;
        int n4 = (n2 /= 9) % 5;
        n2 /= 5;
        int n5 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            n5 += (byArray[i2 + 1] & 0xFF) << (i2 << 3);
        }
        if (!this.SetLcLpPb(n3, n4, n2)) {
            return false;
        }
        return this.SetDictionarySize(n5);
    }
}

