/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.reflect;

import com.badlogic.gdx.utils.reflect.Annotation;
import com.badlogic.gdx.utils.reflect.Constructor;
import com.badlogic.gdx.utils.reflect.Field;
import com.badlogic.gdx.utils.reflect.Method;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.lang.reflect.Modifier;

public final class ClassReflection {
    public static Class forName(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException("Class not found: " + string, classNotFoundException);
        }
    }

    public static String getSimpleName(Class clazz) {
        return clazz.getSimpleName();
    }

    public static boolean isInstance(Class clazz, Object object) {
        return clazz.isInstance(object);
    }

    public static boolean isAssignableFrom(Class clazz, Class clazz2) {
        return clazz.isAssignableFrom(clazz2);
    }

    public static boolean isMemberClass(Class clazz) {
        return clazz.isMemberClass();
    }

    public static boolean isStaticClass(Class clazz) {
        return Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean isArray(Class clazz) {
        return clazz.isArray();
    }

    public static boolean isPrimitive(Class clazz) {
        return clazz.isPrimitive();
    }

    public static boolean isEnum(Class clazz) {
        return clazz.isEnum();
    }

    public static boolean isAnnotation(Class clazz) {
        return clazz.isAnnotation();
    }

    public static boolean isInterface(Class clazz) {
        return clazz.isInterface();
    }

    public static boolean isAbstract(Class clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectionException("Could not instantiate instance of class: " + clazz.getName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException("Could not instantiate instance of class: " + clazz.getName(), illegalAccessException);
        }
    }

    public static Class getComponentType(Class clazz) {
        return clazz.getComponentType();
    }

    public static Constructor[] getConstructors(Class constructorArray) {
        constructorArray = constructorArray.getConstructors();
        Constructor[] constructorArray2 = new Constructor[constructorArray.length];
        int n2 = constructorArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            constructorArray2[i2] = new Constructor(constructorArray[i2]);
        }
        return constructorArray2;
    }

    public static Constructor getConstructor(Class clazz, Class ... classArray) {
        try {
            return new Constructor(clazz.getConstructor(classArray));
        }
        catch (SecurityException securityException) {
            throw new ReflectionException("Security violation occurred while getting constructor for class: '" + clazz.getName() + "'.", securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException("Constructor not found for class: " + clazz.getName(), noSuchMethodException);
        }
    }

    public static Constructor getDeclaredConstructor(Class clazz, Class ... classArray) {
        try {
            return new Constructor(clazz.getDeclaredConstructor(classArray));
        }
        catch (SecurityException securityException) {
            throw new ReflectionException("Security violation while getting constructor for class: " + clazz.getName(), securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException("Constructor not found for class: " + clazz.getName(), noSuchMethodException);
        }
    }

    public static Object[] getEnumConstants(Class clazz) {
        return clazz.getEnumConstants();
    }

    public static Method[] getMethods(Class methodArray) {
        methodArray = methodArray.getMethods();
        Method[] methodArray2 = new Method[methodArray.length];
        int n2 = methodArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            methodArray2[i2] = new Method(methodArray[i2]);
        }
        return methodArray2;
    }

    public static Method getMethod(Class clazz, String string, Class ... classArray) {
        try {
            return new Method(clazz.getMethod(string, classArray));
        }
        catch (SecurityException securityException) {
            throw new ReflectionException("Security violation while getting method: " + string + ", for class: " + clazz.getName(), securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException("Method not found: " + string + ", for class: " + clazz.getName(), noSuchMethodException);
        }
    }

    public static Method[] getDeclaredMethods(Class methodArray) {
        methodArray = methodArray.getDeclaredMethods();
        Method[] methodArray2 = new Method[methodArray.length];
        int n2 = methodArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            methodArray2[i2] = new Method(methodArray[i2]);
        }
        return methodArray2;
    }

    public static Method getDeclaredMethod(Class clazz, String string, Class ... classArray) {
        try {
            return new Method(clazz.getDeclaredMethod(string, classArray));
        }
        catch (SecurityException securityException) {
            throw new ReflectionException("Security violation while getting method: " + string + ", for class: " + clazz.getName(), securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException("Method not found: " + string + ", for class: " + clazz.getName(), noSuchMethodException);
        }
    }

    public static Field[] getFields(Class fieldArray) {
        fieldArray = fieldArray.getFields();
        Field[] fieldArray2 = new Field[fieldArray.length];
        int n2 = fieldArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            fieldArray2[i2] = new Field(fieldArray[i2]);
        }
        return fieldArray2;
    }

    public static Field getField(Class clazz, String string) {
        try {
            return new Field(clazz.getField(string));
        }
        catch (SecurityException securityException) {
            throw new ReflectionException("Security violation while getting field: " + string + ", for class: " + clazz.getName(), securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectionException("Field not found: " + string + ", for class: " + clazz.getName(), noSuchFieldException);
        }
    }

    public static Field[] getDeclaredFields(Class fieldArray) {
        fieldArray = fieldArray.getDeclaredFields();
        Field[] fieldArray2 = new Field[fieldArray.length];
        int n2 = fieldArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            fieldArray2[i2] = new Field(fieldArray[i2]);
        }
        return fieldArray2;
    }

    public static Field getDeclaredField(Class clazz, String string) {
        try {
            return new Field(clazz.getDeclaredField(string));
        }
        catch (SecurityException securityException) {
            throw new ReflectionException("Security violation while getting field: " + string + ", for class: " + clazz.getName(), securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectionException("Field not found: " + string + ", for class: " + clazz.getName(), noSuchFieldException);
        }
    }

    public static boolean isAnnotationPresent(Class clazz, Class<? extends java.lang.annotation.Annotation> clazz2) {
        return clazz.isAnnotationPresent(clazz2);
    }

    public static Annotation[] getAnnotations(Class annotationArray) {
        annotationArray = annotationArray.getAnnotations();
        Annotation[] annotationArray2 = new Annotation[annotationArray.length];
        for (int i2 = 0; i2 < annotationArray.length; ++i2) {
            annotationArray2[i2] = new Annotation(annotationArray[i2]);
        }
        return annotationArray2;
    }

    public static Annotation getAnnotation(Class object, Class<? extends java.lang.annotation.Annotation> clazz) {
        if ((object = ((Class)object).getAnnotation(clazz)) != null) {
            return new Annotation((java.lang.annotation.Annotation)object);
        }
        return null;
    }

    public static Annotation[] getDeclaredAnnotations(Class annotationArray) {
        annotationArray = annotationArray.getDeclaredAnnotations();
        Annotation[] annotationArray2 = new Annotation[annotationArray.length];
        for (int i2 = 0; i2 < annotationArray.length; ++i2) {
            annotationArray2[i2] = new Annotation(annotationArray[i2]);
        }
        return annotationArray2;
    }

    public static Annotation getDeclaredAnnotation(Class annotationArray, Class<? extends java.lang.annotation.Annotation> clazz) {
        java.lang.annotation.Annotation[] annotationArray2 = annotationArray.getDeclaredAnnotations();
        annotationArray = annotationArray2;
        annotationArray = annotationArray2;
        int n2 = annotationArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            java.lang.annotation.Annotation annotation = annotationArray[i2];
            if (!annotation.annotationType().equals(clazz)) continue;
            return new Annotation(annotation);
        }
        return null;
    }

    public static Class[] getInterfaces(Class clazz) {
        return clazz.getInterfaces();
    }
}

