/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.annotation;

import com.fasterxml.jackson.annotation.JacksonAnnotationValue;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonFormat$Feature;
import com.fasterxml.jackson.annotation.JsonFormat$Features;
import com.fasterxml.jackson.annotation.JsonFormat$Shape;
import java.io.Serializable;
import java.util.Locale;
import java.util.TimeZone;

public class JsonFormat$Value
implements JacksonAnnotationValue<JsonFormat>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final JsonFormat$Value EMPTY = new JsonFormat$Value();
    private final String _pattern;
    private final JsonFormat$Shape _shape;
    private final Locale _locale;
    private final String _timezoneStr;
    private final Boolean _lenient;
    private final JsonFormat$Features _features;
    private transient TimeZone _timezone;

    public JsonFormat$Value() {
        this("", JsonFormat$Shape.ANY, "", "", JsonFormat$Features.empty(), null);
    }

    public JsonFormat$Value(JsonFormat jsonFormat) {
        this(jsonFormat.pattern(), jsonFormat.shape(), jsonFormat.locale(), jsonFormat.timezone(), JsonFormat$Features.construct(jsonFormat), jsonFormat.lenient().asBoolean());
    }

    public JsonFormat$Value(String string, JsonFormat$Shape jsonFormat$Shape, String string2, String string3, JsonFormat$Features jsonFormat$Features, Boolean bl) {
        this(string, jsonFormat$Shape, string2 == null || string2.length() == 0 || "##default".equals(string2) ? null : new Locale(string2), string3 == null || string3.length() == 0 || "##default".equals(string3) ? null : string3, null, jsonFormat$Features, bl);
    }

    public JsonFormat$Value(String string, JsonFormat$Shape jsonFormat$Shape, Locale locale, TimeZone timeZone, JsonFormat$Features jsonFormat$Features, Boolean bl) {
        this._pattern = string == null ? "" : string;
        this._shape = jsonFormat$Shape == null ? JsonFormat$Shape.ANY : jsonFormat$Shape;
        this._locale = locale;
        this._timezone = timeZone;
        this._timezoneStr = null;
        this._features = jsonFormat$Features == null ? JsonFormat$Features.empty() : jsonFormat$Features;
        this._lenient = bl;
    }

    public JsonFormat$Value(String string, JsonFormat$Shape jsonFormat$Shape, Locale locale, String string2, TimeZone timeZone, JsonFormat$Features jsonFormat$Features, Boolean bl) {
        this._pattern = string == null ? "" : string;
        this._shape = jsonFormat$Shape == null ? JsonFormat$Shape.ANY : jsonFormat$Shape;
        this._locale = locale;
        this._timezone = timeZone;
        this._timezoneStr = string2;
        this._features = jsonFormat$Features == null ? JsonFormat$Features.empty() : jsonFormat$Features;
        this._lenient = bl;
    }

    @Deprecated
    public JsonFormat$Value(String string, JsonFormat$Shape jsonFormat$Shape, Locale locale, String string2, TimeZone timeZone, JsonFormat$Features jsonFormat$Features) {
        this(string, jsonFormat$Shape, locale, string2, timeZone, jsonFormat$Features, null);
    }

    @Deprecated
    public JsonFormat$Value(String string, JsonFormat$Shape jsonFormat$Shape, String string2, String string3, JsonFormat$Features jsonFormat$Features) {
        this(string, jsonFormat$Shape, string2, string3, jsonFormat$Features, null);
    }

    @Deprecated
    public JsonFormat$Value(String string, JsonFormat$Shape jsonFormat$Shape, Locale locale, TimeZone timeZone, JsonFormat$Features jsonFormat$Features) {
        this(string, jsonFormat$Shape, locale, timeZone, jsonFormat$Features, null);
    }

    public static final JsonFormat$Value empty() {
        return EMPTY;
    }

    public static JsonFormat$Value merge(JsonFormat$Value jsonFormat$Value, JsonFormat$Value jsonFormat$Value2) {
        if (jsonFormat$Value == null) {
            return jsonFormat$Value2;
        }
        return jsonFormat$Value.withOverrides(jsonFormat$Value2);
    }

    public static JsonFormat$Value mergeAll(JsonFormat$Value ... jsonFormat$ValueArray) {
        JsonFormat$Value jsonFormat$Value = null;
        for (JsonFormat$Value jsonFormat$Value2 : jsonFormat$ValueArray) {
            if (jsonFormat$Value2 == null) continue;
            jsonFormat$Value = jsonFormat$Value == null ? jsonFormat$Value2 : jsonFormat$Value.withOverrides(jsonFormat$Value2);
        }
        return jsonFormat$Value;
    }

    public static final JsonFormat$Value from(JsonFormat jsonFormat) {
        if (jsonFormat == null) {
            return EMPTY;
        }
        return new JsonFormat$Value(jsonFormat);
    }

    public final JsonFormat$Value withOverrides(JsonFormat$Value serializable) {
        String string;
        JsonFormat$Features jsonFormat$Features;
        Locale locale;
        JsonFormat$Shape jsonFormat$Shape;
        if (serializable == null || serializable == EMPTY || serializable == this) {
            return this;
        }
        if (this == EMPTY) {
            return serializable;
        }
        String string2 = serializable._pattern;
        if (string2 == null || string2.isEmpty()) {
            string2 = this._pattern;
        }
        if ((jsonFormat$Shape = serializable._shape) == JsonFormat$Shape.ANY) {
            jsonFormat$Shape = this._shape;
        }
        if ((locale = serializable._locale) == null) {
            locale = this._locale;
        }
        jsonFormat$Features = (jsonFormat$Features = this._features) == null ? serializable._features : jsonFormat$Features.withOverrides(serializable._features);
        Boolean bl = serializable._lenient;
        if (bl == null) {
            bl = this._lenient;
        }
        if ((string = serializable._timezoneStr) == null || string.isEmpty()) {
            string = this._timezoneStr;
            serializable = this._timezone;
        } else {
            serializable = serializable._timezone;
        }
        return new JsonFormat$Value(string2, jsonFormat$Shape, locale, string, (TimeZone)serializable, jsonFormat$Features, bl);
    }

    public static JsonFormat$Value forPattern(String string) {
        return new JsonFormat$Value(string, null, null, null, null, JsonFormat$Features.empty(), null);
    }

    public static JsonFormat$Value forShape(JsonFormat$Shape jsonFormat$Shape) {
        return new JsonFormat$Value("", jsonFormat$Shape, null, null, null, JsonFormat$Features.empty(), null);
    }

    public static JsonFormat$Value forLeniency(boolean bl) {
        return new JsonFormat$Value("", null, null, null, null, JsonFormat$Features.empty(), bl);
    }

    public JsonFormat$Value withPattern(String string) {
        return new JsonFormat$Value(string, this._shape, this._locale, this._timezoneStr, this._timezone, this._features, this._lenient);
    }

    public JsonFormat$Value withShape(JsonFormat$Shape jsonFormat$Shape) {
        if (jsonFormat$Shape == this._shape) {
            return this;
        }
        return new JsonFormat$Value(this._pattern, jsonFormat$Shape, this._locale, this._timezoneStr, this._timezone, this._features, this._lenient);
    }

    public JsonFormat$Value withLocale(Locale locale) {
        return new JsonFormat$Value(this._pattern, this._shape, locale, this._timezoneStr, this._timezone, this._features, this._lenient);
    }

    public JsonFormat$Value withTimeZone(TimeZone timeZone) {
        return new JsonFormat$Value(this._pattern, this._shape, this._locale, null, timeZone, this._features, this._lenient);
    }

    public JsonFormat$Value withLenient(Boolean bl) {
        if (bl == this._lenient) {
            return this;
        }
        return new JsonFormat$Value(this._pattern, this._shape, this._locale, this._timezoneStr, this._timezone, this._features, bl);
    }

    public JsonFormat$Value withFeature(JsonFormat$Feature object) {
        if ((object = this._features.with(new JsonFormat$Feature[]{object})) == this._features) {
            return this;
        }
        return new JsonFormat$Value(this._pattern, this._shape, this._locale, this._timezoneStr, this._timezone, (JsonFormat$Features)object, this._lenient);
    }

    public JsonFormat$Value withoutFeature(JsonFormat$Feature object) {
        if ((object = this._features.without(new JsonFormat$Feature[]{object})) == this._features) {
            return this;
        }
        return new JsonFormat$Value(this._pattern, this._shape, this._locale, this._timezoneStr, this._timezone, (JsonFormat$Features)object, this._lenient);
    }

    @Override
    public Class<JsonFormat> valueFor() {
        return JsonFormat.class;
    }

    public String getPattern() {
        return this._pattern;
    }

    public JsonFormat$Shape getShape() {
        return this._shape;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public Boolean getLenient() {
        return this._lenient;
    }

    public boolean isLenient() {
        return Boolean.TRUE.equals(this._lenient);
    }

    public String timeZoneAsString() {
        if (this._timezone != null) {
            return this._timezone.getID();
        }
        return this._timezoneStr;
    }

    public TimeZone getTimeZone() {
        TimeZone timeZone = this._timezone;
        if (timeZone == null) {
            if (this._timezoneStr == null) {
                return null;
            }
            this._timezone = timeZone = TimeZone.getTimeZone(this._timezoneStr);
        }
        return timeZone;
    }

    public boolean hasShape() {
        return this._shape != JsonFormat$Shape.ANY;
    }

    public boolean hasPattern() {
        return this._pattern != null && this._pattern.length() > 0;
    }

    public boolean hasLocale() {
        return this._locale != null;
    }

    public boolean hasTimeZone() {
        return this._timezone != null || this._timezoneStr != null && !this._timezoneStr.isEmpty();
    }

    public boolean hasLenient() {
        return this._lenient != null;
    }

    public Boolean getFeature(JsonFormat$Feature jsonFormat$Feature) {
        return this._features.get(jsonFormat$Feature);
    }

    public JsonFormat$Features getFeatures() {
        return this._features;
    }

    public String toString() {
        return String.format("JsonFormat.Value(pattern=%s,shape=%s,lenient=%s,locale=%s,timezone=%s,features=%s)", new Object[]{this._pattern, this._shape, this._lenient, this._locale, this._timezoneStr, this._features});
    }

    public int hashCode() {
        int n2;
        int n3 = n2 = this._timezoneStr == null ? 1 : this._timezoneStr.hashCode();
        if (this._pattern != null) {
            n2 ^= this._pattern.hashCode();
        }
        n2 += this._shape.hashCode();
        if (this._lenient != null) {
            n2 ^= this._lenient.hashCode();
        }
        if (this._locale != null) {
            n2 += this._locale.hashCode();
        }
        return n2 ^= this._features.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        object = (JsonFormat$Value)object;
        if (this._shape != ((JsonFormat$Value)object)._shape || !this._features.equals(((JsonFormat$Value)object)._features)) {
            return false;
        }
        return JsonFormat$Value._equal(this._lenient, ((JsonFormat$Value)object)._lenient) && JsonFormat$Value._equal(this._timezoneStr, ((JsonFormat$Value)object)._timezoneStr) && JsonFormat$Value._equal(this._pattern, ((JsonFormat$Value)object)._pattern) && JsonFormat$Value._equal(this._timezone, ((JsonFormat$Value)object)._timezone) && JsonFormat$Value._equal(this._locale, ((JsonFormat$Value)object)._locale);
    }

    private static <T> boolean _equal(T t2, T t3) {
        if (t2 == null) {
            return t3 == null;
        }
        if (t3 == null) {
            return false;
        }
        return t2.equals(t3);
    }
}

