/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.json.JsonWriteFeature;

public class JsonFactoryBuilder
extends TSFBuilder<JsonFactory, JsonFactoryBuilder> {
    protected CharacterEscapes _characterEscapes;
    protected SerializableString _rootValueSeparator;
    protected int _maximumNonEscapedChar;
    protected char _quoteChar = (char)34;

    public JsonFactoryBuilder() {
        this._rootValueSeparator = JsonFactory.DEFAULT_ROOT_VALUE_SEPARATOR;
        this._maximumNonEscapedChar = 0;
    }

    public JsonFactoryBuilder(JsonFactory jsonFactory) {
        super(jsonFactory);
        this._characterEscapes = jsonFactory.getCharacterEscapes();
        this._rootValueSeparator = jsonFactory._rootValueSeparator;
        this._maximumNonEscapedChar = jsonFactory._maximumNonEscapedChar;
    }

    @Override
    public JsonFactoryBuilder enable(JsonReadFeature jsonReadFeature) {
        this._legacyEnable(jsonReadFeature.mappedFeature());
        return this;
    }

    @Override
    public JsonFactoryBuilder enable(JsonReadFeature jsonReadFeatureArray, JsonReadFeature ... jsonReadFeatureArray2) {
        this._legacyEnable(jsonReadFeatureArray.mappedFeature());
        this.enable((JsonReadFeature)jsonReadFeatureArray);
        jsonReadFeatureArray = jsonReadFeatureArray2;
        int n2 = jsonReadFeatureArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JsonReadFeature jsonReadFeature = jsonReadFeatureArray[i2];
            this._legacyEnable(jsonReadFeature.mappedFeature());
        }
        return this;
    }

    @Override
    public JsonFactoryBuilder disable(JsonReadFeature jsonReadFeature) {
        this._legacyDisable(jsonReadFeature.mappedFeature());
        return this;
    }

    @Override
    public JsonFactoryBuilder disable(JsonReadFeature jsonReadFeatureArray, JsonReadFeature ... jsonReadFeatureArray2) {
        this._legacyDisable(jsonReadFeatureArray.mappedFeature());
        jsonReadFeatureArray = jsonReadFeatureArray2;
        int n2 = jsonReadFeatureArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JsonReadFeature jsonReadFeature = jsonReadFeatureArray[i2];
            this._legacyEnable(jsonReadFeature.mappedFeature());
        }
        return this;
    }

    @Override
    public JsonFactoryBuilder configure(JsonReadFeature jsonReadFeature, boolean bl) {
        if (bl) {
            return this.enable(jsonReadFeature);
        }
        return this.disable(jsonReadFeature);
    }

    @Override
    public JsonFactoryBuilder enable(JsonWriteFeature enum_) {
        if ((enum_ = ((JsonWriteFeature)enum_).mappedFeature()) != null) {
            this._legacyEnable((JsonGenerator$Feature)enum_);
        }
        return this;
    }

    @Override
    public JsonFactoryBuilder enable(JsonWriteFeature jsonWriteFeatureArray, JsonWriteFeature ... jsonWriteFeatureArray2) {
        this._legacyEnable(jsonWriteFeatureArray.mappedFeature());
        jsonWriteFeatureArray = jsonWriteFeatureArray2;
        int n2 = jsonWriteFeatureArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JsonWriteFeature jsonWriteFeature = jsonWriteFeatureArray[i2];
            this._legacyEnable(jsonWriteFeature.mappedFeature());
        }
        return this;
    }

    @Override
    public JsonFactoryBuilder disable(JsonWriteFeature jsonWriteFeature) {
        this._legacyDisable(jsonWriteFeature.mappedFeature());
        return this;
    }

    @Override
    public JsonFactoryBuilder disable(JsonWriteFeature jsonWriteFeatureArray, JsonWriteFeature ... jsonWriteFeatureArray2) {
        this._legacyDisable(jsonWriteFeatureArray.mappedFeature());
        jsonWriteFeatureArray = jsonWriteFeatureArray2;
        int n2 = jsonWriteFeatureArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JsonWriteFeature jsonWriteFeature = jsonWriteFeatureArray[i2];
            this._legacyDisable(jsonWriteFeature.mappedFeature());
        }
        return this;
    }

    @Override
    public JsonFactoryBuilder configure(JsonWriteFeature jsonWriteFeature, boolean bl) {
        if (bl) {
            return this.enable(jsonWriteFeature);
        }
        return this.disable(jsonWriteFeature);
    }

    public JsonFactoryBuilder characterEscapes(CharacterEscapes characterEscapes) {
        this._characterEscapes = characterEscapes;
        return this;
    }

    public JsonFactoryBuilder rootValueSeparator(String string) {
        this._rootValueSeparator = string == null ? null : new SerializedString(string);
        return this;
    }

    public JsonFactoryBuilder rootValueSeparator(SerializableString serializableString) {
        this._rootValueSeparator = serializableString;
        return this;
    }

    public JsonFactoryBuilder highestNonEscapedChar(int n2) {
        this._maximumNonEscapedChar = n2 <= 0 ? 0 : Math.max(127, n2);
        return this;
    }

    public JsonFactoryBuilder quoteChar(char c2) {
        if (c2 > '\u007f') {
            throw new IllegalArgumentException("Can only use Unicode characters up to 0x7F as quote characters");
        }
        this._quoteChar = c2;
        return this;
    }

    public CharacterEscapes characterEscapes() {
        return this._characterEscapes;
    }

    public SerializableString rootValueSeparator() {
        return this._rootValueSeparator;
    }

    public int highestNonEscapedChar() {
        return this._maximumNonEscapedChar;
    }

    public char quoteChar() {
        return this._quoteChar;
    }

    @Override
    public JsonFactory build() {
        return new JsonFactory(this);
    }
}

