/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonParser$NumberType;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamWriteCapability;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.core.type.WritableTypeId$Inclusion;
import com.fasterxml.jackson.core.util.JacksonFeature;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.core.util.VersionUtil;
import java.io.Closeable;
import java.io.Flushable;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class JsonGenerator
implements Versioned,
Closeable,
Flushable {
    protected static final JacksonFeatureSet<StreamWriteCapability> DEFAULT_WRITE_CAPABILITIES = JacksonFeatureSet.fromDefaults((JacksonFeature[])StreamWriteCapability.values());
    public static final JacksonFeatureSet<StreamWriteCapability> DEFAULT_TEXTUAL_WRITE_CAPABILITIES = DEFAULT_WRITE_CAPABILITIES.with(StreamWriteCapability.CAN_WRITE_FORMATTED_NUMBERS);
    protected static final JacksonFeatureSet<StreamWriteCapability> DEFAULT_BINARY_WRITE_CAPABILITIES = DEFAULT_WRITE_CAPABILITIES.with(StreamWriteCapability.CAN_WRITE_BINARY_NATIVELY);
    public PrettyPrinter _cfgPrettyPrinter;

    public abstract JsonGenerator setCodec(ObjectCodec var1);

    public abstract ObjectCodec getCodec();

    @Override
    public abstract Version version();

    public abstract JsonStreamContext getOutputContext();

    public Object getOutputTarget() {
        return null;
    }

    public Object currentValue() {
        return this.getCurrentValue();
    }

    public void assignCurrentValue(Object object) {
        this.setCurrentValue(object);
    }

    public Object getCurrentValue() {
        JsonStreamContext jsonStreamContext = this.getOutputContext();
        if (jsonStreamContext == null) {
            return null;
        }
        return jsonStreamContext.getCurrentValue();
    }

    public void setCurrentValue(Object object) {
        JsonStreamContext jsonStreamContext = this.getOutputContext();
        if (jsonStreamContext != null) {
            jsonStreamContext.setCurrentValue(object);
        }
    }

    public abstract JsonGenerator enable(JsonGenerator$Feature var1);

    public abstract JsonGenerator disable(JsonGenerator$Feature var1);

    public final JsonGenerator configure(JsonGenerator$Feature jsonGenerator$Feature, boolean bl) {
        if (bl) {
            this.enable(jsonGenerator$Feature);
        } else {
            this.disable(jsonGenerator$Feature);
        }
        return this;
    }

    public abstract boolean isEnabled(JsonGenerator$Feature var1);

    public boolean isEnabled(StreamWriteFeature streamWriteFeature) {
        return this.isEnabled(streamWriteFeature.mappedFeature());
    }

    public abstract int getFeatureMask();

    @Deprecated
    public abstract JsonGenerator setFeatureMask(int var1);

    public JsonGenerator overrideStdFeatures(int n2, int n3) {
        int n4 = this.getFeatureMask();
        n2 = n4 & ~n3 | n2 & n3;
        return this.setFeatureMask(n2);
    }

    public int getFormatFeatures() {
        return 0;
    }

    public JsonGenerator overrideFormatFeatures(int n2, int n3) {
        return this;
    }

    public void setSchema(FormatSchema formatSchema) {
        throw new UnsupportedOperationException(String.format("Generator of type %s does not support schema of type '%s'", this.getClass().getName(), formatSchema.getSchemaType()));
    }

    public FormatSchema getSchema() {
        return null;
    }

    public JsonGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this._cfgPrettyPrinter = prettyPrinter;
        return this;
    }

    public PrettyPrinter getPrettyPrinter() {
        return this._cfgPrettyPrinter;
    }

    public abstract JsonGenerator useDefaultPrettyPrinter();

    public JsonGenerator setHighestNonEscapedChar(int n2) {
        return this;
    }

    public int getHighestEscapedChar() {
        return 0;
    }

    public CharacterEscapes getCharacterEscapes() {
        return null;
    }

    public JsonGenerator setCharacterEscapes(CharacterEscapes characterEscapes) {
        return this;
    }

    public JsonGenerator setRootValueSeparator(SerializableString serializableString) {
        throw new UnsupportedOperationException();
    }

    public int getOutputBuffered() {
        return -1;
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        return false;
    }

    public boolean canWriteObjectId() {
        return false;
    }

    public boolean canWriteTypeId() {
        return false;
    }

    public boolean canWriteBinaryNatively() {
        return false;
    }

    public boolean canOmitFields() {
        return true;
    }

    public boolean canWriteFormattedNumbers() {
        return false;
    }

    public JacksonFeatureSet<StreamWriteCapability> getWriteCapabilities() {
        return DEFAULT_WRITE_CAPABILITIES;
    }

    public abstract void writeStartArray();

    @Deprecated
    public void writeStartArray(int n2) {
        this.writeStartArray();
    }

    public void writeStartArray(Object object) {
        this.writeStartArray();
        this.setCurrentValue(object);
    }

    public void writeStartArray(Object object, int n2) {
        this.writeStartArray(n2);
        this.setCurrentValue(object);
    }

    public abstract void writeEndArray();

    public abstract void writeStartObject();

    public void writeStartObject(Object object) {
        this.writeStartObject();
        this.setCurrentValue(object);
    }

    public void writeStartObject(Object object, int n2) {
        this.writeStartObject();
        this.setCurrentValue(object);
    }

    public abstract void writeEndObject();

    public abstract void writeFieldName(String var1);

    public abstract void writeFieldName(SerializableString var1);

    public void writeFieldId(long l2) {
        this.writeFieldName(Long.toString(l2));
    }

    public void writeArray(int[] nArray, int n2, int n3) {
        if (nArray == null) {
            throw new IllegalArgumentException("null array");
        }
        this._verifyOffsets(nArray.length, n2, n3);
        this.writeStartArray(nArray, n3);
        int n4 = n2;
        n2 += n3;
        while (n4 < n2) {
            this.writeNumber(nArray[n4]);
            ++n4;
        }
        this.writeEndArray();
    }

    public void writeArray(long[] lArray, int n2, int n3) {
        if (lArray == null) {
            throw new IllegalArgumentException("null array");
        }
        this._verifyOffsets(lArray.length, n2, n3);
        this.writeStartArray(lArray, n3);
        int n4 = n2;
        n2 += n3;
        while (n4 < n2) {
            this.writeNumber(lArray[n4]);
            ++n4;
        }
        this.writeEndArray();
    }

    public void writeArray(double[] dArray, int n2, int n3) {
        if (dArray == null) {
            throw new IllegalArgumentException("null array");
        }
        this._verifyOffsets(dArray.length, n2, n3);
        this.writeStartArray(dArray, n3);
        int n4 = n2;
        n2 += n3;
        while (n4 < n2) {
            this.writeNumber(dArray[n4]);
            ++n4;
        }
        this.writeEndArray();
    }

    public void writeArray(String[] stringArray, int n2, int n3) {
        if (stringArray == null) {
            throw new IllegalArgumentException("null array");
        }
        this._verifyOffsets(stringArray.length, n2, n3);
        this.writeStartArray(stringArray, n3);
        int n4 = n2;
        n2 += n3;
        while (n4 < n2) {
            this.writeString(stringArray[n4]);
            ++n4;
        }
        this.writeEndArray();
    }

    public abstract void writeString(String var1);

    public void writeString(Reader reader, int n2) {
        this._reportUnsupportedOperation();
    }

    public abstract void writeString(char[] var1, int var2, int var3);

    public abstract void writeString(SerializableString var1);

    public abstract void writeRawUTF8String(byte[] var1, int var2, int var3);

    public abstract void writeUTF8String(byte[] var1, int var2, int var3);

    public abstract void writeRaw(String var1);

    public abstract void writeRaw(String var1, int var2, int var3);

    public abstract void writeRaw(char[] var1, int var2, int var3);

    public abstract void writeRaw(char var1);

    public void writeRaw(SerializableString serializableString) {
        this.writeRaw(serializableString.getValue());
    }

    public abstract void writeRawValue(String var1);

    public abstract void writeRawValue(String var1, int var2, int var3);

    public abstract void writeRawValue(char[] var1, int var2, int var3);

    public void writeRawValue(SerializableString serializableString) {
        this.writeRawValue(serializableString.getValue());
    }

    public abstract void writeBinary(Base64Variant var1, byte[] var2, int var3, int var4);

    public void writeBinary(byte[] byArray, int n2, int n3) {
        this.writeBinary(Base64Variants.getDefaultVariant(), byArray, n2, n3);
    }

    public void writeBinary(byte[] byArray) {
        this.writeBinary(Base64Variants.getDefaultVariant(), byArray, 0, byArray.length);
    }

    public int writeBinary(InputStream inputStream, int n2) {
        return this.writeBinary(Base64Variants.getDefaultVariant(), inputStream, n2);
    }

    public abstract int writeBinary(Base64Variant var1, InputStream var2, int var3);

    public void writeNumber(short s2) {
        this.writeNumber((int)s2);
    }

    public abstract void writeNumber(int var1);

    public abstract void writeNumber(long var1);

    public abstract void writeNumber(BigInteger var1);

    public abstract void writeNumber(double var1);

    public abstract void writeNumber(float var1);

    public abstract void writeNumber(BigDecimal var1);

    public abstract void writeNumber(String var1);

    public void writeNumber(char[] cArray, int n2, int n3) {
        this.writeNumber(new String(cArray, n2, n3));
    }

    public abstract void writeBoolean(boolean var1);

    public abstract void writeNull();

    public void writeEmbeddedObject(Object object) {
        if (object == null) {
            this.writeNull();
            return;
        }
        if (object instanceof byte[]) {
            this.writeBinary((byte[])object);
            return;
        }
        throw new JsonGenerationException("No native support for writing embedded objects of type " + object.getClass().getName(), this);
    }

    public void writeObjectId(Object object) {
        throw new JsonGenerationException("No native support for writing Object Ids", this);
    }

    public void writeObjectRef(Object object) {
        throw new JsonGenerationException("No native support for writing Object Ids", this);
    }

    public void writeTypeId(Object object) {
        throw new JsonGenerationException("No native support for writing Type Ids", this);
    }

    public WritableTypeId writeTypePrefix(WritableTypeId writableTypeId) {
        Object object = writableTypeId.id;
        JsonToken jsonToken = writableTypeId.valueShape;
        if (this.canWriteTypeId()) {
            writableTypeId.wrapperWritten = false;
            this.writeTypeId(object);
        } else {
            object = object instanceof String ? (String)object : String.valueOf(object);
            writableTypeId.wrapperWritten = true;
            WritableTypeId$Inclusion writableTypeId$Inclusion = writableTypeId.include;
            if (jsonToken != JsonToken.START_OBJECT && writableTypeId$Inclusion.requiresObjectContext()) {
                writableTypeId.include = writableTypeId$Inclusion = WritableTypeId$Inclusion.WRAPPER_ARRAY;
            }
            switch (writableTypeId$Inclusion) {
                case PARENT_PROPERTY: {
                    break;
                }
                case PAYLOAD_PROPERTY: {
                    break;
                }
                case METADATA_PROPERTY: {
                    this.writeStartObject(writableTypeId.forValue);
                    this.writeStringField(writableTypeId.asProperty, (String)object);
                    return writableTypeId;
                }
                case WRAPPER_OBJECT: {
                    this.writeStartObject();
                    this.writeFieldName((String)object);
                    break;
                }
                default: {
                    this.writeStartArray();
                    this.writeString((String)object);
                }
            }
        }
        if (jsonToken == JsonToken.START_OBJECT) {
            this.writeStartObject(writableTypeId.forValue);
        } else if (jsonToken == JsonToken.START_ARRAY) {
            this.writeStartArray();
        }
        return writableTypeId;
    }

    public WritableTypeId writeTypeSuffix(WritableTypeId writableTypeId) {
        Object object = writableTypeId.valueShape;
        if (object == JsonToken.START_OBJECT) {
            this.writeEndObject();
        } else if (object == JsonToken.START_ARRAY) {
            this.writeEndArray();
        }
        if (writableTypeId.wrapperWritten) {
            switch (writableTypeId.include) {
                case WRAPPER_ARRAY: {
                    this.writeEndArray();
                    break;
                }
                case PARENT_PROPERTY: {
                    object = writableTypeId.id;
                    object = object instanceof String ? (String)object : String.valueOf(object);
                    this.writeStringField(writableTypeId.asProperty, (String)object);
                    break;
                }
                case PAYLOAD_PROPERTY: 
                case METADATA_PROPERTY: {
                    break;
                }
                default: {
                    this.writeEndObject();
                }
            }
        }
        return writableTypeId;
    }

    public void writePOJO(Object object) {
        this.writeObject(object);
    }

    public abstract void writeObject(Object var1);

    public abstract void writeTree(TreeNode var1);

    public void writeBinaryField(String string, byte[] byArray) {
        this.writeFieldName(string);
        this.writeBinary(byArray);
    }

    public void writeBooleanField(String string, boolean bl) {
        this.writeFieldName(string);
        this.writeBoolean(bl);
    }

    public void writeNullField(String string) {
        this.writeFieldName(string);
        this.writeNull();
    }

    public void writeStringField(String string, String string2) {
        this.writeFieldName(string);
        this.writeString(string2);
    }

    public void writeNumberField(String string, short s2) {
        this.writeFieldName(string);
        this.writeNumber(s2);
    }

    public void writeNumberField(String string, int n2) {
        this.writeFieldName(string);
        this.writeNumber(n2);
    }

    public void writeNumberField(String string, long l2) {
        this.writeFieldName(string);
        this.writeNumber(l2);
    }

    public void writeNumberField(String string, BigInteger bigInteger) {
        this.writeFieldName(string);
        this.writeNumber(bigInteger);
    }

    public void writeNumberField(String string, float f2) {
        this.writeFieldName(string);
        this.writeNumber(f2);
    }

    public void writeNumberField(String string, double d2) {
        this.writeFieldName(string);
        this.writeNumber(d2);
    }

    public void writeNumberField(String string, BigDecimal bigDecimal) {
        this.writeFieldName(string);
        this.writeNumber(bigDecimal);
    }

    public void writeArrayFieldStart(String string) {
        this.writeFieldName(string);
        this.writeStartArray();
    }

    public void writeObjectFieldStart(String string) {
        this.writeFieldName(string);
        this.writeStartObject();
    }

    public void writePOJOField(String string, Object object) {
        this.writeObjectField(string, object);
    }

    public void writeObjectField(String string, Object object) {
        this.writeFieldName(string);
        this.writeObject(object);
    }

    public void writeOmittedField(String string) {
    }

    public void copyCurrentEvent(JsonParser jsonParser) {
        Enum enum_ = jsonParser.currentToken();
        int n2 = enum_ == null ? -1 : ((JsonToken)enum_).id();
        switch (n2) {
            case -1: {
                this._reportError("No current event to copy");
                return;
            }
            case 1: {
                this.writeStartObject();
                return;
            }
            case 2: {
                this.writeEndObject();
                return;
            }
            case 3: {
                this.writeStartArray();
                return;
            }
            case 4: {
                this.writeEndArray();
                return;
            }
            case 5: {
                this.writeFieldName(jsonParser.getCurrentName());
                return;
            }
            case 6: {
                if (jsonParser.hasTextCharacters()) {
                    this.writeString(jsonParser.getTextCharacters(), jsonParser.getTextOffset(), jsonParser.getTextLength());
                    return;
                }
                this.writeString(jsonParser.getText());
                return;
            }
            case 7: {
                enum_ = jsonParser.getNumberType();
                if (enum_ == JsonParser$NumberType.INT) {
                    this.writeNumber(jsonParser.getIntValue());
                    return;
                }
                if (enum_ == JsonParser$NumberType.BIG_INTEGER) {
                    this.writeNumber(jsonParser.getBigIntegerValue());
                    return;
                }
                this.writeNumber(jsonParser.getLongValue());
                return;
            }
            case 8: {
                enum_ = jsonParser.getNumberType();
                if (enum_ == JsonParser$NumberType.BIG_DECIMAL) {
                    this.writeNumber(jsonParser.getDecimalValue());
                    return;
                }
                if (enum_ == JsonParser$NumberType.FLOAT) {
                    this.writeNumber(jsonParser.getFloatValue());
                    return;
                }
                this.writeNumber(jsonParser.getDoubleValue());
                return;
            }
            case 9: {
                this.writeBoolean(true);
                return;
            }
            case 10: {
                this.writeBoolean(false);
                return;
            }
            case 11: {
                this.writeNull();
                return;
            }
            case 12: {
                this.writeObject(jsonParser.getEmbeddedObject());
                return;
            }
        }
        throw new IllegalStateException("Internal error: unknown current token, " + enum_);
    }

    public void copyCurrentStructure(JsonParser jsonParser) {
        JsonToken jsonToken = jsonParser.currentToken();
        int n2 = jsonToken == null ? -1 : jsonToken.id();
        if (n2 == 5) {
            this.writeFieldName(jsonParser.getCurrentName());
            JsonToken jsonToken2 = jsonParser.nextToken();
            n2 = jsonToken2 == null ? -1 : jsonToken2.id();
        }
        switch (n2) {
            case 1: {
                this.writeStartObject();
                this._copyCurrentContents(jsonParser);
                return;
            }
            case 3: {
                this.writeStartArray();
                this._copyCurrentContents(jsonParser);
                return;
            }
        }
        this.copyCurrentEvent(jsonParser);
    }

    protected void _copyCurrentContents(JsonParser jsonParser) {
        Enum enum_;
        int n2 = 1;
        block14: while ((enum_ = jsonParser.nextToken()) != null) {
            switch (((JsonToken)enum_).id()) {
                case 5: {
                    this.writeFieldName(jsonParser.getCurrentName());
                    continue block14;
                }
                case 3: {
                    this.writeStartArray();
                    ++n2;
                    continue block14;
                }
                case 1: {
                    this.writeStartObject();
                    ++n2;
                    continue block14;
                }
                case 4: {
                    this.writeEndArray();
                    if (--n2 != 0) continue block14;
                    return;
                }
                case 2: {
                    this.writeEndObject();
                    if (--n2 != 0) continue block14;
                    return;
                }
                case 6: {
                    if (jsonParser.hasTextCharacters()) {
                        this.writeString(jsonParser.getTextCharacters(), jsonParser.getTextOffset(), jsonParser.getTextLength());
                        continue block14;
                    }
                    this.writeString(jsonParser.getText());
                    continue block14;
                }
                case 7: {
                    enum_ = jsonParser.getNumberType();
                    if (enum_ == JsonParser$NumberType.INT) {
                        this.writeNumber(jsonParser.getIntValue());
                        continue block14;
                    }
                    if (enum_ == JsonParser$NumberType.BIG_INTEGER) {
                        this.writeNumber(jsonParser.getBigIntegerValue());
                        continue block14;
                    }
                    this.writeNumber(jsonParser.getLongValue());
                    continue block14;
                }
                case 8: {
                    enum_ = jsonParser.getNumberType();
                    if (enum_ == JsonParser$NumberType.BIG_DECIMAL) {
                        this.writeNumber(jsonParser.getDecimalValue());
                        continue block14;
                    }
                    if (enum_ == JsonParser$NumberType.FLOAT) {
                        this.writeNumber(jsonParser.getFloatValue());
                        continue block14;
                    }
                    this.writeNumber(jsonParser.getDoubleValue());
                    continue block14;
                }
                case 9: {
                    this.writeBoolean(true);
                    continue block14;
                }
                case 10: {
                    this.writeBoolean(false);
                    continue block14;
                }
                case 11: {
                    this.writeNull();
                    continue block14;
                }
                case 12: {
                    this.writeObject(jsonParser.getEmbeddedObject());
                    continue block14;
                }
            }
            throw new IllegalStateException("Internal error: unknown current token, " + enum_);
        }
    }

    @Override
    public abstract void flush();

    public abstract boolean isClosed();

    @Override
    public abstract void close();

    protected void _reportError(String string) {
        throw new JsonGenerationException(string, this);
    }

    protected final void _throwInternal() {
        VersionUtil.throwInternal();
    }

    protected void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Operation not supported by generator of type " + this.getClass().getName());
    }

    protected final void _verifyOffsets(int n2, int n3, int n4) {
        if (n3 < 0 || n3 + n4 > n2) {
            throw new IllegalArgumentException(String.format("invalid argument(s) (offset=%d, length=%d) for input array of %d element", n3, n4, n2));
        }
    }

    protected void _writeSimpleObject(Object object) {
        if (object == null) {
            this.writeNull();
            return;
        }
        if (object instanceof String) {
            this.writeString((String)object);
            return;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (number instanceof Integer) {
                this.writeNumber(number.intValue());
                return;
            }
            if (number instanceof Long) {
                this.writeNumber(number.longValue());
                return;
            }
            if (number instanceof Double) {
                this.writeNumber(number.doubleValue());
                return;
            }
            if (number instanceof Float) {
                this.writeNumber(number.floatValue());
                return;
            }
            if (number instanceof Short) {
                this.writeNumber(number.shortValue());
                return;
            }
            if (number instanceof Byte) {
                this.writeNumber(number.byteValue());
                return;
            }
            if (number instanceof BigInteger) {
                this.writeNumber((BigInteger)number);
                return;
            }
            if (number instanceof BigDecimal) {
                this.writeNumber((BigDecimal)number);
                return;
            }
            if (number instanceof AtomicInteger) {
                this.writeNumber(((AtomicInteger)number).get());
                return;
            }
            if (number instanceof AtomicLong) {
                this.writeNumber(((AtomicLong)number).get());
                return;
            }
        } else {
            if (object instanceof byte[]) {
                this.writeBinary((byte[])object);
                return;
            }
            if (object instanceof Boolean) {
                this.writeBoolean((Boolean)object);
                return;
            }
            if (object instanceof AtomicBoolean) {
                this.writeBoolean(((AtomicBoolean)object).get());
                return;
            }
        }
        throw new IllegalStateException("No ObjectCodec defined for the generator, can only serialize simple wrapper types (type passed " + object.getClass().getName() + ")");
    }
}

