/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactory$Feature;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.io.InputDecorator;
import com.fasterxml.jackson.core.io.OutputDecorator;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.json.JsonWriteFeature;

public abstract class TSFBuilder<F extends JsonFactory, B extends TSFBuilder<F, B>> {
    protected static final int DEFAULT_FACTORY_FEATURE_FLAGS = JsonFactory$Feature.collectDefaults();
    protected static final int DEFAULT_PARSER_FEATURE_FLAGS = JsonParser$Feature.collectDefaults();
    protected static final int DEFAULT_GENERATOR_FEATURE_FLAGS = JsonGenerator$Feature.collectDefaults();
    protected int _factoryFeatures;
    protected int _streamReadFeatures;
    protected int _streamWriteFeatures;
    protected InputDecorator _inputDecorator;
    protected OutputDecorator _outputDecorator;

    public TSFBuilder() {
        this._factoryFeatures = DEFAULT_FACTORY_FEATURE_FLAGS;
        this._streamReadFeatures = DEFAULT_PARSER_FEATURE_FLAGS;
        this._streamWriteFeatures = DEFAULT_GENERATOR_FEATURE_FLAGS;
        this._inputDecorator = null;
        this._outputDecorator = null;
    }

    public TSFBuilder(JsonFactory jsonFactory) {
        this(jsonFactory._factoryFeatures, jsonFactory._parserFeatures, jsonFactory._generatorFeatures);
    }

    protected TSFBuilder(int n2, int n3, int n4) {
        this._factoryFeatures = n2;
        this._streamReadFeatures = n3;
        this._streamWriteFeatures = n4;
    }

    public int factoryFeaturesMask() {
        return this._factoryFeatures;
    }

    public int streamReadFeatures() {
        return this._streamReadFeatures;
    }

    public int streamWriteFeatures() {
        return this._streamWriteFeatures;
    }

    public InputDecorator inputDecorator() {
        return this._inputDecorator;
    }

    public OutputDecorator outputDecorator() {
        return this._outputDecorator;
    }

    public B enable(JsonFactory$Feature jsonFactory$Feature) {
        this._factoryFeatures |= jsonFactory$Feature.getMask();
        return this._this();
    }

    public B disable(JsonFactory$Feature jsonFactory$Feature) {
        this._factoryFeatures &= ~jsonFactory$Feature.getMask();
        return this._this();
    }

    public B configure(JsonFactory$Feature jsonFactory$Feature, boolean bl) {
        if (bl) {
            return this.enable(jsonFactory$Feature);
        }
        return this.disable(jsonFactory$Feature);
    }

    public B enable(StreamReadFeature streamReadFeature) {
        this._streamReadFeatures |= streamReadFeature.mappedFeature().getMask();
        return this._this();
    }

    public B enable(StreamReadFeature streamReadFeatureArray, StreamReadFeature ... streamReadFeatureArray2) {
        this._streamReadFeatures |= streamReadFeatureArray.mappedFeature().getMask();
        streamReadFeatureArray = streamReadFeatureArray2;
        int n2 = streamReadFeatureArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StreamReadFeature streamReadFeature = streamReadFeatureArray[i2];
            this._streamReadFeatures |= streamReadFeature.mappedFeature().getMask();
        }
        return this._this();
    }

    public B disable(StreamReadFeature streamReadFeature) {
        this._streamReadFeatures &= ~streamReadFeature.mappedFeature().getMask();
        return this._this();
    }

    public B disable(StreamReadFeature streamReadFeatureArray, StreamReadFeature ... streamReadFeatureArray2) {
        this._streamReadFeatures &= ~streamReadFeatureArray.mappedFeature().getMask();
        streamReadFeatureArray = streamReadFeatureArray2;
        int n2 = streamReadFeatureArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StreamReadFeature streamReadFeature = streamReadFeatureArray[i2];
            this._streamReadFeatures &= ~streamReadFeature.mappedFeature().getMask();
        }
        return this._this();
    }

    public B configure(StreamReadFeature streamReadFeature, boolean bl) {
        if (bl) {
            return this.enable(streamReadFeature);
        }
        return this.disable(streamReadFeature);
    }

    public B enable(StreamWriteFeature streamWriteFeature) {
        this._streamWriteFeatures |= streamWriteFeature.mappedFeature().getMask();
        return this._this();
    }

    public B enable(StreamWriteFeature streamWriteFeatureArray, StreamWriteFeature ... streamWriteFeatureArray2) {
        this._streamWriteFeatures |= streamWriteFeatureArray.mappedFeature().getMask();
        streamWriteFeatureArray = streamWriteFeatureArray2;
        int n2 = streamWriteFeatureArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StreamWriteFeature streamWriteFeature = streamWriteFeatureArray[i2];
            this._streamWriteFeatures |= streamWriteFeature.mappedFeature().getMask();
        }
        return this._this();
    }

    public B disable(StreamWriteFeature streamWriteFeature) {
        this._streamWriteFeatures &= ~streamWriteFeature.mappedFeature().getMask();
        return this._this();
    }

    public B disable(StreamWriteFeature streamWriteFeatureArray, StreamWriteFeature ... streamWriteFeatureArray2) {
        this._streamWriteFeatures &= ~streamWriteFeatureArray.mappedFeature().getMask();
        streamWriteFeatureArray = streamWriteFeatureArray2;
        int n2 = streamWriteFeatureArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StreamWriteFeature streamWriteFeature = streamWriteFeatureArray[i2];
            this._streamWriteFeatures &= ~streamWriteFeature.mappedFeature().getMask();
        }
        return this._this();
    }

    public B configure(StreamWriteFeature streamWriteFeature, boolean bl) {
        if (bl) {
            return this.enable(streamWriteFeature);
        }
        return this.disable(streamWriteFeature);
    }

    public B enable(JsonReadFeature jsonReadFeature) {
        return this._failNonJSON(jsonReadFeature);
    }

    public B enable(JsonReadFeature jsonReadFeature, JsonReadFeature ... jsonReadFeatureArray) {
        return this._failNonJSON(jsonReadFeature);
    }

    public B disable(JsonReadFeature jsonReadFeature) {
        return this._failNonJSON(jsonReadFeature);
    }

    public B disable(JsonReadFeature jsonReadFeature, JsonReadFeature ... jsonReadFeatureArray) {
        return this._failNonJSON(jsonReadFeature);
    }

    public B configure(JsonReadFeature jsonReadFeature, boolean bl) {
        return this._failNonJSON(jsonReadFeature);
    }

    private B _failNonJSON(Object object) {
        throw new IllegalArgumentException("Feature " + object.getClass().getName() + "#" + object.toString() + " not supported for non-JSON backend");
    }

    public B enable(JsonWriteFeature jsonWriteFeature) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B enable(JsonWriteFeature jsonWriteFeature, JsonWriteFeature ... jsonWriteFeatureArray) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B disable(JsonWriteFeature jsonWriteFeature) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B disable(JsonWriteFeature jsonWriteFeature, JsonWriteFeature ... jsonWriteFeatureArray) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B configure(JsonWriteFeature jsonWriteFeature, boolean bl) {
        return this._failNonJSON(jsonWriteFeature);
    }

    public B inputDecorator(InputDecorator inputDecorator) {
        this._inputDecorator = inputDecorator;
        return this._this();
    }

    public B outputDecorator(OutputDecorator outputDecorator) {
        this._outputDecorator = outputDecorator;
        return this._this();
    }

    public abstract F build();

    protected final B _this() {
        return (B)this;
    }

    protected void _legacyEnable(JsonParser$Feature jsonParser$Feature) {
        if (jsonParser$Feature != null) {
            this._streamReadFeatures |= jsonParser$Feature.getMask();
        }
    }

    protected void _legacyDisable(JsonParser$Feature jsonParser$Feature) {
        if (jsonParser$Feature != null) {
            this._streamReadFeatures &= ~jsonParser$Feature.getMask();
        }
    }

    protected void _legacyEnable(JsonGenerator$Feature jsonGenerator$Feature) {
        if (jsonGenerator$Feature != null) {
            this._streamWriteFeatures |= jsonGenerator$Feature.getMask();
        }
    }

    protected void _legacyDisable(JsonGenerator$Feature jsonGenerator$Feature) {
        if (jsonGenerator$Feature != null) {
            this._streamWriteFeatures &= ~jsonGenerator$Feature.getMask();
        }
    }
}

