/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.format;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.format.DataFormatMatcher;
import com.fasterxml.jackson.core.format.InputAccessor$Std;
import com.fasterxml.jackson.core.format.MatchStrength;
import java.io.InputStream;
import java.util.Collection;

public class DataFormatDetector {
    public static final int DEFAULT_MAX_INPUT_LOOKAHEAD = 64;
    protected final JsonFactory[] _detectors;
    protected final MatchStrength _optimalMatch;
    protected final MatchStrength _minimalMatch;
    protected final int _maxInputLookahead;

    public DataFormatDetector(JsonFactory ... jsonFactoryArray) {
        this(jsonFactoryArray, MatchStrength.SOLID_MATCH, MatchStrength.WEAK_MATCH, 64);
    }

    public DataFormatDetector(Collection<JsonFactory> collection) {
        this(collection.toArray(new JsonFactory[0]));
    }

    private DataFormatDetector(JsonFactory[] jsonFactoryArray, MatchStrength matchStrength, MatchStrength matchStrength2, int n2) {
        this._detectors = jsonFactoryArray;
        this._optimalMatch = matchStrength;
        this._minimalMatch = matchStrength2;
        this._maxInputLookahead = n2;
    }

    public DataFormatDetector withOptimalMatch(MatchStrength matchStrength) {
        if (matchStrength == this._optimalMatch) {
            return this;
        }
        return new DataFormatDetector(this._detectors, matchStrength, this._minimalMatch, this._maxInputLookahead);
    }

    public DataFormatDetector withMinimalMatch(MatchStrength matchStrength) {
        if (matchStrength == this._minimalMatch) {
            return this;
        }
        return new DataFormatDetector(this._detectors, this._optimalMatch, matchStrength, this._maxInputLookahead);
    }

    public DataFormatDetector withMaxInputLookahead(int n2) {
        if (n2 == this._maxInputLookahead) {
            return this;
        }
        return new DataFormatDetector(this._detectors, this._optimalMatch, this._minimalMatch, n2);
    }

    public DataFormatMatcher findFormat(InputStream inputStream) {
        return this._findFormat(new InputAccessor$Std(inputStream, new byte[this._maxInputLookahead]));
    }

    public DataFormatMatcher findFormat(byte[] byArray) {
        return this._findFormat(new InputAccessor$Std(byArray));
    }

    public DataFormatMatcher findFormat(byte[] byArray, int n2, int n3) {
        return this._findFormat(new InputAccessor$Std(byArray, n2, n3));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = this._detectors.length;
        if (n2 > 0) {
            stringBuilder.append(((TokenStreamFactory)this._detectors[0]).getFormatName());
            for (int i2 = 1; i2 < n2; ++i2) {
                stringBuilder.append(", ");
                stringBuilder.append(((TokenStreamFactory)this._detectors[i2]).getFormatName());
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private DataFormatMatcher _findFormat(InputAccessor$Std inputAccessor$Std) {
        JsonFactory jsonFactory = null;
        Enum enum_ = null;
        JsonFactory[] jsonFactoryArray = this._detectors;
        int n2 = this._detectors.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JsonFactory jsonFactory2 = jsonFactoryArray[i2];
            inputAccessor$Std.reset();
            MatchStrength matchStrength = jsonFactory2.hasFormat(inputAccessor$Std);
            if (matchStrength == null || matchStrength.ordinal() < this._minimalMatch.ordinal() || jsonFactory != null && enum_.ordinal() >= matchStrength.ordinal()) continue;
            jsonFactory = jsonFactory2;
            enum_ = matchStrength;
            if (matchStrength.ordinal() >= this._optimalMatch.ordinal()) break;
        }
        return inputAccessor$Std.createMatcher(jsonFactory, (MatchStrength)enum_);
    }
}

