/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import java.math.BigDecimal;
import java.util.Arrays;

public final class BigDecimalParser {
    private static final int MAX_CHARS_TO_REPORT = 1000;
    private final char[] chars;

    BigDecimalParser(char[] cArray) {
        this.chars = cArray;
    }

    public static BigDecimal parse(String string) {
        return BigDecimalParser.parse(string.toCharArray());
    }

    public static BigDecimal parse(char[] cArray, int n2, int n3) {
        if (n2 > 0 || n3 != cArray.length) {
            int n4 = n2;
            cArray = Arrays.copyOfRange(cArray, n4, n4 + n3);
        }
        return BigDecimalParser.parse(cArray);
    }

    public static BigDecimal parse(char[] object) {
        int n2 = ((char[])object).length;
        try {
            if (n2 < 500) {
                return new BigDecimal((char[])object);
            }
            return new BigDecimalParser((char[])object).parseBigDecimal(n2 / 10);
        }
        catch (NumberFormatException numberFormatException) {
            Object object2 = numberFormatException;
            object2 = numberFormatException.getMessage();
            if (object2 == null) {
                object2 = "Not a valid number representation";
            }
            object = ((char[])object).length <= 1000 ? (Object)new String((char[])object) : (Object)(new String(Arrays.copyOfRange((char[])object, 0, 1000)) + "(truncated, full length is " + ((char[])object).length + " chars)");
            throw new NumberFormatException("Value \"" + (String)object + "\" can not be represented as `java.math.BigDecimal`, reason: " + (String)object2);
        }
    }

    private BigDecimal parseBigDecimal(int n2) {
        BigDecimal bigDecimal;
        int n3;
        int n4;
        boolean bl = false;
        int n5 = 0;
        boolean bl2 = false;
        int n6 = 0;
        int n7 = -1;
        int n8 = -1;
        int n9 = 0;
        int n10 = this.chars.length;
        block6: for (n4 = 0; n4 < n10; ++n4) {
            n3 = this.chars[n4];
            switch (n3) {
                case 43: {
                    if (n7 >= 0) {
                        if (n5 != 0) {
                            throw new NumberFormatException("Multiple signs in exponent");
                        }
                        n5 = 1;
                        continue block6;
                    }
                    if (bl) {
                        throw new NumberFormatException("Multiple signs in number");
                    }
                    bl = true;
                    n6 = n4 + 1;
                    continue block6;
                }
                case 45: {
                    if (n7 >= 0) {
                        if (n5 != 0) {
                            throw new NumberFormatException("Multiple signs in exponent");
                        }
                        n5 = 1;
                        continue block6;
                    }
                    if (bl) {
                        throw new NumberFormatException("Multiple signs in number");
                    }
                    bl = true;
                    bl2 = true;
                    n6 = n4 + 1;
                    continue block6;
                }
                case 69: 
                case 101: {
                    if (n7 >= 0) {
                        throw new NumberFormatException("Multiple exponent markers");
                    }
                    n7 = n4;
                    continue block6;
                }
                case 46: {
                    if (n8 >= 0) {
                        throw new NumberFormatException("Multiple decimal points");
                    }
                    n8 = n4;
                    continue block6;
                }
                default: {
                    if (n8 < 0 || n7 != -1) continue block6;
                    ++n9;
                }
            }
        }
        n3 = 0;
        if (n7 >= 0) {
            n4 = n7;
            String string = new String(this.chars, n7 + 1, n10 - n7 - 1);
            n3 = Integer.parseInt(string);
            n9 = this.adjustScale(n9, n3);
        } else {
            n4 = n10;
        }
        if (n8 >= 0) {
            int n11 = n8 - n6;
            bigDecimal = this.toBigDecimalRec(n6, n11, n3, n2);
            n5 = n4 - n8 - 1;
            BigDecimal bigDecimal2 = this.toBigDecimalRec(n8 + 1, n5, n3 - n5, n2);
            bigDecimal = bigDecimal.add(bigDecimal2);
        } else {
            bigDecimal = this.toBigDecimalRec(n6, n4 - n6, n3, n2);
        }
        if (n9 != 0) {
            bigDecimal = bigDecimal.setScale(n9);
        }
        if (bl2) {
            bigDecimal = bigDecimal.negate();
        }
        return bigDecimal;
    }

    private int adjustScale(int n2, long l2) {
        long l3 = (long)n2 - l2;
        if (l3 > Integer.MAX_VALUE || l3 < Integer.MIN_VALUE) {
            throw new NumberFormatException("Scale out of range: " + l3 + " while adjusting scale " + n2 + " to exponent " + l2);
        }
        return (int)l3;
    }

    private BigDecimal toBigDecimalRec(int n2, int n3, int n4, int n5) {
        if (n3 > n5) {
            int n6 = n3 / 2;
            BigDecimal bigDecimal = this.toBigDecimalRec(n2, n6, n4 + n3 - n6, n5);
            BigDecimal bigDecimal2 = this.toBigDecimalRec(n2 + n6, n3 - n6, n4, n5);
            return bigDecimal.add(bigDecimal2);
        }
        if (n3 == 0) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(this.chars, n2, n3).movePointRight(n4);
    }
}

