/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.io.ContentReference;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.TextBuffer;

public class IOContext {
    protected final ContentReference _contentReference;
    @Deprecated
    protected final Object _sourceRef;
    protected JsonEncoding _encoding;
    protected final boolean _managedResource;
    protected final BufferRecycler _bufferRecycler;
    protected byte[] _readIOBuffer;
    protected byte[] _writeEncodingBuffer;
    protected byte[] _base64Buffer;
    protected char[] _tokenCBuffer;
    protected char[] _concatCBuffer;
    protected char[] _nameCopyBuffer;

    public IOContext(BufferRecycler bufferRecycler, ContentReference contentReference, boolean bl) {
        this._bufferRecycler = bufferRecycler;
        this._contentReference = contentReference;
        this._sourceRef = contentReference.getRawContent();
        this._managedResource = bl;
    }

    @Deprecated
    public IOContext(BufferRecycler bufferRecycler, Object object, boolean bl) {
        this(bufferRecycler, ContentReference.rawReference(object), bl);
    }

    public void setEncoding(JsonEncoding jsonEncoding) {
        this._encoding = jsonEncoding;
    }

    public IOContext withEncoding(JsonEncoding jsonEncoding) {
        this._encoding = jsonEncoding;
        return this;
    }

    public JsonEncoding getEncoding() {
        return this._encoding;
    }

    public boolean isResourceManaged() {
        return this._managedResource;
    }

    public ContentReference contentReference() {
        return this._contentReference;
    }

    @Deprecated
    public Object getSourceReference() {
        return this._sourceRef;
    }

    public TextBuffer constructTextBuffer() {
        return new TextBuffer(this._bufferRecycler);
    }

    public byte[] allocReadIOBuffer() {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._readIOBuffer);
        this._readIOBuffer = this._bufferRecycler.allocByteBuffer(0);
        return this._readIOBuffer;
    }

    public byte[] allocReadIOBuffer(int n2) {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._readIOBuffer);
        this._readIOBuffer = this._bufferRecycler.allocByteBuffer(0, n2);
        return this._readIOBuffer;
    }

    public byte[] allocWriteEncodingBuffer() {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._writeEncodingBuffer);
        this._writeEncodingBuffer = this._bufferRecycler.allocByteBuffer(1);
        return this._writeEncodingBuffer;
    }

    public byte[] allocWriteEncodingBuffer(int n2) {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._writeEncodingBuffer);
        this._writeEncodingBuffer = this._bufferRecycler.allocByteBuffer(1, n2);
        return this._writeEncodingBuffer;
    }

    public byte[] allocBase64Buffer() {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._base64Buffer);
        this._base64Buffer = this._bufferRecycler.allocByteBuffer(3);
        return this._base64Buffer;
    }

    public byte[] allocBase64Buffer(int n2) {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._base64Buffer);
        this._base64Buffer = this._bufferRecycler.allocByteBuffer(3, n2);
        return this._base64Buffer;
    }

    public char[] allocTokenBuffer() {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._tokenCBuffer);
        this._tokenCBuffer = this._bufferRecycler.allocCharBuffer(0);
        return this._tokenCBuffer;
    }

    public char[] allocTokenBuffer(int n2) {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._tokenCBuffer);
        this._tokenCBuffer = this._bufferRecycler.allocCharBuffer(0, n2);
        return this._tokenCBuffer;
    }

    public char[] allocConcatBuffer() {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._concatCBuffer);
        this._concatCBuffer = this._bufferRecycler.allocCharBuffer(1);
        return this._concatCBuffer;
    }

    public char[] allocNameCopyBuffer(int n2) {
        IOContext iOContext = this;
        iOContext._verifyAlloc(iOContext._nameCopyBuffer);
        this._nameCopyBuffer = this._bufferRecycler.allocCharBuffer(3, n2);
        return this._nameCopyBuffer;
    }

    public void releaseReadIOBuffer(byte[] byArray) {
        if (byArray != null) {
            this._verifyRelease(byArray, this._readIOBuffer);
            this._readIOBuffer = null;
            this._bufferRecycler.releaseByteBuffer(0, byArray);
        }
    }

    public void releaseWriteEncodingBuffer(byte[] byArray) {
        if (byArray != null) {
            this._verifyRelease(byArray, this._writeEncodingBuffer);
            this._writeEncodingBuffer = null;
            this._bufferRecycler.releaseByteBuffer(1, byArray);
        }
    }

    public void releaseBase64Buffer(byte[] byArray) {
        if (byArray != null) {
            this._verifyRelease(byArray, this._base64Buffer);
            this._base64Buffer = null;
            this._bufferRecycler.releaseByteBuffer(3, byArray);
        }
    }

    public void releaseTokenBuffer(char[] cArray) {
        if (cArray != null) {
            this._verifyRelease(cArray, this._tokenCBuffer);
            this._tokenCBuffer = null;
            this._bufferRecycler.releaseCharBuffer(0, cArray);
        }
    }

    public void releaseConcatBuffer(char[] cArray) {
        if (cArray != null) {
            this._verifyRelease(cArray, this._concatCBuffer);
            this._concatCBuffer = null;
            this._bufferRecycler.releaseCharBuffer(1, cArray);
        }
    }

    public void releaseNameCopyBuffer(char[] cArray) {
        if (cArray != null) {
            this._verifyRelease(cArray, this._nameCopyBuffer);
            this._nameCopyBuffer = null;
            this._bufferRecycler.releaseCharBuffer(3, cArray);
        }
    }

    protected final void _verifyAlloc(Object object) {
        if (object != null) {
            throw new IllegalStateException("Trying to call same allocXxx() method second time");
        }
    }

    protected final void _verifyRelease(byte[] byArray, byte[] byArray2) {
        if (byArray != byArray2 && byArray.length < byArray2.length) {
            throw this.wrongBuf();
        }
    }

    protected final void _verifyRelease(char[] cArray, char[] cArray2) {
        if (cArray != cArray2 && cArray.length < cArray2.length) {
            throw this.wrongBuf();
        }
    }

    private IllegalArgumentException wrongBuf() {
        return new IllegalArgumentException("Trying to release buffer smaller than original");
    }
}

