/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.json.DupDetector;

public class JsonWriteContext
extends JsonStreamContext {
    public static final int STATUS_OK_AS_IS = 0;
    public static final int STATUS_OK_AFTER_COMMA = 1;
    public static final int STATUS_OK_AFTER_COLON = 2;
    public static final int STATUS_OK_AFTER_SPACE = 3;
    public static final int STATUS_EXPECT_VALUE = 4;
    public static final int STATUS_EXPECT_NAME = 5;
    protected final JsonWriteContext _parent;
    protected DupDetector _dups;
    protected JsonWriteContext _child;
    protected String _currentName;
    protected Object _currentValue;
    protected boolean _gotName;

    protected JsonWriteContext(int n2, JsonWriteContext jsonWriteContext, DupDetector dupDetector) {
        this._type = n2;
        this._parent = jsonWriteContext;
        this._dups = dupDetector;
        this._index = -1;
    }

    protected JsonWriteContext(int n2, JsonWriteContext jsonWriteContext, DupDetector dupDetector, Object object) {
        this._type = n2;
        this._parent = jsonWriteContext;
        this._dups = dupDetector;
        this._index = -1;
        this._currentValue = object;
    }

    public JsonWriteContext reset(int n2) {
        this._type = n2;
        this._index = -1;
        this._currentName = null;
        this._gotName = false;
        this._currentValue = null;
        if (this._dups != null) {
            this._dups.reset();
        }
        return this;
    }

    public JsonWriteContext reset(int n2, Object object) {
        this._type = n2;
        this._index = -1;
        this._currentName = null;
        this._gotName = false;
        this._currentValue = object;
        if (this._dups != null) {
            this._dups.reset();
        }
        return this;
    }

    public JsonWriteContext withDupDetector(DupDetector dupDetector) {
        this._dups = dupDetector;
        return this;
    }

    @Override
    public Object getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public void setCurrentValue(Object object) {
        this._currentValue = object;
    }

    @Deprecated
    public static JsonWriteContext createRootContext() {
        return JsonWriteContext.createRootContext(null);
    }

    public static JsonWriteContext createRootContext(DupDetector dupDetector) {
        return new JsonWriteContext(0, null, dupDetector);
    }

    public JsonWriteContext createChildArrayContext() {
        JsonWriteContext jsonWriteContext = this._child;
        if (jsonWriteContext == null) {
            JsonWriteContext jsonWriteContext2 = this;
            this._child = jsonWriteContext = new JsonWriteContext(1, jsonWriteContext2, jsonWriteContext2._dups == null ? null : this._dups.child());
            return jsonWriteContext;
        }
        return jsonWriteContext.reset(1);
    }

    public JsonWriteContext createChildArrayContext(Object object) {
        JsonWriteContext jsonWriteContext = this._child;
        if (jsonWriteContext == null) {
            JsonWriteContext jsonWriteContext2 = this;
            this._child = jsonWriteContext = new JsonWriteContext(1, jsonWriteContext2, jsonWriteContext2._dups == null ? null : this._dups.child(), object);
            return jsonWriteContext;
        }
        return jsonWriteContext.reset(1, object);
    }

    public JsonWriteContext createChildObjectContext() {
        JsonWriteContext jsonWriteContext = this._child;
        if (jsonWriteContext == null) {
            JsonWriteContext jsonWriteContext2 = this;
            this._child = jsonWriteContext = new JsonWriteContext(2, jsonWriteContext2, jsonWriteContext2._dups == null ? null : this._dups.child());
            return jsonWriteContext;
        }
        return jsonWriteContext.reset(2);
    }

    public JsonWriteContext createChildObjectContext(Object object) {
        JsonWriteContext jsonWriteContext = this._child;
        if (jsonWriteContext == null) {
            JsonWriteContext jsonWriteContext2 = this;
            this._child = jsonWriteContext = new JsonWriteContext(2, jsonWriteContext2, jsonWriteContext2._dups == null ? null : this._dups.child(), object);
            return jsonWriteContext;
        }
        return jsonWriteContext.reset(2, object);
    }

    @Override
    public final JsonWriteContext getParent() {
        return this._parent;
    }

    @Override
    public final String getCurrentName() {
        return this._currentName;
    }

    @Override
    public boolean hasCurrentName() {
        return this._currentName != null;
    }

    public JsonWriteContext clearAndGetParent() {
        this._currentValue = null;
        return this._parent;
    }

    public DupDetector getDupDetector() {
        return this._dups;
    }

    public int writeFieldName(String string) {
        if (this._type != 2 || this._gotName) {
            return 4;
        }
        this._gotName = true;
        this._currentName = string;
        if (this._dups != null) {
            JsonWriteContext jsonWriteContext = this;
            jsonWriteContext._checkDup(jsonWriteContext._dups, string);
        }
        if (this._index < 0) {
            return 0;
        }
        return 1;
    }

    private final void _checkDup(DupDetector object, String string) {
        if (((DupDetector)object).isDup(string)) {
            object = ((DupDetector)object).getSource();
            throw new JsonGenerationException("Duplicate field '" + string + "'", object instanceof JsonGenerator ? (JsonGenerator)object : null);
        }
    }

    public int writeValue() {
        if (this._type == 2) {
            if (!this._gotName) {
                return 5;
            }
            this._gotName = false;
            ++this._index;
            return 2;
        }
        if (this._type == 1) {
            int n2;
            if ((n2 = this._index++) < 0) {
                return 0;
            }
            return 1;
        }
        ++this._index;
        if (this._index == 0) {
            return 0;
        }
        return 3;
    }
}

