/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.ThreadLocalBufferManager;
import java.lang.ref.SoftReference;

public class BufferRecyclers {
    public static final String SYSTEM_PROPERTY_TRACK_REUSABLE_BUFFERS = "com.fasterxml.jackson.core.util.BufferRecyclers.trackReusableBuffers";
    private static final ThreadLocalBufferManager _bufferRecyclerTracker;
    protected static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef;

    public static BufferRecycler getBufferRecycler() {
        SoftReference<BufferRecycler> softReference = _recyclerRef.get();
        BufferRecycler bufferRecycler = softReference == null ? null : softReference.get();
        if (bufferRecycler == null) {
            bufferRecycler = new BufferRecycler();
            softReference = _bufferRecyclerTracker != null ? _bufferRecyclerTracker.wrapAndTrack(bufferRecycler) : new SoftReference<BufferRecycler>(bufferRecycler);
            _recyclerRef.set(softReference);
        }
        return bufferRecycler;
    }

    public static int releaseBuffers() {
        if (_bufferRecyclerTracker != null) {
            return _bufferRecyclerTracker.releaseBuffers();
        }
        return -1;
    }

    @Deprecated
    public static JsonStringEncoder getJsonStringEncoder() {
        return JsonStringEncoder.getInstance();
    }

    @Deprecated
    public static byte[] encodeAsUTF8(String string) {
        return JsonStringEncoder.getInstance().encodeAsUTF8(string);
    }

    @Deprecated
    public static char[] quoteAsJsonText(String string) {
        return JsonStringEncoder.getInstance().quoteAsString(string);
    }

    @Deprecated
    public static void quoteAsJsonText(CharSequence charSequence, StringBuilder stringBuilder) {
        JsonStringEncoder.getInstance().quoteAsString(charSequence, stringBuilder);
    }

    @Deprecated
    public static byte[] quoteAsJsonUTF8(String string) {
        return JsonStringEncoder.getInstance().quoteAsUTF8(string);
    }

    static {
        boolean bl = false;
        try {
            bl = "true".equals(System.getProperty(SYSTEM_PROPERTY_TRACK_REUSABLE_BUFFERS));
        }
        catch (SecurityException securityException) {}
        _bufferRecyclerTracker = bl ? ThreadLocalBufferManager.instance() : null;
        _recyclerRef = new ThreadLocal();
    }
}

