/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonParserDelegate;
import java.util.ArrayList;
import java.util.List;

public class JsonParserSequence
extends JsonParserDelegate {
    protected final JsonParser[] _parsers;
    protected final boolean _checkForExistingToken;
    protected int _nextParserIndex;
    protected boolean _hasToken;

    @Deprecated
    protected JsonParserSequence(JsonParser[] jsonParserArray) {
        this(false, jsonParserArray);
    }

    protected JsonParserSequence(boolean bl, JsonParser[] jsonParserArray) {
        super(jsonParserArray[0]);
        this._checkForExistingToken = bl;
        this._hasToken = bl && this.delegate.hasCurrentToken();
        this._parsers = jsonParserArray;
        this._nextParserIndex = 1;
    }

    public static JsonParserSequence createFlattened(boolean bl, JsonParser jsonParser, JsonParser jsonParser2) {
        if (!(jsonParser instanceof JsonParserSequence) && !(jsonParser2 instanceof JsonParserSequence)) {
            return new JsonParserSequence(bl, new JsonParser[]{jsonParser, jsonParser2});
        }
        ArrayList<JsonParser> arrayList = new ArrayList<JsonParser>();
        if (jsonParser instanceof JsonParserSequence) {
            ((JsonParserSequence)jsonParser).addFlattenedActiveParsers(arrayList);
        } else {
            arrayList.add(jsonParser);
        }
        if (jsonParser2 instanceof JsonParserSequence) {
            ((JsonParserSequence)jsonParser2).addFlattenedActiveParsers(arrayList);
        } else {
            arrayList.add(jsonParser2);
        }
        ArrayList<JsonParser> arrayList2 = arrayList;
        return new JsonParserSequence(bl, arrayList2.toArray(new JsonParser[arrayList2.size()]));
    }

    @Deprecated
    public static JsonParserSequence createFlattened(JsonParser jsonParser, JsonParser jsonParser2) {
        return JsonParserSequence.createFlattened(false, jsonParser, jsonParser2);
    }

    protected void addFlattenedActiveParsers(List<JsonParser> list) {
        int n2 = this._parsers.length;
        for (int i2 = this._nextParserIndex - 1; i2 < n2; ++i2) {
            JsonParser jsonParser = this._parsers[i2];
            if (jsonParser instanceof JsonParserSequence) {
                ((JsonParserSequence)jsonParser).addFlattenedActiveParsers(list);
                continue;
            }
            list.add(jsonParser);
        }
    }

    @Override
    public void close() {
        do {
            this.delegate.close();
        } while (this.switchToNext());
    }

    @Override
    public JsonToken nextToken() {
        if (this.delegate == null) {
            return null;
        }
        if (this._hasToken) {
            this._hasToken = false;
            return this.delegate.currentToken();
        }
        JsonToken jsonToken = this.delegate.nextToken();
        if (jsonToken == null) {
            return this.switchAndReturnNext();
        }
        return jsonToken;
    }

    @Override
    public JsonParser skipChildren() {
        if (this.delegate.currentToken() != JsonToken.START_OBJECT && this.delegate.currentToken() != JsonToken.START_ARRAY) {
            return this;
        }
        int n2 = 1;
        while (true) {
            JsonToken jsonToken;
            if ((jsonToken = ((JsonParser)this).nextToken()) == null) {
                return this;
            }
            if (jsonToken.isStructStart()) {
                ++n2;
                continue;
            }
            if (jsonToken.isStructEnd() && --n2 == 0) break;
        }
        return this;
    }

    public int containedParsersCount() {
        return this._parsers.length;
    }

    protected boolean switchToNext() {
        if (this._nextParserIndex < this._parsers.length) {
            this.delegate = this._parsers[this._nextParserIndex++];
            return true;
        }
        return false;
    }

    protected JsonToken switchAndReturnNext() {
        while (this._nextParserIndex < this._parsers.length) {
            this.delegate = this._parsers[this._nextParserIndex++];
            if (this._checkForExistingToken && this.delegate.hasCurrentToken()) {
                return this.delegate.getCurrentToken();
            }
            JsonToken jsonToken = this.delegate.nextToken();
            if (jsonToken == null) continue;
            return jsonToken;
        }
        return null;
    }
}

