/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Pattern;

public class VersionUtil {
    private static final Pattern V_SEP = Pattern.compile("[-_./;:]");

    protected VersionUtil() {
    }

    @Deprecated
    public Version version() {
        return Version.unknownVersion();
    }

    public static Version versionFor(Class<?> clazz) {
        Version version = null;
        try {
            String string = clazz.getPackage().getName() + ".PackageVersion";
            clazz = Class.forName(string, true, clazz.getClassLoader());
            try {
                version = ((Versioned)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).version();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to get Versioned out of " + clazz);
            }
        }
        catch (Exception exception) {}
        if (version == null) {
            return Version.unknownVersion();
        }
        return version;
    }

    @Deprecated
    public static Version packageVersionFor(Class<?> clazz) {
        return VersionUtil.versionFor(clazz);
    }

    @Deprecated
    public static Version mavenVersionFor(ClassLoader object, String object2, String string) {
        if ((object = ((ClassLoader)object).getResourceAsStream("META-INF/maven/" + ((String)object2).replaceAll("\\.", "/") + "/" + string + "/pom.properties")) != null) {
            try {
                object2 = new Properties();
                ((Properties)object2).load((InputStream)object);
                string = ((Properties)object2).getProperty("version");
                String string2 = ((Properties)object2).getProperty("artifactId");
                object2 = ((Properties)object2).getProperty("groupId");
                object2 = VersionUtil.parseVersion(string, (String)object2, string2);
                return object2;
            }
            catch (IOException iOException) {
            }
            finally {
                VersionUtil._close((Closeable)object);
            }
        }
        return Version.unknownVersion();
    }

    public static Version parseVersion(String stringArray, String string, String string2) {
        if (stringArray != null && (stringArray = stringArray.trim()).length() > 0) {
            stringArray = V_SEP.split((CharSequence)stringArray);
            return new Version(VersionUtil.parseVersionPart(stringArray[0]), stringArray.length > 1 ? VersionUtil.parseVersionPart(stringArray[1]) : 0, stringArray.length > 2 ? VersionUtil.parseVersionPart(stringArray[2]) : 0, stringArray.length > 3 ? stringArray[3] : null, string, string2);
        }
        return Version.unknownVersion();
    }

    protected static int parseVersionPart(String string) {
        char c2;
        int n2 = 0;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3 && (c2 = string.charAt(i2)) <= '9' && c2 >= '0'; ++i2) {
            n2 = n2 * 10 + (c2 - 48);
        }
        return n2;
    }

    private static final void _close(Closeable closeable) {
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static final void throwInternal() {
        throw new RuntimeException("Internal error: this code path should never get executed");
    }
}

