/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException$Reference;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class JsonMappingException
extends DatabindException {
    private static final long serialVersionUID = 3L;
    static final int MAX_REFS_TO_LIST = 1000;
    protected LinkedList<JsonMappingException$Reference> _path;
    protected transient Closeable _processor;

    @Deprecated
    public JsonMappingException(String string) {
        super(string);
    }

    @Deprecated
    public JsonMappingException(String string, Throwable throwable) {
        super(string, throwable);
    }

    @Deprecated
    public JsonMappingException(String string, JsonLocation jsonLocation) {
        super(string, jsonLocation);
    }

    @Deprecated
    public JsonMappingException(String string, JsonLocation jsonLocation, Throwable throwable) {
        super(string, jsonLocation, throwable);
    }

    public JsonMappingException(Closeable closeable, String string) {
        super(string);
        this._processor = closeable;
        if (closeable instanceof JsonParser) {
            this._location = ((JsonParser)closeable).getTokenLocation();
        }
    }

    public JsonMappingException(Closeable closeable, String string, Throwable throwable) {
        super(string, throwable);
        this._processor = closeable;
        if (throwable instanceof JacksonException) {
            this._location = ((JacksonException)throwable).getLocation();
            return;
        }
        if (closeable instanceof JsonParser) {
            this._location = ((JsonParser)closeable).getTokenLocation();
        }
    }

    public JsonMappingException(Closeable closeable, String string, JsonLocation jsonLocation) {
        super(string, jsonLocation);
        this._processor = closeable;
    }

    public static JsonMappingException from(JsonParser jsonParser, String string) {
        return new JsonMappingException(jsonParser, string);
    }

    public static JsonMappingException from(JsonParser jsonParser, String string, Throwable throwable) {
        return new JsonMappingException((Closeable)jsonParser, string, throwable);
    }

    public static JsonMappingException from(JsonGenerator jsonGenerator, String string) {
        return new JsonMappingException((Closeable)jsonGenerator, string, null);
    }

    public static JsonMappingException from(JsonGenerator jsonGenerator, String string, Throwable throwable) {
        return new JsonMappingException((Closeable)jsonGenerator, string, throwable);
    }

    public static JsonMappingException from(DeserializationContext deserializationContext, String string) {
        return new JsonMappingException(deserializationContext.getParser(), string);
    }

    public static JsonMappingException from(DeserializationContext deserializationContext, String string, Throwable throwable) {
        return new JsonMappingException((Closeable)deserializationContext.getParser(), string, throwable);
    }

    public static JsonMappingException from(SerializerProvider serializerProvider, String string) {
        return new JsonMappingException(serializerProvider.getGenerator(), string);
    }

    public static JsonMappingException from(SerializerProvider serializerProvider, String string, Throwable throwable) {
        return new JsonMappingException((Closeable)serializerProvider.getGenerator(), string, throwable);
    }

    public static JsonMappingException fromUnexpectedIOE(IOException iOException) {
        return new JsonMappingException(null, String.format("Unexpected IOException (of type %s): %s", iOException.getClass().getName(), ClassUtil.exceptionMessage(iOException)));
    }

    public static JsonMappingException wrapWithPath(Throwable throwable, Object object, String string) {
        return JsonMappingException.wrapWithPath(throwable, new JsonMappingException$Reference(object, string));
    }

    public static JsonMappingException wrapWithPath(Throwable throwable, Object object, int n2) {
        return JsonMappingException.wrapWithPath(throwable, new JsonMappingException$Reference(object, n2));
    }

    public static JsonMappingException wrapWithPath(Throwable throwable, JsonMappingException$Reference jsonMappingException$Reference) {
        if (throwable instanceof JsonMappingException) {
            throwable = (JsonMappingException)throwable;
        } else {
            Object object;
            String string = ClassUtil.exceptionMessage(throwable);
            if (string == null || string.isEmpty()) {
                string = "(was " + throwable.getClass().getName() + ")";
            }
            Closeable closeable = null;
            if (throwable instanceof JacksonException && (object = ((JacksonException)throwable).getProcessor()) instanceof Closeable) {
                closeable = (Closeable)object;
            }
            throwable = new JsonMappingException(closeable, string, throwable);
        }
        ((JsonMappingException)throwable).prependPath(jsonMappingException$Reference);
        return throwable;
    }

    public JsonMappingException withCause(Throwable throwable) {
        this.initCause(throwable);
        return this;
    }

    public List<JsonMappingException$Reference> getPath() {
        if (this._path == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._path);
    }

    public String getPathReference() {
        return this.getPathReference(new StringBuilder()).toString();
    }

    public StringBuilder getPathReference(StringBuilder stringBuilder) {
        this._appendPathDesc(stringBuilder);
        return stringBuilder;
    }

    @Override
    public void prependPath(Object object, String string) {
        this.prependPath(new JsonMappingException$Reference(object, string));
    }

    @Override
    public void prependPath(Object object, int n2) {
        this.prependPath(new JsonMappingException$Reference(object, n2));
    }

    public void prependPath(JsonMappingException$Reference jsonMappingException$Reference) {
        if (this._path == null) {
            this._path = new LinkedList();
        }
        if (this._path.size() < 1000) {
            this._path.addFirst(jsonMappingException$Reference);
        }
    }

    @Override
    @JsonIgnore
    public Object getProcessor() {
        return this._processor;
    }

    @Override
    public String getLocalizedMessage() {
        return this._buildMessage();
    }

    @Override
    public String getMessage() {
        return this._buildMessage();
    }

    protected String _buildMessage() {
        CharSequence charSequence = super.getMessage();
        if (this._path == null) {
            return charSequence;
        }
        charSequence = charSequence == null ? new StringBuilder() : new StringBuilder((String)charSequence);
        ((StringBuilder)charSequence).append(" (through reference chain: ");
        charSequence = this.getPathReference((StringBuilder)charSequence);
        ((StringBuilder)charSequence).append(')');
        return ((StringBuilder)charSequence).toString();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + ((JsonProcessingException)this).getMessage();
    }

    protected void _appendPathDesc(StringBuilder stringBuilder) {
        if (this._path == null) {
            return;
        }
        Iterator iterator = this._path.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(((JsonMappingException$Reference)iterator.next()).toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("->");
        }
    }
}

