/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class MappingIterator<T>
implements Closeable,
Iterator<T> {
    protected static final MappingIterator<?> EMPTY_ITERATOR = new MappingIterator(null, null, null, null, false, null);
    protected static final int STATE_CLOSED = 0;
    protected static final int STATE_NEED_RESYNC = 1;
    protected static final int STATE_MAY_HAVE_VALUE = 2;
    protected static final int STATE_HAS_VALUE = 3;
    protected final JavaType _type;
    protected final DeserializationContext _context;
    protected final JsonDeserializer<T> _deserializer;
    protected final JsonParser _parser;
    protected final JsonStreamContext _seqContext;
    protected final T _updatedValue;
    protected final boolean _closeParser;
    protected int _state;

    protected MappingIterator(JavaType object, JsonParser object2, DeserializationContext deserializationContext, JsonDeserializer<?> jsonDeserializer, boolean bl, Object object3) {
        this._type = object;
        this._parser = object2;
        this._context = deserializationContext;
        this._deserializer = jsonDeserializer;
        this._closeParser = bl;
        this._updatedValue = object3 == null ? null : object3;
        if (object2 == null) {
            this._seqContext = null;
            this._state = 0;
            return;
        }
        object = object2.getParsingContext();
        if (bl && object2.isExpectedStartArrayToken()) {
            object2.clearCurrentToken();
        } else if ((object2 = object2.currentToken()) == JsonToken.START_OBJECT || object2 == JsonToken.START_ARRAY) {
            object = ((JsonStreamContext)object).getParent();
        }
        this._seqContext = object;
        this._state = 2;
    }

    public static <T> MappingIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.hasNextValue();
        }
        catch (JsonMappingException jsonMappingException) {
            return (Boolean)this._handleMappingException(jsonMappingException);
        }
        catch (IOException iOException) {
            return (Boolean)this._handleIOException(iOException);
        }
    }

    @Override
    public T next() {
        try {
            return this.nextValue();
        }
        catch (JsonMappingException jsonMappingException) {
            return (T)this._handleMappingException(jsonMappingException);
        }
        catch (IOException iOException) {
            return (T)this._handleIOException(iOException);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this._state != 0) {
            this._state = 0;
            if (this._parser != null) {
                this._parser.close();
            }
        }
    }

    public boolean hasNextValue() {
        switch (this._state) {
            case 0: {
                return false;
            }
            case 1: {
                this._resync();
            }
            case 2: {
                if (this._parser == null) {
                    return false;
                }
                JsonToken jsonToken = this._parser.currentToken();
                if (jsonToken == null && ((jsonToken = this._parser.nextToken()) == null || jsonToken == JsonToken.END_ARRAY)) {
                    this._state = 0;
                    if (this._closeParser) {
                        this._parser.close();
                    }
                    return false;
                }
                this._state = 3;
                return true;
            }
        }
        return true;
    }

    public T nextValue() {
        T t2;
        switch (this._state) {
            case 0: {
                return (T)this._throwNoSuchElement();
            }
            case 1: 
            case 2: {
                if (this.hasNextValue()) break;
                return (T)this._throwNoSuchElement();
            }
        }
        int n2 = 1;
        try {
            if (this._updatedValue == null) {
                t2 = this._deserializer.deserialize(this._parser, this._context);
            } else {
                this._deserializer.deserialize(this._parser, this._context, this._updatedValue);
                t2 = this._updatedValue;
            }
            n2 = 2;
            this._state = 2;
            this._parser.clearCurrentToken();
        }
        catch (Throwable throwable) {
            this._state = n2;
            this._parser.clearCurrentToken();
            throw throwable;
        }
        return t2;
    }

    public List<T> readAll() {
        return this.readAll((Collection)new ArrayList());
    }

    public <L extends List<? super T>> L readAll(L l2) {
        while (this.hasNextValue()) {
            l2.add(this.nextValue());
        }
        return l2;
    }

    public <C extends Collection<? super T>> C readAll(C c2) {
        while (this.hasNextValue()) {
            c2.add(this.nextValue());
        }
        return c2;
    }

    public JsonParser getParser() {
        return this._parser;
    }

    public FormatSchema getParserSchema() {
        return this._parser.getSchema();
    }

    public JsonLocation getCurrentLocation() {
        return this._parser.getCurrentLocation();
    }

    protected void _resync() {
        JsonParser jsonParser = this._parser;
        if (jsonParser.getParsingContext() == this._seqContext) {
            return;
        }
        while (true) {
            JsonToken jsonToken;
            if ((jsonToken = jsonParser.nextToken()) == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
                if (jsonParser.getParsingContext() != this._seqContext) continue;
                jsonParser.clearCurrentToken();
                return;
            }
            if (jsonToken == JsonToken.START_ARRAY || jsonToken == JsonToken.START_OBJECT) {
                jsonParser.skipChildren();
                continue;
            }
            if (jsonToken == null) break;
        }
    }

    protected <R> R _throwNoSuchElement() {
        throw new NoSuchElementException();
    }

    protected <R> R _handleMappingException(JsonMappingException jsonMappingException) {
        throw new RuntimeJsonMappingException(((JsonProcessingException)jsonMappingException).getMessage(), jsonMappingException);
    }

    protected <R> R _handleIOException(IOException iOException) {
        throw new RuntimeException(iOException.getMessage(), iOException);
    }
}

