/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import java.io.Serializable;

public final class ObjectWriter$Prefetch
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ObjectWriter$Prefetch empty = new ObjectWriter$Prefetch(null, null, null);
    private final JavaType rootType;
    private final JsonSerializer<Object> valueSerializer;
    private final TypeSerializer typeSerializer;

    private ObjectWriter$Prefetch(JavaType javaType, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer) {
        this.rootType = javaType;
        this.valueSerializer = jsonSerializer;
        this.typeSerializer = typeSerializer;
    }

    public final ObjectWriter$Prefetch forRootType(ObjectWriter jsonSerializer, JavaType javaType) {
        if (javaType == null) {
            if (this.rootType == null || this.valueSerializer == null) {
                return this;
            }
            return new ObjectWriter$Prefetch(null, null, null);
        }
        if (javaType.equals(this.rootType)) {
            return this;
        }
        if (javaType.isJavaLangObject()) {
            jsonSerializer = ((ObjectWriter)((Object)jsonSerializer))._serializerProvider();
            try {
                jsonSerializer = ((SerializerProvider)((Object)jsonSerializer)).findTypeSerializer(javaType);
            }
            catch (JsonMappingException jsonMappingException) {
                throw new RuntimeJsonMappingException(jsonMappingException);
            }
            return new ObjectWriter$Prefetch(null, null, (TypeSerializer)((Object)jsonSerializer));
        }
        if (((ObjectWriter)((Object)jsonSerializer)).isEnabled(SerializationFeature.EAGER_SERIALIZER_FETCH)) {
            jsonSerializer = ((ObjectWriter)((Object)jsonSerializer))._serializerProvider();
            try {
                jsonSerializer = ((SerializerProvider)((Object)jsonSerializer)).findTypedValueSerializer(javaType, true, null);
                if (jsonSerializer instanceof TypeWrappedSerializer) {
                    return new ObjectWriter$Prefetch(javaType, null, ((TypeWrappedSerializer)jsonSerializer).typeSerializer());
                }
                return new ObjectWriter$Prefetch(javaType, jsonSerializer, null);
            }
            catch (DatabindException databindException) {}
        }
        return new ObjectWriter$Prefetch(javaType, null, this.typeSerializer);
    }

    public final JsonSerializer<Object> getValueSerializer() {
        return this.valueSerializer;
    }

    public final TypeSerializer getTypeSerializer() {
        return this.typeSerializer;
    }

    public final boolean hasSerializer() {
        return this.valueSerializer != null || this.typeSerializer != null;
    }

    public final void serialize(JsonGenerator jsonGenerator, Object object, DefaultSerializerProvider defaultSerializerProvider) {
        if (this.typeSerializer != null) {
            defaultSerializerProvider.serializePolymorphic(jsonGenerator, object, this.rootType, this.valueSerializer, this.typeSerializer);
            return;
        }
        if (this.valueSerializer != null) {
            defaultSerializerProvider.serializeValue(jsonGenerator, object, this.rootType, this.valueSerializer);
            return;
        }
        if (this.rootType != null) {
            defaultSerializerProvider.serializeValue(jsonGenerator, object, this.rootType);
            return;
        }
        defaultSerializerProvider.serializeValue(jsonGenerator, object);
    }
}

