/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter$GeneratorSettings;
import com.fasterxml.jackson.databind.ObjectWriter$Prefetch;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

public class ObjectWriter
implements Versioned,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final PrettyPrinter NULL_PRETTY_PRINTER = new MinimalPrettyPrinter();
    protected final SerializationConfig _config;
    protected final DefaultSerializerProvider _serializerProvider;
    protected final SerializerFactory _serializerFactory;
    protected final JsonFactory _generatorFactory;
    protected final ObjectWriter$GeneratorSettings _generatorSettings;
    protected final ObjectWriter$Prefetch _prefetch;

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig, JavaType javaType, PrettyPrinter prettyPrinter) {
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._generatorFactory = objectMapper._jsonFactory;
        ObjectWriter$GeneratorSettings objectWriter$GeneratorSettings = this._generatorSettings = prettyPrinter == null ? ObjectWriter$GeneratorSettings.empty : new ObjectWriter$GeneratorSettings(prettyPrinter, null, null, null);
        if (javaType == null) {
            this._prefetch = ObjectWriter$Prefetch.empty;
            return;
        }
        if (((ResolvedType)javaType).hasRawClass(Object.class)) {
            this._prefetch = ObjectWriter$Prefetch.empty.forRootType(this, javaType);
            return;
        }
        this._prefetch = ObjectWriter$Prefetch.empty.forRootType(this, javaType.withStaticTyping());
    }

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig) {
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._generatorFactory = objectMapper._jsonFactory;
        this._generatorSettings = ObjectWriter$GeneratorSettings.empty;
        this._prefetch = ObjectWriter$Prefetch.empty;
    }

    protected ObjectWriter(ObjectMapper objectMapper, SerializationConfig serializationConfig, FormatSchema formatSchema) {
        this._config = serializationConfig;
        this._serializerProvider = objectMapper._serializerProvider;
        this._serializerFactory = objectMapper._serializerFactory;
        this._generatorFactory = objectMapper._jsonFactory;
        this._generatorSettings = formatSchema == null ? ObjectWriter$GeneratorSettings.empty : new ObjectWriter$GeneratorSettings(null, formatSchema, null, null);
        this._prefetch = ObjectWriter$Prefetch.empty;
    }

    protected ObjectWriter(ObjectWriter objectWriter, SerializationConfig serializationConfig, ObjectWriter$GeneratorSettings objectWriter$GeneratorSettings, ObjectWriter$Prefetch objectWriter$Prefetch) {
        this._config = serializationConfig;
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._generatorFactory = objectWriter._generatorFactory;
        this._generatorSettings = objectWriter$GeneratorSettings;
        this._prefetch = objectWriter$Prefetch;
    }

    protected ObjectWriter(ObjectWriter objectWriter, SerializationConfig serializationConfig) {
        this._config = serializationConfig;
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._generatorFactory = objectWriter._generatorFactory;
        this._generatorSettings = objectWriter._generatorSettings;
        this._prefetch = objectWriter._prefetch;
    }

    protected ObjectWriter(ObjectWriter objectWriter, JsonFactory jsonFactory) {
        this._config = (SerializationConfig)objectWriter._config.with(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, ((TokenStreamFactory)jsonFactory).requiresPropertyOrdering());
        this._serializerProvider = objectWriter._serializerProvider;
        this._serializerFactory = objectWriter._serializerFactory;
        this._generatorFactory = jsonFactory;
        this._generatorSettings = objectWriter._generatorSettings;
        this._prefetch = objectWriter._prefetch;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    protected ObjectWriter _new(ObjectWriter objectWriter, JsonFactory jsonFactory) {
        return new ObjectWriter(objectWriter, jsonFactory);
    }

    protected ObjectWriter _new(ObjectWriter objectWriter, SerializationConfig serializationConfig) {
        if (serializationConfig == this._config) {
            return this;
        }
        return new ObjectWriter(objectWriter, serializationConfig);
    }

    protected ObjectWriter _new(ObjectWriter$GeneratorSettings objectWriter$GeneratorSettings, ObjectWriter$Prefetch objectWriter$Prefetch) {
        if (this._generatorSettings == objectWriter$GeneratorSettings && this._prefetch == objectWriter$Prefetch) {
            return this;
        }
        ObjectWriter objectWriter = this;
        return new ObjectWriter(objectWriter, objectWriter._config, objectWriter$GeneratorSettings, objectWriter$Prefetch);
    }

    protected SequenceWriter _newSequenceWriter(boolean bl, JsonGenerator jsonGenerator, boolean bl2) {
        return new SequenceWriter(this._serializerProvider(), this._configureGenerator(jsonGenerator), bl2, this._prefetch).init(bl);
    }

    public ObjectWriter with(SerializationFeature serializationFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.with(serializationFeature));
    }

    public ObjectWriter with(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.with(serializationFeature, serializationFeatureArray));
    }

    public ObjectWriter withFeatures(SerializationFeature ... serializationFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.withFeatures(serializationFeatureArray));
    }

    public ObjectWriter without(SerializationFeature serializationFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.without(serializationFeature));
    }

    public ObjectWriter without(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.without(serializationFeature, serializationFeatureArray));
    }

    public ObjectWriter withoutFeatures(SerializationFeature ... serializationFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.withoutFeatures(serializationFeatureArray));
    }

    public ObjectWriter with(JsonGenerator$Feature jsonGenerator$Feature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.with(jsonGenerator$Feature));
    }

    public ObjectWriter withFeatures(JsonGenerator$Feature ... jsonGenerator$FeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.withFeatures(jsonGenerator$FeatureArray));
    }

    public ObjectWriter without(JsonGenerator$Feature jsonGenerator$Feature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.without(jsonGenerator$Feature));
    }

    public ObjectWriter withoutFeatures(JsonGenerator$Feature ... jsonGenerator$FeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.withoutFeatures(jsonGenerator$FeatureArray));
    }

    public ObjectWriter with(StreamWriteFeature streamWriteFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.with(streamWriteFeature.mappedFeature()));
    }

    public ObjectWriter without(StreamWriteFeature streamWriteFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.without(streamWriteFeature.mappedFeature()));
    }

    public ObjectWriter with(FormatFeature formatFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.with(formatFeature));
    }

    public ObjectWriter withFeatures(FormatFeature ... formatFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.withFeatures(formatFeatureArray));
    }

    public ObjectWriter without(FormatFeature formatFeature) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.without(formatFeature));
    }

    public ObjectWriter withoutFeatures(FormatFeature ... formatFeatureArray) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.withoutFeatures(formatFeatureArray));
    }

    public ObjectWriter forType(JavaType javaType) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter._generatorSettings, this._prefetch.forRootType(this, javaType));
    }

    public ObjectWriter forType(Class<?> clazz) {
        ObjectWriter objectWriter = this;
        return objectWriter.forType(objectWriter._config.constructType(clazz));
    }

    public ObjectWriter forType(TypeReference<?> typeReference) {
        ObjectWriter objectWriter = this;
        return objectWriter.forType(objectWriter._config.getTypeFactory().constructType(typeReference.getType()));
    }

    @Deprecated
    public ObjectWriter withType(JavaType javaType) {
        return this.forType(javaType);
    }

    @Deprecated
    public ObjectWriter withType(Class<?> clazz) {
        return this.forType(clazz);
    }

    @Deprecated
    public ObjectWriter withType(TypeReference<?> typeReference) {
        return this.forType(typeReference);
    }

    public ObjectWriter with(DateFormat dateFormat) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.with(dateFormat));
    }

    public ObjectWriter withDefaultPrettyPrinter() {
        ObjectWriter objectWriter = this;
        return objectWriter.with(objectWriter._config.getDefaultPrettyPrinter());
    }

    public ObjectWriter with(FilterProvider filterProvider) {
        if (filterProvider == this._config.getFilterProvider()) {
            return this;
        }
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.withFilters(filterProvider));
    }

    public ObjectWriter with(PrettyPrinter prettyPrinter) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter._generatorSettings.with(prettyPrinter), this._prefetch);
    }

    public ObjectWriter withRootName(String string) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.withRootName(string));
    }

    public ObjectWriter withRootName(PropertyName propertyName) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.withRootName(propertyName));
    }

    public ObjectWriter withoutRootName() {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.withRootName(PropertyName.NO_NAME));
    }

    public ObjectWriter with(FormatSchema formatSchema) {
        this._verifySchemaType(formatSchema);
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter._generatorSettings.with(formatSchema), this._prefetch);
    }

    @Deprecated
    public ObjectWriter withSchema(FormatSchema formatSchema) {
        return this.with(formatSchema);
    }

    public ObjectWriter withView(Class<?> clazz) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.withView((Class)clazz));
    }

    public ObjectWriter with(Locale locale) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.with(locale));
    }

    public ObjectWriter with(TimeZone timeZone) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.with(timeZone));
    }

    public ObjectWriter with(Base64Variant base64Variant) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.with(base64Variant));
    }

    public ObjectWriter with(CharacterEscapes characterEscapes) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter._generatorSettings.with(characterEscapes), this._prefetch);
    }

    public ObjectWriter with(JsonFactory jsonFactory) {
        if (jsonFactory == this._generatorFactory) {
            return this;
        }
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, jsonFactory);
    }

    public ObjectWriter with(ContextAttributes contextAttributes) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, this._config.with(contextAttributes));
    }

    public ObjectWriter withAttributes(Map<?, ?> map) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.withAttributes(map));
    }

    public ObjectWriter withAttribute(Object object, Object object2) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.withAttribute(object, object2));
    }

    public ObjectWriter withoutAttribute(Object object) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter, (SerializationConfig)this._config.withoutAttribute(object));
    }

    public ObjectWriter withRootValueSeparator(String string) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter._generatorSettings.withRootValueSeparator(string), this._prefetch);
    }

    public ObjectWriter withRootValueSeparator(SerializableString serializableString) {
        ObjectWriter objectWriter = this;
        return objectWriter._new(objectWriter._generatorSettings.withRootValueSeparator(serializableString), this._prefetch);
    }

    public JsonGenerator createGenerator(OutputStream outputStream) {
        this._assertNotNull("out", outputStream);
        ObjectWriter objectWriter = this;
        return objectWriter._configureGenerator(((TokenStreamFactory)objectWriter._generatorFactory).createGenerator(outputStream, JsonEncoding.UTF8));
    }

    public JsonGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) {
        this._assertNotNull("out", outputStream);
        ObjectWriter objectWriter = this;
        return objectWriter._configureGenerator(((TokenStreamFactory)objectWriter._generatorFactory).createGenerator(outputStream, jsonEncoding));
    }

    public JsonGenerator createGenerator(Writer writer) {
        this._assertNotNull("w", writer);
        ObjectWriter objectWriter = this;
        return objectWriter._configureGenerator(((TokenStreamFactory)objectWriter._generatorFactory).createGenerator(writer));
    }

    public JsonGenerator createGenerator(File file, JsonEncoding jsonEncoding) {
        this._assertNotNull("outputFile", file);
        ObjectWriter objectWriter = this;
        return objectWriter._configureGenerator(((TokenStreamFactory)objectWriter._generatorFactory).createGenerator(file, jsonEncoding));
    }

    public JsonGenerator createGenerator(DataOutput dataOutput) {
        this._assertNotNull("out", dataOutput);
        ObjectWriter objectWriter = this;
        return objectWriter._configureGenerator(((TokenStreamFactory)objectWriter._generatorFactory).createGenerator(dataOutput));
    }

    public SequenceWriter writeValues(File file) {
        return this._newSequenceWriter(false, this.createGenerator(file, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValues(JsonGenerator jsonGenerator) {
        this._assertNotNull("g", jsonGenerator);
        return this._newSequenceWriter(false, this._configureGenerator(jsonGenerator), false);
    }

    public SequenceWriter writeValues(Writer writer) {
        return this._newSequenceWriter(false, this.createGenerator(writer), true);
    }

    public SequenceWriter writeValues(OutputStream outputStream) {
        return this._newSequenceWriter(false, this.createGenerator(outputStream, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValues(DataOutput dataOutput) {
        return this._newSequenceWriter(false, this.createGenerator(dataOutput), true);
    }

    public SequenceWriter writeValuesAsArray(File file) {
        return this._newSequenceWriter(true, this.createGenerator(file, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValuesAsArray(JsonGenerator jsonGenerator) {
        this._assertNotNull("gen", jsonGenerator);
        return this._newSequenceWriter(true, jsonGenerator, false);
    }

    public SequenceWriter writeValuesAsArray(Writer writer) {
        return this._newSequenceWriter(true, this.createGenerator(writer), true);
    }

    public SequenceWriter writeValuesAsArray(OutputStream outputStream) {
        return this._newSequenceWriter(true, this.createGenerator(outputStream, JsonEncoding.UTF8), true);
    }

    public SequenceWriter writeValuesAsArray(DataOutput dataOutput) {
        return this._newSequenceWriter(true, this.createGenerator(dataOutput), true);
    }

    public boolean isEnabled(SerializationFeature serializationFeature) {
        return this._config.isEnabled(serializationFeature);
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    @Deprecated
    public boolean isEnabled(JsonParser$Feature jsonParser$Feature) {
        return ((TokenStreamFactory)this._generatorFactory).isEnabled(jsonParser$Feature);
    }

    public boolean isEnabled(JsonGenerator$Feature jsonGenerator$Feature) {
        return ((TokenStreamFactory)this._generatorFactory).isEnabled(jsonGenerator$Feature);
    }

    public boolean isEnabled(StreamWriteFeature streamWriteFeature) {
        return this._generatorFactory.isEnabled(streamWriteFeature);
    }

    public SerializationConfig getConfig() {
        return this._config;
    }

    public JsonFactory getFactory() {
        return this._generatorFactory;
    }

    public TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public boolean hasPrefetchedSerializer() {
        return this._prefetch.hasSerializer();
    }

    public ContextAttributes getAttributes() {
        return ((MapperConfig)this._config).getAttributes();
    }

    public void writeValue(JsonGenerator jsonGenerator, Object object) {
        this._assertNotNull("g", jsonGenerator);
        this._configureGenerator(jsonGenerator);
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            Closeable closeable = (Closeable)object;
            try {
                this._prefetch.serialize(jsonGenerator, object, this._serializerProvider());
                if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                    jsonGenerator.flush();
                }
            }
            catch (Exception exception) {
                ClassUtil.closeOnFailAndThrowAsIOE(null, closeable, exception);
                return;
            }
            closeable.close();
            return;
        }
        this._prefetch.serialize(jsonGenerator, object, this._serializerProvider());
        if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
            jsonGenerator.flush();
        }
    }

    public void writeValue(File file, Object object) {
        ObjectWriter objectWriter = this;
        objectWriter._writeValueAndClose(objectWriter.createGenerator(file, JsonEncoding.UTF8), object);
    }

    public void writeValue(OutputStream outputStream, Object object) {
        ObjectWriter objectWriter = this;
        objectWriter._writeValueAndClose(objectWriter.createGenerator(outputStream, JsonEncoding.UTF8), object);
    }

    public void writeValue(Writer writer, Object object) {
        ObjectWriter objectWriter = this;
        objectWriter._writeValueAndClose(objectWriter.createGenerator(writer), object);
    }

    public void writeValue(DataOutput dataOutput, Object object) {
        ObjectWriter objectWriter = this;
        objectWriter._writeValueAndClose(objectWriter.createGenerator(dataOutput), object);
    }

    public String writeValueAsString(Object object) {
        SegmentedStringWriter segmentedStringWriter = new SegmentedStringWriter(this._generatorFactory._getBufferRecycler());
        try {
            ObjectWriter objectWriter = this;
            objectWriter._writeValueAndClose(objectWriter.createGenerator(segmentedStringWriter), object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            object = jsonProcessingException;
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            object = iOException;
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
        return segmentedStringWriter.getAndClear();
    }

    public byte[] writeValueAsBytes(Object object) {
        Object object2 = new ByteArrayBuilder(this._generatorFactory._getBufferRecycler());
        Throwable throwable = null;
        try {
            ObjectWriter objectWriter = this;
            objectWriter._writeValueAndClose(objectWriter.createGenerator((OutputStream)object2, JsonEncoding.UTF8), object);
            object = ((ByteArrayBuilder)object2).toByteArray();
            ((ByteArrayBuilder)object2).release();
            ((ByteArrayBuilder)object2).close();
            return object;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    if (throwable != null) {
                        try {
                            ((ByteArrayBuilder)object2).close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        ((ByteArrayBuilder)object2).close();
                    }
                    throw throwable3;
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                object2 = jsonProcessingException;
                throw jsonProcessingException;
            }
            catch (IOException iOException) {
                object2 = iOException;
                throw JsonMappingException.fromUnexpectedIOE(iOException);
            }
        }
    }

    public void acceptJsonFormatVisitor(JavaType javaType, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) {
        this._assertNotNull("type", javaType);
        this._assertNotNull("visitor", jsonFormatVisitorWrapper);
        this._serializerProvider().acceptJsonFormatVisitor(javaType, jsonFormatVisitorWrapper);
    }

    public void acceptJsonFormatVisitor(Class<?> clazz, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) {
        this._assertNotNull("type", clazz);
        this._assertNotNull("visitor", jsonFormatVisitorWrapper);
        ObjectWriter objectWriter = this;
        objectWriter.acceptJsonFormatVisitor(objectWriter._config.constructType(clazz), jsonFormatVisitorWrapper);
    }

    public boolean canSerialize(Class<?> clazz) {
        this._assertNotNull("type", clazz);
        return this._serializerProvider().hasSerializerFor(clazz, null);
    }

    public boolean canSerialize(Class<?> clazz, AtomicReference<Throwable> atomicReference) {
        this._assertNotNull("type", clazz);
        return this._serializerProvider().hasSerializerFor(clazz, atomicReference);
    }

    protected DefaultSerializerProvider _serializerProvider() {
        return this._serializerProvider.createInstance(this._config, this._serializerFactory);
    }

    protected void _verifySchemaType(FormatSchema formatSchema) {
        if (formatSchema != null && !((TokenStreamFactory)this._generatorFactory).canUseSchema(formatSchema)) {
            throw new IllegalArgumentException("Cannot use FormatSchema of type " + formatSchema.getClass().getName() + " for format " + ((TokenStreamFactory)this._generatorFactory).getFormatName());
        }
    }

    protected final void _writeValueAndClose(JsonGenerator jsonGenerator, Object object) {
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseable(jsonGenerator, object);
            return;
        }
        try {
            this._prefetch.serialize(jsonGenerator, object, this._serializerProvider());
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIOE(jsonGenerator, exception);
            return;
        }
        jsonGenerator.close();
    }

    private final void _writeCloseable(JsonGenerator jsonGenerator, Object object) {
        Closeable closeable = (Closeable)object;
        try {
            this._prefetch.serialize(jsonGenerator, object, this._serializerProvider());
            object = closeable;
            closeable = null;
            object.close();
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIOE(jsonGenerator, closeable, exception);
            return;
        }
        jsonGenerator.close();
    }

    protected final JsonGenerator _configureGenerator(JsonGenerator jsonGenerator) {
        this._config.initialize(jsonGenerator);
        this._generatorSettings.initialize(jsonGenerator);
        return jsonGenerator;
    }

    protected final void _assertNotNull(String string, Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("argument \"%s\" is null", string));
        }
    }
}

