/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import com.fasterxml.jackson.annotation.JsonAutoDetect$Visibility;
import com.fasterxml.jackson.annotation.JsonInclude$Include;
import com.fasterxml.jackson.annotation.JsonInclude$Value;
import com.fasterxml.jackson.annotation.JsonSetter$Value;
import com.fasterxml.jackson.annotation.JsonTypeInfo$As;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectMapper$DefaultTyping;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperBuilder$1;
import com.fasterxml.jackson.databind.cfg.MutableCoercionConfig;
import com.fasterxml.jackson.databind.cfg.MutableConfigOverride;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy$Provider;
import com.fasterxml.jackson.databind.introspect.DefaultAccessorNamingStrategy$Provider;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.security.AccessController;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.TimeZone;
import java.util.function.Consumer;

public abstract class MapperBuilder<M extends ObjectMapper, B extends MapperBuilder<M, B>> {
    public final M _mapper;

    public MapperBuilder(M m2) {
        this._mapper = m2;
    }

    public M build() {
        return this._mapper;
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return ((ObjectMapper)this._mapper).isEnabled(mapperFeature);
    }

    public boolean isEnabled(DeserializationFeature deserializationFeature) {
        return ((ObjectMapper)this._mapper).isEnabled(deserializationFeature);
    }

    public boolean isEnabled(SerializationFeature serializationFeature) {
        return ((ObjectMapper)this._mapper).isEnabled(serializationFeature);
    }

    public boolean isEnabled(JsonParser$Feature jsonParser$Feature) {
        return ((ObjectMapper)this._mapper).isEnabled(jsonParser$Feature);
    }

    public boolean isEnabled(JsonGenerator$Feature jsonGenerator$Feature) {
        return ((ObjectMapper)this._mapper).isEnabled(jsonGenerator$Feature);
    }

    public TokenStreamFactory streamFactory() {
        return ((ObjectMapper)this._mapper).tokenStreamFactory();
    }

    public B enable(MapperFeature ... mapperFeatureArray) {
        ((ObjectMapper)this._mapper).enable(mapperFeatureArray);
        return this._this();
    }

    public B disable(MapperFeature ... mapperFeatureArray) {
        ((ObjectMapper)this._mapper).disable(mapperFeatureArray);
        return this._this();
    }

    public B configure(MapperFeature mapperFeature, boolean bl) {
        ((ObjectMapper)this._mapper).configure(mapperFeature, bl);
        return this._this();
    }

    public B enable(SerializationFeature ... serializationFeatureArray) {
        for (SerializationFeature serializationFeature : serializationFeatureArray) {
            ((ObjectMapper)this._mapper).enable(serializationFeature);
        }
        return this._this();
    }

    public B disable(SerializationFeature ... serializationFeatureArray) {
        for (SerializationFeature serializationFeature : serializationFeatureArray) {
            ((ObjectMapper)this._mapper).disable(serializationFeature);
        }
        return this._this();
    }

    public B configure(SerializationFeature serializationFeature, boolean bl) {
        ((ObjectMapper)this._mapper).configure(serializationFeature, bl);
        return this._this();
    }

    public B enable(DeserializationFeature ... deserializationFeatureArray) {
        for (DeserializationFeature deserializationFeature : deserializationFeatureArray) {
            ((ObjectMapper)this._mapper).enable(deserializationFeature);
        }
        return this._this();
    }

    public B disable(DeserializationFeature ... deserializationFeatureArray) {
        for (DeserializationFeature deserializationFeature : deserializationFeatureArray) {
            ((ObjectMapper)this._mapper).disable(deserializationFeature);
        }
        return this._this();
    }

    public B configure(DeserializationFeature deserializationFeature, boolean bl) {
        ((ObjectMapper)this._mapper).configure(deserializationFeature, bl);
        return this._this();
    }

    public B enable(JsonParser$Feature ... jsonParser$FeatureArray) {
        ((ObjectMapper)this._mapper).enable(jsonParser$FeatureArray);
        return this._this();
    }

    public B disable(JsonParser$Feature ... jsonParser$FeatureArray) {
        ((ObjectMapper)this._mapper).disable(jsonParser$FeatureArray);
        return this._this();
    }

    public B configure(JsonParser$Feature jsonParser$Feature, boolean bl) {
        ((ObjectMapper)this._mapper).configure(jsonParser$Feature, bl);
        return this._this();
    }

    public B enable(JsonGenerator$Feature ... jsonGenerator$FeatureArray) {
        ((ObjectMapper)this._mapper).enable(jsonGenerator$FeatureArray);
        return this._this();
    }

    public B disable(JsonGenerator$Feature ... jsonGenerator$FeatureArray) {
        ((ObjectMapper)this._mapper).disable(jsonGenerator$FeatureArray);
        return this._this();
    }

    public B configure(JsonGenerator$Feature jsonGenerator$Feature, boolean bl) {
        ((ObjectMapper)this._mapper).configure(jsonGenerator$Feature, bl);
        return this._this();
    }

    public B enable(StreamReadFeature ... streamReadFeatureArray) {
        for (StreamReadFeature streamReadFeature : streamReadFeatureArray) {
            ((ObjectMapper)this._mapper).enable(streamReadFeature.mappedFeature());
        }
        return this._this();
    }

    public B disable(StreamReadFeature ... streamReadFeatureArray) {
        for (StreamReadFeature streamReadFeature : streamReadFeatureArray) {
            ((ObjectMapper)this._mapper).disable(streamReadFeature.mappedFeature());
        }
        return this._this();
    }

    public B configure(StreamReadFeature streamReadFeature, boolean bl) {
        ((ObjectMapper)this._mapper).configure(streamReadFeature.mappedFeature(), bl);
        return this._this();
    }

    public B enable(StreamWriteFeature ... streamWriteFeatureArray) {
        for (StreamWriteFeature streamWriteFeature : streamWriteFeatureArray) {
            ((ObjectMapper)this._mapper).enable(streamWriteFeature.mappedFeature());
        }
        return this._this();
    }

    public B disable(StreamWriteFeature ... streamWriteFeatureArray) {
        for (StreamWriteFeature streamWriteFeature : streamWriteFeatureArray) {
            ((ObjectMapper)this._mapper).disable(streamWriteFeature.mappedFeature());
        }
        return this._this();
    }

    public B configure(StreamWriteFeature streamWriteFeature, boolean bl) {
        ((ObjectMapper)this._mapper).configure(streamWriteFeature.mappedFeature(), bl);
        return this._this();
    }

    public B withConfigOverride(Class<?> clazz, Consumer<MutableConfigOverride> consumer) {
        consumer.accept(((ObjectMapper)this._mapper).configOverride(clazz));
        return this._this();
    }

    public B withCoercionConfig(LogicalType logicalType, Consumer<MutableCoercionConfig> consumer) {
        consumer.accept(((ObjectMapper)this._mapper).coercionConfigFor(logicalType));
        return this._this();
    }

    public B withCoercionConfig(Class<?> clazz, Consumer<MutableCoercionConfig> consumer) {
        consumer.accept(((ObjectMapper)this._mapper).coercionConfigFor(clazz));
        return this._this();
    }

    public B withCoercionConfigDefaults(Consumer<MutableCoercionConfig> consumer) {
        consumer.accept(((ObjectMapper)this._mapper).coercionConfigDefaults());
        return this._this();
    }

    public B addModule(Module module) {
        ((ObjectMapper)this._mapper).registerModule(module);
        return this._this();
    }

    public B addModules(Module ... moduleArray) {
        for (Module module : moduleArray) {
            this.addModule(module);
        }
        return this._this();
    }

    public B addModules(Iterable<? extends Module> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Module module = (Module)object.next();
            this.addModule(module);
        }
        return this._this();
    }

    public static List<Module> findModules() {
        return MapperBuilder.findModules(null);
    }

    public static List<Module> findModules(ClassLoader iterator) {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        iterator = MapperBuilder.secureGetServiceLoader(Module.class, (ClassLoader)((Object)iterator));
        iterator = ((ServiceLoader)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            Module module = iterator.next();
            arrayList.add(module);
        }
        return arrayList;
    }

    private static <T> ServiceLoader<T> secureGetServiceLoader(Class<T> clazz, ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            if (classLoader == null) {
                return ServiceLoader.load(clazz);
            }
            return ServiceLoader.load(clazz, classLoader);
        }
        return (ServiceLoader)AccessController.doPrivileged(new MapperBuilder$1(classLoader, clazz));
    }

    public B findAndAddModules() {
        return this.addModules(MapperBuilder.findModules());
    }

    public B annotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        ((ObjectMapper)this._mapper).setAnnotationIntrospector(annotationIntrospector);
        return this._this();
    }

    public B defaultAttributes(ContextAttributes contextAttributes) {
        ((ObjectMapper)this._mapper).setDefaultAttributes(contextAttributes);
        return this._this();
    }

    public B typeFactory(TypeFactory typeFactory) {
        ((ObjectMapper)this._mapper).setTypeFactory(typeFactory);
        return this._this();
    }

    public B subtypeResolver(SubtypeResolver subtypeResolver) {
        ((ObjectMapper)this._mapper).setSubtypeResolver(subtypeResolver);
        return this._this();
    }

    public B visibility(VisibilityChecker<?> visibilityChecker) {
        ((ObjectMapper)this._mapper).setVisibility(visibilityChecker);
        return this._this();
    }

    public B visibility(PropertyAccessor propertyAccessor, JsonAutoDetect$Visibility jsonAutoDetect$Visibility) {
        ((ObjectMapper)this._mapper).setVisibility(propertyAccessor, jsonAutoDetect$Visibility);
        return this._this();
    }

    public B handlerInstantiator(HandlerInstantiator handlerInstantiator) {
        ((ObjectMapper)this._mapper).setHandlerInstantiator(handlerInstantiator);
        return this._this();
    }

    public B propertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        ((ObjectMapper)this._mapper).setPropertyNamingStrategy(propertyNamingStrategy);
        return this._this();
    }

    public B accessorNaming(AccessorNamingStrategy$Provider accessorNamingStrategy$Provider) {
        if (accessorNamingStrategy$Provider == null) {
            accessorNamingStrategy$Provider = new DefaultAccessorNamingStrategy$Provider();
        }
        ((ObjectMapper)this._mapper).setAccessorNaming(accessorNamingStrategy$Provider);
        return this._this();
    }

    public B serializerFactory(SerializerFactory serializerFactory) {
        ((ObjectMapper)this._mapper).setSerializerFactory(serializerFactory);
        return this._this();
    }

    public B filterProvider(FilterProvider filterProvider) {
        ((ObjectMapper)this._mapper).setFilterProvider(filterProvider);
        return this._this();
    }

    public B defaultPrettyPrinter(PrettyPrinter prettyPrinter) {
        ((ObjectMapper)this._mapper).setDefaultPrettyPrinter(prettyPrinter);
        return this._this();
    }

    public B injectableValues(InjectableValues injectableValues) {
        ((ObjectMapper)this._mapper).setInjectableValues(injectableValues);
        return this._this();
    }

    public B nodeFactory(JsonNodeFactory jsonNodeFactory) {
        ((ObjectMapper)this._mapper).setNodeFactory(jsonNodeFactory);
        return this._this();
    }

    public B constructorDetector(ConstructorDetector constructorDetector) {
        ((ObjectMapper)this._mapper).setConstructorDetector(constructorDetector);
        return this._this();
    }

    public B addHandler(DeserializationProblemHandler deserializationProblemHandler) {
        ((ObjectMapper)this._mapper).addHandler(deserializationProblemHandler);
        return this._this();
    }

    public B clearProblemHandlers() {
        ((ObjectMapper)this._mapper).clearProblemHandlers();
        return this._this();
    }

    public B defaultSetterInfo(JsonSetter$Value jsonSetter$Value) {
        ((ObjectMapper)this._mapper).setDefaultSetterInfo(jsonSetter$Value);
        return this._this();
    }

    public B defaultMergeable(Boolean bl) {
        ((ObjectMapper)this._mapper).setDefaultMergeable(bl);
        return this._this();
    }

    public B defaultLeniency(Boolean bl) {
        ((ObjectMapper)this._mapper).setDefaultLeniency(bl);
        return this._this();
    }

    public B defaultDateFormat(DateFormat dateFormat) {
        ((ObjectMapper)this._mapper).setDateFormat(dateFormat);
        return this._this();
    }

    public B defaultTimeZone(TimeZone timeZone) {
        ((ObjectMapper)this._mapper).setTimeZone(timeZone);
        return this._this();
    }

    public B defaultLocale(Locale locale) {
        ((ObjectMapper)this._mapper).setLocale(locale);
        return this._this();
    }

    public B defaultBase64Variant(Base64Variant base64Variant) {
        ((ObjectMapper)this._mapper).setBase64Variant(base64Variant);
        return this._this();
    }

    public B serializationInclusion(JsonInclude$Include jsonInclude$Include) {
        ((ObjectMapper)this._mapper).setSerializationInclusion(jsonInclude$Include);
        return this._this();
    }

    public B defaultPropertyInclusion(JsonInclude$Value jsonInclude$Value) {
        ((ObjectMapper)this._mapper).setDefaultPropertyInclusion(jsonInclude$Value);
        return this._this();
    }

    public B addMixIn(Class<?> clazz, Class<?> clazz2) {
        ((ObjectMapper)this._mapper).addMixIn(clazz, clazz2);
        return this._this();
    }

    public B removeMixIn(Class<?> clazz) {
        ((ObjectMapper)this._mapper).addMixIn(clazz, null);
        return this._this();
    }

    public B registerSubtypes(Class<?> ... classArray) {
        ((ObjectMapper)this._mapper).registerSubtypes(classArray);
        return this._this();
    }

    public B registerSubtypes(NamedType ... namedTypeArray) {
        ((ObjectMapper)this._mapper).registerSubtypes(namedTypeArray);
        return this._this();
    }

    public B registerSubtypes(Collection<Class<?>> collection) {
        ((ObjectMapper)this._mapper).registerSubtypes(collection);
        return this._this();
    }

    public B polymorphicTypeValidator(PolymorphicTypeValidator polymorphicTypeValidator) {
        ((ObjectMapper)this._mapper).setPolymorphicTypeValidator(polymorphicTypeValidator);
        return this._this();
    }

    public B activateDefaultTyping(PolymorphicTypeValidator polymorphicTypeValidator) {
        ((ObjectMapper)this._mapper).activateDefaultTyping(polymorphicTypeValidator);
        return this._this();
    }

    public B activateDefaultTyping(PolymorphicTypeValidator polymorphicTypeValidator, ObjectMapper$DefaultTyping objectMapper$DefaultTyping) {
        ((ObjectMapper)this._mapper).activateDefaultTyping(polymorphicTypeValidator, objectMapper$DefaultTyping);
        return this._this();
    }

    public B activateDefaultTyping(PolymorphicTypeValidator polymorphicTypeValidator, ObjectMapper$DefaultTyping objectMapper$DefaultTyping, JsonTypeInfo$As jsonTypeInfo$As) {
        ((ObjectMapper)this._mapper).activateDefaultTyping(polymorphicTypeValidator, objectMapper$DefaultTyping, jsonTypeInfo$As);
        return this._this();
    }

    public B activateDefaultTypingAsProperty(PolymorphicTypeValidator polymorphicTypeValidator, ObjectMapper$DefaultTyping objectMapper$DefaultTyping, String string) {
        ((ObjectMapper)this._mapper).activateDefaultTypingAsProperty(polymorphicTypeValidator, objectMapper$DefaultTyping, string);
        return this._this();
    }

    public B deactivateDefaultTyping() {
        ((ObjectMapper)this._mapper).deactivateDefaultTyping();
        return this._this();
    }

    public B setDefaultTyping(TypeResolverBuilder<?> typeResolverBuilder) {
        ((ObjectMapper)this._mapper).setDefaultTyping(typeResolverBuilder);
        return this._this();
    }

    protected final B _this() {
        return (B)this;
    }
}

