/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import com.fasterxml.jackson.annotation.JsonFormat$Value;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties$Value;
import com.fasterxml.jackson.annotation.JsonInclude$Value;
import com.fasterxml.jackson.annotation.JsonIncludeProperties$Value;
import com.fasterxml.jackson.annotation.JsonSetter$Value;
import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.fasterxml.jackson.databind.cfg.ConfigFeature;
import com.fasterxml.jackson.databind.cfg.ConfigOverride;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy$Provider;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector$MixInResolver;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.DefaultBaseTypeLimitingValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Locale;
import java.util.TimeZone;

public abstract class MapperConfig<T extends MapperConfig<T>>
implements ClassIntrospector$MixInResolver,
Serializable {
    private static final long serialVersionUID = 2L;
    protected static final JsonInclude$Value EMPTY_INCLUDE = JsonInclude$Value.empty();
    protected static final JsonFormat$Value EMPTY_FORMAT = JsonFormat$Value.empty();
    public final long _mapperFeatures;
    public final BaseSettings _base;

    protected MapperConfig(BaseSettings baseSettings, long l2) {
        this._base = baseSettings;
        this._mapperFeatures = l2;
    }

    protected MapperConfig(MapperConfig<T> mapperConfig, long l2) {
        this._base = mapperConfig._base;
        this._mapperFeatures = l2;
    }

    protected MapperConfig(MapperConfig<T> mapperConfig, BaseSettings baseSettings) {
        this._base = baseSettings;
        this._mapperFeatures = mapperConfig._mapperFeatures;
    }

    protected MapperConfig(MapperConfig<T> mapperConfig) {
        this._base = mapperConfig._base;
        this._mapperFeatures = mapperConfig._mapperFeatures;
    }

    public static <F extends Enum<F>> int collectFeatureDefaults(Class<F> enumArray) {
        int n2 = 0;
        for (Enum enum_ : (Enum[])enumArray.getEnumConstants()) {
            if (!((ConfigFeature)((Object)enum_)).enabledByDefault()) continue;
            n2 |= ((ConfigFeature)((Object)enum_)).getMask();
        }
        return n2;
    }

    public abstract T with(MapperFeature ... var1);

    public abstract T without(MapperFeature ... var1);

    public abstract T with(MapperFeature var1, boolean var2);

    public final boolean isEnabled(MapperFeature mapperFeature) {
        return mapperFeature.enabledIn(this._mapperFeatures);
    }

    @Deprecated
    public final boolean hasMapperFeatures(int n2) {
        return (this._mapperFeatures & (long)n2) == (long)n2;
    }

    public final boolean isAnnotationProcessingEnabled() {
        return this.isEnabled(MapperFeature.USE_ANNOTATIONS);
    }

    public final boolean canOverrideAccessModifiers() {
        return this.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS);
    }

    public final boolean shouldSortPropertiesAlphabetically() {
        return this.isEnabled(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY);
    }

    public abstract boolean useRootWrapping();

    public SerializableString compileString(String string) {
        return new SerializedString(string);
    }

    public ClassIntrospector getClassIntrospector() {
        return this._base.getClassIntrospector();
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        if (this.isEnabled(MapperFeature.USE_ANNOTATIONS)) {
            return this._base.getAnnotationIntrospector();
        }
        return NopAnnotationIntrospector.instance;
    }

    public final PropertyNamingStrategy getPropertyNamingStrategy() {
        return this._base.getPropertyNamingStrategy();
    }

    public final AccessorNamingStrategy$Provider getAccessorNaming() {
        return this._base.getAccessorNaming();
    }

    public final HandlerInstantiator getHandlerInstantiator() {
        return this._base.getHandlerInstantiator();
    }

    public final TypeResolverBuilder<?> getDefaultTyper(JavaType javaType) {
        return this._base.getTypeResolverBuilder();
    }

    public abstract SubtypeResolver getSubtypeResolver();

    public PolymorphicTypeValidator getPolymorphicTypeValidator() {
        PolymorphicTypeValidator polymorphicTypeValidator = this._base.getPolymorphicTypeValidator();
        if (polymorphicTypeValidator == LaissezFaireSubTypeValidator.instance && this.isEnabled(MapperFeature.BLOCK_UNSAFE_POLYMORPHIC_BASE_TYPES)) {
            polymorphicTypeValidator = new DefaultBaseTypeLimitingValidator();
        }
        return polymorphicTypeValidator;
    }

    public final TypeFactory getTypeFactory() {
        return this._base.getTypeFactory();
    }

    public final JavaType constructType(Class<?> clazz) {
        return this.getTypeFactory().constructType(clazz);
    }

    public final JavaType constructType(TypeReference<?> typeReference) {
        return this.getTypeFactory().constructType(typeReference.getType());
    }

    public JavaType constructSpecializedType(JavaType javaType, Class<?> clazz) {
        return this.getTypeFactory().constructSpecializedType(javaType, clazz, true);
    }

    public BeanDescription introspectClassAnnotations(Class<?> clazz) {
        MapperConfig mapperConfig = this;
        return mapperConfig.introspectClassAnnotations(mapperConfig.constructType(clazz));
    }

    public BeanDescription introspectClassAnnotations(JavaType javaType) {
        return this.getClassIntrospector().forClassAnnotations(this, javaType, this);
    }

    public BeanDescription introspectDirectClassAnnotations(Class<?> clazz) {
        MapperConfig mapperConfig = this;
        return mapperConfig.introspectDirectClassAnnotations(mapperConfig.constructType(clazz));
    }

    public final BeanDescription introspectDirectClassAnnotations(JavaType javaType) {
        return this.getClassIntrospector().forDirectClassAnnotations(this, javaType, this);
    }

    public abstract ConfigOverride findConfigOverride(Class<?> var1);

    public abstract ConfigOverride getConfigOverride(Class<?> var1);

    public abstract JsonInclude$Value getDefaultPropertyInclusion();

    public abstract JsonInclude$Value getDefaultPropertyInclusion(Class<?> var1);

    public JsonInclude$Value getDefaultPropertyInclusion(Class<?> serializable, JsonInclude$Value jsonInclude$Value) {
        if ((serializable = this.getConfigOverride((Class<?>)serializable).getInclude()) != null) {
            return serializable;
        }
        return jsonInclude$Value;
    }

    public abstract JsonInclude$Value getDefaultInclusion(Class<?> var1, Class<?> var2);

    public JsonInclude$Value getDefaultInclusion(Class<?> serializable, Class<?> serializable2, JsonInclude$Value jsonInclude$Value) {
        serializable = this.getConfigOverride((Class<?>)serializable).getInclude();
        serializable2 = this.getConfigOverride((Class<?>)serializable2).getIncludeAsProperty();
        serializable = JsonInclude$Value.mergeAll(new JsonInclude$Value[]{jsonInclude$Value, serializable, serializable2});
        return serializable;
    }

    public abstract JsonFormat$Value getDefaultPropertyFormat(Class<?> var1);

    public abstract JsonIgnoreProperties$Value getDefaultPropertyIgnorals(Class<?> var1);

    public abstract JsonIgnoreProperties$Value getDefaultPropertyIgnorals(Class<?> var1, AnnotatedClass var2);

    public abstract JsonIncludeProperties$Value getDefaultPropertyInclusions(Class<?> var1, AnnotatedClass var2);

    public abstract VisibilityChecker<?> getDefaultVisibilityChecker();

    public abstract VisibilityChecker<?> getDefaultVisibilityChecker(Class<?> var1, AnnotatedClass var2);

    public abstract JsonSetter$Value getDefaultSetterInfo();

    public abstract Boolean getDefaultMergeable();

    public abstract Boolean getDefaultMergeable(Class<?> var1);

    public final DateFormat getDateFormat() {
        return this._base.getDateFormat();
    }

    public final Locale getLocale() {
        return this._base.getLocale();
    }

    public final TimeZone getTimeZone() {
        return this._base.getTimeZone();
    }

    public boolean hasExplicitTimeZone() {
        return this._base.hasExplicitTimeZone();
    }

    public abstract Class<?> getActiveView();

    public Base64Variant getBase64Variant() {
        return this._base.getBase64Variant();
    }

    public abstract ContextAttributes getAttributes();

    public abstract PropertyName findRootName(JavaType var1);

    public abstract PropertyName findRootName(Class<?> var1);

    public TypeResolverBuilder<?> typeResolverBuilderInstance(Annotated object, Class<? extends TypeResolverBuilder<?>> clazz) {
        HandlerInstantiator handlerInstantiator = this.getHandlerInstantiator();
        if (handlerInstantiator != null && (object = handlerInstantiator.typeResolverBuilderInstance(this, (Annotated)object, clazz)) != null) {
            return object;
        }
        return ClassUtil.createInstance(clazz, this.canOverrideAccessModifiers());
    }

    public TypeIdResolver typeIdResolverInstance(Annotated object, Class<? extends TypeIdResolver> clazz) {
        HandlerInstantiator handlerInstantiator = this.getHandlerInstantiator();
        if (handlerInstantiator != null && (object = handlerInstantiator.typeIdResolverInstance(this, (Annotated)object, clazz)) != null) {
            return object;
        }
        return ClassUtil.createInstance(clazz, this.canOverrideAccessModifiers());
    }
}

