/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.ArrayIterator;
import java.io.Serializable;

public final class SerializerFactoryConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Serializers[] NO_SERIALIZERS = new Serializers[0];
    protected static final BeanSerializerModifier[] NO_MODIFIERS = new BeanSerializerModifier[0];
    protected final Serializers[] _additionalSerializers;
    protected final Serializers[] _additionalKeySerializers;
    protected final BeanSerializerModifier[] _modifiers;

    public SerializerFactoryConfig() {
        this(null, null, null);
    }

    protected SerializerFactoryConfig(Serializers[] serializersArray, Serializers[] serializersArray2, BeanSerializerModifier[] beanSerializerModifierArray) {
        this._additionalSerializers = serializersArray == null ? NO_SERIALIZERS : serializersArray;
        this._additionalKeySerializers = serializersArray2 == null ? NO_SERIALIZERS : serializersArray2;
        this._modifiers = beanSerializerModifierArray == null ? NO_MODIFIERS : beanSerializerModifierArray;
    }

    public final SerializerFactoryConfig withAdditionalSerializers(Serializers serializersArray) {
        if (serializersArray == null) {
            throw new IllegalArgumentException("Cannot pass null Serializers");
        }
        serializersArray = ArrayBuilders.insertInListNoDup(this._additionalSerializers, serializersArray);
        return new SerializerFactoryConfig(serializersArray, this._additionalKeySerializers, this._modifiers);
    }

    public final SerializerFactoryConfig withAdditionalKeySerializers(Serializers serializersArray) {
        if (serializersArray == null) {
            throw new IllegalArgumentException("Cannot pass null Serializers");
        }
        serializersArray = ArrayBuilders.insertInListNoDup(this._additionalKeySerializers, serializersArray);
        return new SerializerFactoryConfig(this._additionalSerializers, serializersArray, this._modifiers);
    }

    public final SerializerFactoryConfig withSerializerModifier(BeanSerializerModifier beanSerializerModifierArray) {
        if (beanSerializerModifierArray == null) {
            throw new IllegalArgumentException("Cannot pass null modifier");
        }
        beanSerializerModifierArray = ArrayBuilders.insertInListNoDup(this._modifiers, beanSerializerModifierArray);
        return new SerializerFactoryConfig(this._additionalSerializers, this._additionalKeySerializers, beanSerializerModifierArray);
    }

    public final boolean hasSerializers() {
        return this._additionalSerializers.length > 0;
    }

    public final boolean hasKeySerializers() {
        return this._additionalKeySerializers.length > 0;
    }

    public final boolean hasSerializerModifiers() {
        return this._modifiers.length > 0;
    }

    public final Iterable<Serializers> serializers() {
        return new ArrayIterator<Serializers>(this._additionalSerializers);
    }

    public final Iterable<Serializers> keySerializers() {
        return new ArrayIterator<Serializers>(this._additionalKeySerializers);
    }

    public final Iterable<BeanSerializerModifier> serializerModifiers() {
        return new ArrayIterator<BeanSerializerModifier>(this._modifiers);
    }
}

