/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JacksonInject$Value;
import com.fasterxml.jackson.annotation.JsonCreator$Mode;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties$Value;
import com.fasterxml.jackson.annotation.JsonIncludeProperties$Value;
import com.fasterxml.jackson.annotation.JsonSetter$Value;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.BeanProperty$Std;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.ConfigOverride;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.AbstractDeserializer;
import com.fasterxml.jackson.databind.deser.BasicDeserializerFactory$ContainerDefaultMappings;
import com.fasterxml.jackson.databind.deser.BasicDeserializerFactory$CreatorCollectionState;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.fasterxml.jackson.databind.deser.impl.CreatorCandidate;
import com.fasterxml.jackson.databind.deser.impl.CreatorCollector;
import com.fasterxml.jackson.databind.deser.impl.JDKValueInstantiators;
import com.fasterxml.jackson.databind.deser.impl.JavaUtilCollectionsDeserializers;
import com.fasterxml.jackson.databind.deser.std.ArrayBlockingQueueDeserializer;
import com.fasterxml.jackson.databind.deser.std.AtomicReferenceDeserializer;
import com.fasterxml.jackson.databind.deser.std.CollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.fasterxml.jackson.databind.deser.std.EnumDeserializer;
import com.fasterxml.jackson.databind.deser.std.EnumMapDeserializer;
import com.fasterxml.jackson.databind.deser.std.EnumSetDeserializer;
import com.fasterxml.jackson.databind.deser.std.JdkDeserializers;
import com.fasterxml.jackson.databind.deser.std.JsonNodeDeserializer;
import com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import com.fasterxml.jackson.databind.deser.std.MapEntryDeserializer;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import com.fasterxml.jackson.databind.deser.std.ObjectArrayDeserializer;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializers;
import com.fasterxml.jackson.databind.deser.std.StringArrayDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringCollectionDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.deser.std.TokenBufferDeserializer;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.ext.OptionalHandlerFactory;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jdk14.JDK14Util;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;

public abstract class BasicDeserializerFactory
extends DeserializerFactory
implements Serializable {
    private static final Class<?> CLASS_OBJECT = Object.class;
    private static final Class<?> CLASS_STRING = String.class;
    private static final Class<?> CLASS_CHAR_SEQUENCE = CharSequence.class;
    private static final Class<?> CLASS_ITERABLE = Iterable.class;
    private static final Class<?> CLASS_MAP_ENTRY = Map.Entry.class;
    private static final Class<?> CLASS_SERIALIZABLE = Serializable.class;
    protected static final PropertyName UNWRAPPED_CREATOR_PARAM_NAME = new PropertyName("@JsonUnwrapped");
    protected final DeserializerFactoryConfig _factoryConfig;

    protected BasicDeserializerFactory(DeserializerFactoryConfig deserializerFactoryConfig) {
        this._factoryConfig = deserializerFactoryConfig;
    }

    public DeserializerFactoryConfig getFactoryConfig() {
        return this._factoryConfig;
    }

    protected abstract DeserializerFactory withConfig(DeserializerFactoryConfig var1);

    @Override
    public final DeserializerFactory withAdditionalDeserializers(Deserializers deserializers) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withAdditionalDeserializers(deserializers));
    }

    @Override
    public final DeserializerFactory withAdditionalKeyDeserializers(KeyDeserializers keyDeserializers) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withAdditionalKeyDeserializers(keyDeserializers));
    }

    @Override
    public final DeserializerFactory withDeserializerModifier(BeanDeserializerModifier beanDeserializerModifier) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withDeserializerModifier(beanDeserializerModifier));
    }

    @Override
    public final DeserializerFactory withAbstractTypeResolver(AbstractTypeResolver abstractTypeResolver) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withAbstractTypeResolver(abstractTypeResolver));
    }

    @Override
    public final DeserializerFactory withValueInstantiators(ValueInstantiators valueInstantiators) {
        BasicDeserializerFactory basicDeserializerFactory = this;
        return basicDeserializerFactory.withConfig(basicDeserializerFactory._factoryConfig.withValueInstantiators(valueInstantiators));
    }

    @Override
    public JavaType mapAbstractType(DeserializationConfig deserializationConfig, JavaType javaType) {
        JavaType javaType2;
        while ((javaType2 = this._mapAbstractType2(deserializationConfig, javaType)) != null) {
            Class<?> clazz;
            Class<?> clazz2 = ((ResolvedType)javaType).getRawClass();
            if (clazz2 == (clazz = ((ResolvedType)javaType2).getRawClass()) || !clazz2.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Invalid abstract type resolution from " + javaType + " to " + javaType2 + ": latter is not a subtype of former");
            }
            javaType = javaType2;
        }
        return javaType;
    }

    private JavaType _mapAbstractType2(DeserializationConfig deserializationConfig, JavaType javaType) {
        Class<?> clazz = ((ResolvedType)javaType).getRawClass();
        if (this._factoryConfig.hasAbstractTypeResolvers()) {
            for (AbstractTypeResolver abstractTypeResolver : this._factoryConfig.abstractTypeResolvers()) {
                JavaType object = abstractTypeResolver.findTypeMapping(deserializationConfig, javaType);
                if (object == null || ((ResolvedType)object).hasRawClass(clazz)) continue;
                return object;
            }
        }
        return null;
    }

    @Override
    public ValueInstantiator findValueInstantiator(DeserializationContext deserializationContext, BeanDescription beanDescription) {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        ValueInstantiator valueInstantiator = null;
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        Object object2 = ((DatabindContext)deserializationContext).getAnnotationIntrospector().findValueInstantiator(annotatedClass);
        if (object2 != null) {
            valueInstantiator = this._valueInstantiatorInstance(deserializationConfig, annotatedClass, object2);
        }
        if (valueInstantiator == null && (valueInstantiator = JDKValueInstantiators.findStdValueInstantiator(deserializationConfig, beanDescription.getBeanClass())) == null) {
            valueInstantiator = this._constructDefaultValueInstantiator(deserializationContext, beanDescription);
        }
        if (this._factoryConfig.hasValueInstantiators()) {
            for (ValueInstantiators valueInstantiators : this._factoryConfig.valueInstantiators()) {
                valueInstantiator = valueInstantiators.findValueInstantiator(deserializationConfig, beanDescription, valueInstantiator);
                if (valueInstantiator != null) continue;
                deserializationContext.reportBadTypeDefinition(beanDescription, "Broken registered ValueInstantiators (of type %s): returned null ValueInstantiator", valueInstantiators.getClass().getName());
            }
        }
        if (valueInstantiator != null) {
            valueInstantiator = valueInstantiator.createContextual(deserializationContext, beanDescription);
        }
        return valueInstantiator;
    }

    protected ValueInstantiator _constructDefaultValueInstantiator(DeserializationContext deserializationContext, BeanDescription beanDescription) {
        ArrayList<String> arrayList = deserializationContext.getConfig();
        Object object = ((MapperConfig)((Object)arrayList)).getDefaultVisibilityChecker(beanDescription.getBeanClass(), beanDescription.getClassInfo());
        ConstructorDetector constructorDetector = ((DeserializationConfig)((Object)arrayList)).getConstructorDetector();
        Object object2 = new CreatorCollector(beanDescription, (MapperConfig<?>)((Object)arrayList));
        arrayList = this._findCreatorsFromProperties(deserializationContext, beanDescription);
        object2 = new BasicDeserializerFactory$CreatorCollectionState(deserializationContext, beanDescription, (VisibilityChecker<?>)object, (CreatorCollector)object2, (Map<AnnotatedWithParams, BeanPropertyDefinition[]>)((Object)arrayList));
        this._addExplicitFactoryCreators(deserializationContext, (BasicDeserializerFactory$CreatorCollectionState)object2, !constructorDetector.requireCtorAnnotation());
        if (((ResolvedType)beanDescription.getType()).isConcrete()) {
            if (beanDescription.getType().isRecordType() && (object = JDK14Util.findRecordConstructor(deserializationContext, beanDescription, arrayList = new ArrayList<String>())) != null) {
                this._addRecordConstructor(deserializationContext, (BasicDeserializerFactory$CreatorCollectionState)object2, (AnnotatedConstructor)object, arrayList);
                return ((BasicDeserializerFactory$CreatorCollectionState)object2).creators.constructValueInstantiator(deserializationContext);
            }
            boolean bl = beanDescription.isNonStaticInnerClass();
            if (!bl) {
                boolean bl2 = constructorDetector.shouldIntrospectorImplicitConstructors(beanDescription.getBeanClass());
                this._addExplicitConstructorCreators(deserializationContext, (BasicDeserializerFactory$CreatorCollectionState)object2, bl2);
                if (((BasicDeserializerFactory$CreatorCollectionState)object2).hasImplicitConstructorCandidates() && !((BasicDeserializerFactory$CreatorCollectionState)object2).hasExplicitConstructors()) {
                    Object object3 = object2;
                    this._addImplicitConstructorCreators(deserializationContext, (BasicDeserializerFactory$CreatorCollectionState)object3, ((BasicDeserializerFactory$CreatorCollectionState)object3).implicitConstructorCandidates());
                }
            }
        }
        if (((BasicDeserializerFactory$CreatorCollectionState)object2).hasImplicitFactoryCandidates() && !((BasicDeserializerFactory$CreatorCollectionState)object2).hasExplicitFactories() && !((BasicDeserializerFactory$CreatorCollectionState)object2).hasExplicitConstructors()) {
            Object object4 = object2;
            this._addImplicitFactoryCreators(deserializationContext, (BasicDeserializerFactory$CreatorCollectionState)object4, ((BasicDeserializerFactory$CreatorCollectionState)object4).implicitFactoryCandidates());
        }
        return ((BasicDeserializerFactory$CreatorCollectionState)object2).creators.constructValueInstantiator(deserializationContext);
    }

    protected Map<AnnotatedWithParams, BeanPropertyDefinition[]> _findCreatorsFromProperties(DeserializationContext deserializationContext, BeanDescription beanDescription) {
        Map<AnnotatedWithParams, BeanPropertyDefinition[]> map = Collections.emptyMap();
        for (BeanPropertyDefinition beanPropertyDefinition : beanDescription.findProperties()) {
            Iterator<AnnotatedParameter> iterator = beanPropertyDefinition.getConstructorParameters();
            while (iterator.hasNext()) {
                AnnotatedParameter annotatedParameter = iterator.next();
                AnnotatedWithParams annotatedWithParams = annotatedParameter.getOwner();
                BeanPropertyDefinition[] beanPropertyDefinitionArray = map.get(annotatedWithParams);
                int n2 = annotatedParameter.getIndex();
                if (beanPropertyDefinitionArray == null) {
                    if (map.isEmpty()) {
                        map = new LinkedHashMap<AnnotatedWithParams, BeanPropertyDefinition[]>();
                    }
                    beanPropertyDefinitionArray = new BeanPropertyDefinition[annotatedWithParams.getParameterCount()];
                    map.put(annotatedWithParams, beanPropertyDefinitionArray);
                } else if (beanPropertyDefinitionArray[n2] != null) {
                    deserializationContext.reportBadTypeDefinition(beanDescription, "Conflict: parameter #%d of %s bound to more than one property; %s vs %s", n2, annotatedWithParams, beanPropertyDefinitionArray[n2], beanPropertyDefinition);
                }
                beanPropertyDefinitionArray[n2] = beanPropertyDefinition;
            }
        }
        return map;
    }

    public ValueInstantiator _valueInstantiatorInstance(DeserializationConfig deserializationConfig, Annotated object, Object object2) {
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof ValueInstantiator) {
            return (ValueInstantiator)object2;
        }
        if (!(object2 instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + object2.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
        }
        if (ClassUtil.isBogusClass(object2 = (Class)object2)) {
            return null;
        }
        if (!ValueInstantiator.class.isAssignableFrom((Class<?>)object2)) {
            throw new IllegalStateException("AnnotationIntrospector returned Class " + ((Class)object2).getName() + "; expected Class<ValueInstantiator>");
        }
        HandlerInstantiator handlerInstantiator = deserializationConfig.getHandlerInstantiator();
        if (handlerInstantiator != null && (object = handlerInstantiator.valueInstantiatorInstance(deserializationConfig, (Annotated)object, (Class<?>)object2)) != null) {
            return object;
        }
        return (ValueInstantiator)ClassUtil.createInstance(object2, deserializationConfig.canOverrideAccessModifiers());
    }

    protected void _addRecordConstructor(DeserializationContext deserializationContext, BasicDeserializerFactory$CreatorCollectionState basicDeserializerFactory$CreatorCollectionState, AnnotatedConstructor annotatedConstructor, List<String> list) {
        int n2 = ((AnnotatedWithParams)annotatedConstructor).getParameterCount();
        AnnotationIntrospector annotationIntrospector = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            AnnotatedParameter annotatedParameter = annotatedConstructor.getParameter(i2);
            JacksonInject$Value jacksonInject$Value = annotationIntrospector.findInjectableValue(annotatedParameter);
            PropertyName propertyName = annotationIntrospector.findNameForDeserialization(annotatedParameter);
            if (propertyName == null || propertyName.isEmpty()) {
                propertyName = PropertyName.construct(list.get(i2));
            }
            settableBeanPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, basicDeserializerFactory$CreatorCollectionState.beanDesc, propertyName, i2, annotatedParameter, jacksonInject$Value);
        }
        basicDeserializerFactory$CreatorCollectionState.creators.addPropertyCreator(annotatedConstructor, false, settableBeanPropertyArray);
    }

    protected void _addExplicitConstructorCreators(DeserializationContext deserializationContext, BasicDeserializerFactory$CreatorCollectionState basicDeserializerFactory$CreatorCollectionState, boolean bl) {
        BeanDescription beanDescription = basicDeserializerFactory$CreatorCollectionState.beanDesc;
        CreatorCollector creatorCollector = basicDeserializerFactory$CreatorCollectionState.creators;
        AnnotationIntrospector annotationIntrospector = basicDeserializerFactory$CreatorCollectionState.annotationIntrospector();
        VisibilityChecker<?> visibilityChecker = basicDeserializerFactory$CreatorCollectionState.vchecker;
        Map<AnnotatedWithParams, BeanPropertyDefinition[]> map = basicDeserializerFactory$CreatorCollectionState.creatorParams;
        AnnotatedConstructor annotatedConstructor = beanDescription.findDefaultConstructor();
        if (annotatedConstructor != null && (!creatorCollector.hasDefaultCreator() || this._hasCreatorAnnotation(deserializationContext, annotatedConstructor))) {
            creatorCollector.setDefaultCreator(annotatedConstructor);
        }
        for (AnnotatedConstructor annotatedConstructor2 : beanDescription.getConstructors()) {
            JsonCreator$Mode jsonCreator$Mode = annotationIntrospector.findCreatorAnnotation(deserializationContext.getConfig(), annotatedConstructor2);
            if (JsonCreator$Mode.DISABLED == jsonCreator$Mode) continue;
            if (jsonCreator$Mode == null) {
                if (!bl || !visibilityChecker.isCreatorVisible(annotatedConstructor2)) continue;
                basicDeserializerFactory$CreatorCollectionState.addImplicitConstructorCandidate(CreatorCandidate.construct(annotationIntrospector, annotatedConstructor2, map.get(annotatedConstructor2)));
                continue;
            }
            switch (jsonCreator$Mode) {
                case DELEGATING: {
                    this._addExplicitDelegatingCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedConstructor2, null));
                    break;
                }
                case PROPERTIES: {
                    this._addExplicitPropertyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedConstructor2, map.get(annotatedConstructor2)));
                    break;
                }
                default: {
                    this._addExplicitAnyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedConstructor2, map.get(annotatedConstructor2)), deserializationContext.getConfig().getConstructorDetector());
                }
            }
            basicDeserializerFactory$CreatorCollectionState.increaseExplicitConstructorCount();
        }
    }

    protected void _addImplicitConstructorCreators(DeserializationContext deserializationContext, BasicDeserializerFactory$CreatorCollectionState object, List<CreatorCandidate> object2) {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        BeanDescription beanDescription = ((BasicDeserializerFactory$CreatorCollectionState)object).beanDesc;
        CreatorCollector creatorCollector = ((BasicDeserializerFactory$CreatorCollectionState)object).creators;
        AnnotationIntrospector annotationIntrospector = ((BasicDeserializerFactory$CreatorCollectionState)object).annotationIntrospector();
        object = ((BasicDeserializerFactory$CreatorCollectionState)object).vchecker;
        LinkedList<AnnotatedWithParams> linkedList = null;
        boolean bl = deserializationConfig.getConstructorDetector().singleArgCreatorDefaultsToProperties();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Serializable serializable;
            int n2;
            CreatorCandidate creatorCandidate = (CreatorCandidate)object2.next();
            int n3 = creatorCandidate.paramCount();
            AnnotatedWithParams annotatedWithParams = creatorCandidate.creator();
            if (n3 == 1) {
                BeanPropertyDefinition beanPropertyDefinition = creatorCandidate.propertyDef(0);
                boolean bl2 = bl || this._checkIfCreatorPropertyBased(annotationIntrospector, annotatedWithParams, beanPropertyDefinition);
                if (bl2) {
                    SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[1];
                    JacksonInject$Value jacksonInject$Value = creatorCandidate.injection(0);
                    PropertyName propertyName = creatorCandidate.paramName(0);
                    if (propertyName == null && (propertyName = creatorCandidate.findImplicitParamName(0)) == null && jacksonInject$Value == null) continue;
                    settableBeanPropertyArray[0] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, 0, creatorCandidate.parameter(0), jacksonInject$Value);
                    creatorCollector.addPropertyCreator(annotatedWithParams, false, settableBeanPropertyArray);
                    continue;
                }
                this._handleSingleArgumentCreator(creatorCollector, annotatedWithParams, false, object.isCreatorVisible(annotatedWithParams));
                if (beanPropertyDefinition == null) continue;
                ((POJOPropertyBuilder)beanPropertyDefinition).removeConstructors();
                continue;
            }
            int n4 = -1;
            SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n3];
            int n5 = 0;
            int n6 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                PropertyName propertyName;
                serializable = annotatedWithParams.getParameter(n2);
                Object object3 = creatorCandidate.propertyDef(n2);
                JacksonInject$Value jacksonInject$Value = annotationIntrospector.findInjectableValue((AnnotatedMember)serializable);
                PropertyName propertyName2 = propertyName = object3 == null ? null : ((BeanPropertyDefinition)object3).getFullName();
                if (object3 != null && ((BeanPropertyDefinition)object3).isExplicitlyNamed()) {
                    ++n5;
                    settableBeanPropertyArray[n2] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n2, (AnnotatedParameter)serializable, jacksonInject$Value);
                    continue;
                }
                if (jacksonInject$Value != null) {
                    ++n6;
                    settableBeanPropertyArray[n2] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n2, (AnnotatedParameter)serializable, jacksonInject$Value);
                    continue;
                }
                object3 = annotationIntrospector.findUnwrappingNameTransformer((AnnotatedMember)serializable);
                if (object3 != null) {
                    this._reportUnwrappedCreatorProperty(deserializationContext, beanDescription, (AnnotatedParameter)serializable);
                    continue;
                }
                if (n4 >= 0) continue;
                n4 = n2;
            }
            n2 = n5;
            if (n5 > 0 || n6 > 0) {
                if (n2 + n6 == n3) {
                    creatorCollector.addPropertyCreator(annotatedWithParams, false, settableBeanPropertyArray);
                    continue;
                }
                if (n5 == 0 && n6 + 1 == n3) {
                    creatorCollector.addDelegatingCreator(annotatedWithParams, false, settableBeanPropertyArray, 0);
                    continue;
                }
                serializable = creatorCandidate.findImplicitParamName(n4);
                if (serializable == null || ((PropertyName)serializable).isEmpty()) {
                    deserializationContext.reportBadTypeDefinition(beanDescription, "Argument #%d of constructor %s has no property name annotation; must have name when multiple-parameter constructor annotated as Creator", n4, annotatedWithParams);
                }
            }
            if (creatorCollector.hasDefaultCreator()) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<AnnotatedWithParams>();
            }
            linkedList.add(annotatedWithParams);
        }
        if (linkedList != null && !creatorCollector.hasDelegatingCreator() && !creatorCollector.hasPropertyBasedCreator()) {
            this._checkImplicitlyNamedConstructors(deserializationContext, beanDescription, (VisibilityChecker<?>)object, annotationIntrospector, creatorCollector, (List<AnnotatedWithParams>)linkedList);
        }
    }

    protected void _addExplicitFactoryCreators(DeserializationContext deserializationContext, BasicDeserializerFactory$CreatorCollectionState basicDeserializerFactory$CreatorCollectionState, boolean bl) {
        BeanDescription beanDescription = basicDeserializerFactory$CreatorCollectionState.beanDesc;
        CreatorCollector creatorCollector = basicDeserializerFactory$CreatorCollectionState.creators;
        AnnotationIntrospector annotationIntrospector = basicDeserializerFactory$CreatorCollectionState.annotationIntrospector();
        VisibilityChecker<?> visibilityChecker = basicDeserializerFactory$CreatorCollectionState.vchecker;
        Map<AnnotatedWithParams, BeanPropertyDefinition[]> map = basicDeserializerFactory$CreatorCollectionState.creatorParams;
        for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
            JsonCreator$Mode jsonCreator$Mode = annotationIntrospector.findCreatorAnnotation(deserializationContext.getConfig(), annotatedMethod);
            int n2 = ((AnnotatedWithParams)annotatedMethod).getParameterCount();
            if (jsonCreator$Mode == null) {
                if (!bl || n2 != 1 || !visibilityChecker.isCreatorVisible(annotatedMethod)) continue;
                basicDeserializerFactory$CreatorCollectionState.addImplicitFactoryCandidate(CreatorCandidate.construct(annotationIntrospector, annotatedMethod, null));
                continue;
            }
            if (jsonCreator$Mode == JsonCreator$Mode.DISABLED) continue;
            if (n2 == 0) {
                creatorCollector.setDefaultCreator(annotatedMethod);
                continue;
            }
            switch (jsonCreator$Mode) {
                case DELEGATING: {
                    this._addExplicitDelegatingCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedMethod, null));
                    break;
                }
                case PROPERTIES: {
                    this._addExplicitPropertyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedMethod, map.get(annotatedMethod)));
                    break;
                }
                default: {
                    this._addExplicitAnyCreator(deserializationContext, beanDescription, creatorCollector, CreatorCandidate.construct(annotationIntrospector, annotatedMethod, map.get(annotatedMethod)), ConstructorDetector.DEFAULT);
                }
            }
            basicDeserializerFactory$CreatorCollectionState.increaseExplicitFactoryCount();
        }
    }

    protected void _addImplicitFactoryCreators(DeserializationContext deserializationContext, BasicDeserializerFactory$CreatorCollectionState object, List<CreatorCandidate> object2) {
        BeanDescription beanDescription = ((BasicDeserializerFactory$CreatorCollectionState)object).beanDesc;
        CreatorCollector creatorCollector = ((BasicDeserializerFactory$CreatorCollectionState)object).creators;
        AnnotationIntrospector annotationIntrospector = ((BasicDeserializerFactory$CreatorCollectionState)object).annotationIntrospector();
        VisibilityChecker<?> visibilityChecker = ((BasicDeserializerFactory$CreatorCollectionState)object).vchecker;
        object = ((BasicDeserializerFactory$CreatorCollectionState)object).creatorParams;
        object2 = object2.iterator();
        while (object2.hasNext()) {
            int n2;
            Object object3 = (CreatorCandidate)object2.next();
            int n3 = ((CreatorCandidate)object3).paramCount();
            AnnotatedWithParams annotatedWithParams = ((CreatorCandidate)object3).creator();
            BeanPropertyDefinition[] beanPropertyDefinitionArray = (BeanPropertyDefinition[])object.get(annotatedWithParams);
            if (n3 != 1) continue;
            boolean bl = this._checkIfCreatorPropertyBased(annotationIntrospector, annotatedWithParams, (BeanPropertyDefinition)(object3 = ((CreatorCandidate)object3).propertyDef(0)));
            if (!bl) {
                this._handleSingleArgumentCreator(creatorCollector, annotatedWithParams, false, visibilityChecker.isCreatorVisible(annotatedWithParams));
                if (object3 == null) continue;
                ((POJOPropertyBuilder)object3).removeConstructors();
                continue;
            }
            object3 = null;
            SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n3];
            int n4 = 0;
            int n5 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                PropertyName propertyName;
                AnnotatedParameter annotatedParameter = annotatedWithParams.getParameter(n2);
                Object object4 = beanPropertyDefinitionArray == null ? null : beanPropertyDefinitionArray[n2];
                JacksonInject$Value jacksonInject$Value = annotationIntrospector.findInjectableValue(annotatedParameter);
                PropertyName propertyName2 = propertyName = object4 == null ? null : ((BeanPropertyDefinition)object4).getFullName();
                if (object4 != null && ((BeanPropertyDefinition)object4).isExplicitlyNamed()) {
                    ++n4;
                    settableBeanPropertyArray[n2] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n2, annotatedParameter, jacksonInject$Value);
                    continue;
                }
                if (jacksonInject$Value != null) {
                    ++n5;
                    settableBeanPropertyArray[n2] = this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, n2, annotatedParameter, jacksonInject$Value);
                    continue;
                }
                object4 = annotationIntrospector.findUnwrappingNameTransformer(annotatedParameter);
                if (object4 != null) {
                    this._reportUnwrappedCreatorProperty(deserializationContext, beanDescription, annotatedParameter);
                    continue;
                }
                if (object3 != null) continue;
                object3 = annotatedParameter;
            }
            n2 = n4;
            if (n4 <= 0 && n5 <= 0) continue;
            if (n2 + n5 == n3) {
                creatorCollector.addPropertyCreator(annotatedWithParams, false, settableBeanPropertyArray);
                continue;
            }
            if (n4 == 0 && n5 + 1 == n3) {
                creatorCollector.addDelegatingCreator(annotatedWithParams, false, settableBeanPropertyArray, 0);
                continue;
            }
            deserializationContext.reportBadTypeDefinition(beanDescription, "Argument #%d of factory method %s has no property name annotation; must have name when multiple-parameter constructor annotated as Creator", object3 == null ? -1 : ((AnnotatedParameter)object3).getIndex(), annotatedWithParams);
        }
    }

    protected void _addExplicitDelegatingCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate) {
        int n2 = -1;
        int n3 = creatorCandidate.paramCount();
        SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            AnnotatedParameter annotatedParameter = creatorCandidate.parameter(i2);
            JacksonInject$Value jacksonInject$Value = creatorCandidate.injection(i2);
            if (jacksonInject$Value != null) {
                settableBeanPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, beanDescription, null, i2, annotatedParameter, jacksonInject$Value);
                continue;
            }
            if (n2 < 0) {
                n2 = i2;
                continue;
            }
            deserializationContext.reportBadTypeDefinition(beanDescription, "More than one argument (#%d and #%d) left as delegating for Creator %s: only one allowed", n2, i2, creatorCandidate);
        }
        if (n2 < 0) {
            deserializationContext.reportBadTypeDefinition(beanDescription, "No argument left as delegating for Creator %s: exactly one required", creatorCandidate);
        }
        if (n3 == 1) {
            this._handleSingleArgumentCreator(creatorCollector, creatorCandidate.creator(), true, true);
            BeanPropertyDefinition beanPropertyDefinition = creatorCandidate.propertyDef(0);
            if (beanPropertyDefinition != null) {
                ((POJOPropertyBuilder)beanPropertyDefinition).removeConstructors();
            }
            return;
        }
        creatorCollector.addDelegatingCreator(creatorCandidate.creator(), true, settableBeanPropertyArray, n2);
    }

    protected void _addExplicitPropertyCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate) {
        int n2 = creatorCandidate.paramCount();
        SettableBeanProperty[] settableBeanPropertyArray = new SettableBeanProperty[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            JacksonInject$Value jacksonInject$Value = creatorCandidate.injection(i2);
            AnnotatedParameter annotatedParameter = creatorCandidate.parameter(i2);
            Object object = creatorCandidate.paramName(i2);
            if (object == null) {
                object = ((DatabindContext)deserializationContext).getAnnotationIntrospector().findUnwrappingNameTransformer(annotatedParameter);
                if (object != null) {
                    this._reportUnwrappedCreatorProperty(deserializationContext, beanDescription, annotatedParameter);
                }
                object = creatorCandidate.findImplicitParamName(i2);
                this._validateNamedPropertyParameter(deserializationContext, beanDescription, creatorCandidate, i2, (PropertyName)object, jacksonInject$Value);
            }
            settableBeanPropertyArray[i2] = this.constructCreatorProperty(deserializationContext, beanDescription, (PropertyName)object, i2, annotatedParameter, jacksonInject$Value);
        }
        creatorCollector.addPropertyCreator(creatorCandidate.creator(), true, settableBeanPropertyArray);
    }

    @Deprecated
    protected void _addExplicitAnyCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate) {
        this._addExplicitAnyCreator(deserializationContext, beanDescription, creatorCollector, creatorCandidate, deserializationContext.getConfig().getConstructorDetector());
    }

    protected void _addExplicitAnyCreator(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCollector creatorCollector, CreatorCandidate creatorCandidate, ConstructorDetector constructorDetector) {
        SettableBeanProperty[] settableBeanPropertyArray;
        boolean bl;
        if (1 != creatorCandidate.paramCount()) {
            int n2;
            if (!constructorDetector.singleArgCreatorDefaultsToProperties() && (n2 = creatorCandidate.findOnlyParamWithoutInjection()) >= 0 && (constructorDetector.singleArgCreatorDefaultsToDelegating() || creatorCandidate.paramName(n2) == null)) {
                this._addExplicitDelegatingCreator(deserializationContext, beanDescription, creatorCollector, creatorCandidate);
                return;
            }
            this._addExplicitPropertyCreator(deserializationContext, beanDescription, creatorCollector, creatorCandidate);
            return;
        }
        AnnotatedParameter annotatedParameter = creatorCandidate.parameter(0);
        JacksonInject$Value jacksonInject$Value = creatorCandidate.injection(0);
        PropertyName propertyName = null;
        switch (constructorDetector.singleArgMode()) {
            case DELEGATING: {
                boolean bl2 = false;
                break;
            }
            case PROPERTIES: {
                bl = true;
                propertyName = creatorCandidate.paramName(0);
                if (propertyName != null) break;
                this._validateNamedPropertyParameter(deserializationContext, beanDescription, creatorCandidate, 0, propertyName, jacksonInject$Value);
                break;
            }
            case REQUIRE_MODE: {
                deserializationContext.reportBadTypeDefinition(beanDescription, "Single-argument constructor (%s) is annotated but no 'mode' defined; `CreatorDetector`configured with `SingleArgConstructor.REQUIRE_MODE`", creatorCandidate.creator());
                return;
            }
            default: {
                settableBeanPropertyArray = creatorCandidate.propertyDef(0);
                propertyName = creatorCandidate.explicitParamName(0);
                bl = propertyName != null || jacksonInject$Value != null;
                if (bl || settableBeanPropertyArray == null) break;
                propertyName = creatorCandidate.paramName(0);
                boolean bl2 = bl = propertyName != null && settableBeanPropertyArray.couldSerialize();
            }
        }
        if (bl) {
            settableBeanPropertyArray = new SettableBeanProperty[]{this.constructCreatorProperty(deserializationContext, beanDescription, propertyName, 0, annotatedParameter, jacksonInject$Value)};
            creatorCollector.addPropertyCreator(creatorCandidate.creator(), true, settableBeanPropertyArray);
            return;
        }
        this._handleSingleArgumentCreator(creatorCollector, creatorCandidate.creator(), true, true);
        settableBeanPropertyArray = creatorCandidate.propertyDef(0);
        if (settableBeanPropertyArray != null) {
            ((POJOPropertyBuilder)settableBeanPropertyArray).removeConstructors();
        }
    }

    private boolean _checkIfCreatorPropertyBased(AnnotationIntrospector object, AnnotatedWithParams annotatedWithParams, BeanPropertyDefinition beanPropertyDefinition) {
        if (beanPropertyDefinition != null && beanPropertyDefinition.isExplicitlyNamed() || ((AnnotationIntrospector)object).findInjectableValue(annotatedWithParams.getParameter(0)) != null) {
            return true;
        }
        return beanPropertyDefinition != null && (object = beanPropertyDefinition.getName()) != null && !((String)object).isEmpty() && beanPropertyDefinition.couldSerialize();
    }

    private void _checkImplicitlyNamedConstructors(DeserializationContext deserializationContext, BeanDescription beanDescription, VisibilityChecker<?> visibilityChecker, AnnotationIntrospector annotationIntrospector, CreatorCollector creatorCollector, List<AnnotatedWithParams> object) {
        Object object2;
        Serializable serializable;
        int n2;
        AnnotatedWithParams annotatedWithParams;
        AnnotatedWithParams annotatedWithParams2 = null;
        SettableBeanProperty[] settableBeanPropertyArray = null;
        object = object.iterator();
        block0: while (object.hasNext()) {
            annotatedWithParams = (AnnotatedWithParams)object.next();
            if (!visibilityChecker.isCreatorVisible(annotatedWithParams)) continue;
            n2 = annotatedWithParams.getParameterCount();
            SettableBeanProperty[] settableBeanPropertyArray2 = new SettableBeanProperty[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                serializable = annotatedWithParams.getParameter(i2);
                object2 = this._findParamName((AnnotatedParameter)serializable, annotationIntrospector);
                if (object2 == null || ((PropertyName)object2).isEmpty()) continue block0;
                settableBeanPropertyArray2[i2] = this.constructCreatorProperty(deserializationContext, beanDescription, (PropertyName)object2, ((AnnotatedParameter)serializable).getIndex(), (AnnotatedParameter)serializable, null);
            }
            if (annotatedWithParams2 != null) {
                annotatedWithParams2 = null;
                break;
            }
            annotatedWithParams2 = annotatedWithParams;
            settableBeanPropertyArray = settableBeanPropertyArray2;
        }
        if (annotatedWithParams2 != null) {
            creatorCollector.addPropertyCreator(annotatedWithParams2, false, settableBeanPropertyArray);
            object = (BasicBeanDescription)beanDescription;
            annotatedWithParams = settableBeanPropertyArray;
            n2 = settableBeanPropertyArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                AnnotatedWithParams annotatedWithParams3 = annotatedWithParams[i3];
                serializable = ((SettableBeanProperty)((Object)annotatedWithParams3)).getFullName();
                if (((BasicBeanDescription)object).hasProperty((PropertyName)serializable)) continue;
                object2 = SimpleBeanPropertyDefinition.construct(deserializationContext.getConfig(), ((SettableBeanProperty)((Object)annotatedWithParams3)).getMember(), (PropertyName)serializable);
                ((BasicBeanDescription)object).addProperty((BeanPropertyDefinition)object2);
            }
        }
    }

    protected boolean _handleSingleArgumentCreator(CreatorCollector creatorCollector, AnnotatedWithParams annotatedWithParams, boolean bl, boolean bl2) {
        Class<?> clazz = annotatedWithParams.getRawParameterType(0);
        if (clazz == String.class || clazz == CLASS_CHAR_SEQUENCE) {
            if (bl || bl2) {
                creatorCollector.addStringCreator(annotatedWithParams, bl);
            }
            return true;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            if (bl || bl2) {
                creatorCollector.addIntCreator(annotatedWithParams, bl);
            }
            return true;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            if (bl || bl2) {
                creatorCollector.addLongCreator(annotatedWithParams, bl);
            }
            return true;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            if (bl || bl2) {
                creatorCollector.addDoubleCreator(annotatedWithParams, bl);
            }
            return true;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            if (bl || bl2) {
                creatorCollector.addBooleanCreator(annotatedWithParams, bl);
            }
            return true;
        }
        if (clazz == BigInteger.class && (bl || bl2)) {
            creatorCollector.addBigIntegerCreator(annotatedWithParams, bl);
        }
        if (clazz == BigDecimal.class && (bl || bl2)) {
            creatorCollector.addBigDecimalCreator(annotatedWithParams, bl);
        }
        if (bl) {
            creatorCollector.addDelegatingCreator(annotatedWithParams, bl, null, 0);
            return true;
        }
        return false;
    }

    protected void _validateNamedPropertyParameter(DeserializationContext deserializationContext, BeanDescription beanDescription, CreatorCandidate creatorCandidate, int n2, PropertyName propertyName, JacksonInject$Value jacksonInject$Value) {
        if (propertyName == null && jacksonInject$Value == null) {
            deserializationContext.reportBadTypeDefinition(beanDescription, "Argument #%d of constructor %s has no property name (and is not Injectable): can not use as property-based Creator", n2, creatorCandidate);
        }
    }

    protected void _reportUnwrappedCreatorProperty(DeserializationContext deserializationContext, BeanDescription beanDescription, AnnotatedParameter annotatedParameter) {
        deserializationContext.reportBadTypeDefinition(beanDescription, "Cannot define Creator parameter %d as `@JsonUnwrapped`: combination not yet supported", annotatedParameter.getIndex());
    }

    protected SettableBeanProperty constructCreatorProperty(DeserializationContext deserializationContext, BeanDescription jsonDeserializer, PropertyName propertyName, int n2, AnnotatedParameter annotatedParameter, JacksonInject$Value jacksonInject$Value) {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        Serializable serializable2 = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (serializable2 == null) {
            object3 = PropertyMetadata.STD_REQUIRED_OR_OPTIONAL;
            serializable2 = null;
        } else {
            serializable = serializable2.hasRequiredMarker(annotatedParameter);
            object2 = serializable2.findPropertyDescription(annotatedParameter);
            object = serializable2.findPropertyIndex(annotatedParameter);
            object3 = serializable2.findPropertyDefaultValue(annotatedParameter);
            object3 = PropertyMetadata.construct((Boolean)serializable, (String)object2, (Integer)object, (String)object3);
            serializable2 = serializable2.findWrapperName(annotatedParameter);
        }
        AnnotatedParameter annotatedParameter2 = annotatedParameter;
        serializable = this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedParameter2, ((Annotated)annotatedParameter2).getType());
        object2 = new BeanProperty$Std(propertyName, (JavaType)serializable, (PropertyName)serializable2, annotatedParameter, (PropertyMetadata)object3);
        object = (TypeDeserializer)((JavaType)serializable).getTypeHandler();
        if (object == null) {
            object = ((DeserializerFactory)this).findTypeDeserializer(deserializationConfig, (JavaType)serializable);
        }
        object3 = this._getSetterInfo(deserializationContext, (BeanProperty)object2, (PropertyMetadata)object3);
        object3 = CreatorProperty.construct(propertyName, (JavaType)serializable, ((BeanProperty$Std)object2).getWrapperName(), (TypeDeserializer)object, ((BeanDescription)((Object)jsonDeserializer)).getClassAnnotations(), annotatedParameter, n2, jacksonInject$Value, (PropertyMetadata)object3);
        jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, annotatedParameter);
        if (jsonDeserializer == null) {
            jsonDeserializer = (JsonDeserializer)((JavaType)serializable).getValueHandler();
        }
        if (jsonDeserializer != null) {
            jsonDeserializer = deserializationContext.handlePrimaryContextualization(jsonDeserializer, (BeanProperty)object3, (JavaType)serializable);
            object3 = ((SettableBeanProperty)object3).withValueDeserializer(jsonDeserializer);
        }
        return object3;
    }

    private PropertyName _findParamName(AnnotatedParameter object, AnnotationIntrospector annotationIntrospector) {
        if (annotationIntrospector != null) {
            PropertyName propertyName = annotationIntrospector.findNameForDeserialization((Annotated)object);
            if (propertyName != null && !propertyName.isEmpty()) {
                return propertyName;
            }
            if ((object = annotationIntrospector.findImplicitPropertyName((AnnotatedMember)object)) != null && !((String)object).isEmpty()) {
                return PropertyName.construct((String)object);
            }
        }
        return null;
    }

    protected PropertyMetadata _getSetterInfo(DeserializationContext serializable, BeanProperty object, PropertyMetadata propertyMetadata) {
        Object object2 = ((DatabindContext)((Object)serializable)).getAnnotationIntrospector();
        serializable = ((DeserializationContext)serializable).getConfig();
        Nulls nulls = null;
        Nulls nulls2 = null;
        AnnotatedMember annotatedMember = object.getMember();
        if (annotatedMember != null) {
            if (object2 != null && (object2 = ((AnnotationIntrospector)object2).findSetterInfo(annotatedMember)) != null) {
                nulls = ((JsonSetter$Value)object2).nonDefaultValueNulls();
                nulls2 = ((JsonSetter$Value)object2).nonDefaultContentNulls();
            }
            if ((object = ((ConfigOverride)(object2 = ((MapperConfig)serializable).getConfigOverride(((ResolvedType)object.getType()).getRawClass()))).getSetterInfo()) != null) {
                if (nulls == null) {
                    nulls = ((JsonSetter$Value)object).nonDefaultValueNulls();
                }
                if (nulls2 == null) {
                    nulls2 = ((JsonSetter$Value)object).nonDefaultContentNulls();
                }
            }
        }
        object2 = ((MapperConfig)serializable).getDefaultSetterInfo();
        if (nulls == null) {
            nulls = ((JsonSetter$Value)object2).nonDefaultValueNulls();
        }
        if (nulls2 == null) {
            nulls2 = ((JsonSetter$Value)object2).nonDefaultContentNulls();
        }
        if (nulls != null || nulls2 != null) {
            propertyMetadata = propertyMetadata.withNulls(nulls, nulls2);
        }
        return propertyMetadata;
    }

    @Override
    public JsonDeserializer<?> createArrayDeserializer(DeserializationContext serializable, ArrayType arrayType, BeanDescription beanDescription) {
        JsonDeserializer jsonDeserializer;
        serializable = ((DeserializationContext)serializable).getConfig();
        JavaType object2 = ((JavaType)arrayType).getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)object2.getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)object2.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((DeserializerFactory)this).findTypeDeserializer((DeserializationConfig)serializable, object2);
        }
        if ((jsonDeserializer = this._findCustomArrayDeserializer(arrayType, (DeserializationConfig)serializable, beanDescription, typeDeserializer, jsonDeserializer2)) == null) {
            if (jsonDeserializer2 == null) {
                Class<?> clazz = ((ResolvedType)object2).getRawClass();
                if (((ResolvedType)object2).isPrimitive()) {
                    return PrimitiveArrayDeserializers.forType(clazz);
                }
                if (clazz == String.class) {
                    return StringArrayDeserializer.instance;
                }
            }
            jsonDeserializer = new ObjectArrayDeserializer((JavaType)arrayType, jsonDeserializer2, typeDeserializer);
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyArrayDeserializer((DeserializationConfig)serializable, arrayType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createCollectionDeserializer(DeserializationContext object4, CollectionType object2, BeanDescription beanDescription) {
        Object object;
        BeanDescription beanDescription2;
        JsonDeserializer jsonDeserializer;
        Object object3;
        JavaType javaType = ((JavaType)object3).getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)javaType.getValueHandler();
        DeserializationConfig deserializationConfig = ((DeserializationContext)object4).getConfig();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((DeserializerFactory)this).findTypeDeserializer(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = this._findCustomCollectionDeserializer((CollectionType)object3, deserializationConfig, beanDescription2, typeDeserializer, jsonDeserializer2)) == null) {
            object = ((ResolvedType)object3).getRawClass();
            if (jsonDeserializer2 == null && EnumSet.class.isAssignableFrom((Class<?>)object)) {
                jsonDeserializer = new EnumSetDeserializer(javaType, null);
            }
        }
        if (jsonDeserializer == null) {
            if (((ResolvedType)object3).isInterface() || ((ResolvedType)object3).isAbstract()) {
                object = this._mapAbstractCollectionType((JavaType)object3, deserializationConfig);
                if (object == null) {
                    if (((JavaType)object3).getTypeHandler() == null) {
                        throw new IllegalArgumentException("Cannot find a deserializer for non-concrete Collection type " + object3);
                    }
                    jsonDeserializer = AbstractDeserializer.constructForNonPOJO(beanDescription2);
                } else {
                    object3 = object;
                    beanDescription2 = deserializationConfig.introspectForCreation((JavaType)object3);
                }
            }
            if (jsonDeserializer == null) {
                object = ((DeserializerFactory)this).findValueInstantiator((DeserializationContext)object4, beanDescription2);
                if (!((ValueInstantiator)object).canCreateUsingDefault()) {
                    if (((ResolvedType)object3).hasRawClass(ArrayBlockingQueue.class)) {
                        return new ArrayBlockingQueueDeserializer((JavaType)object3, jsonDeserializer2, typeDeserializer, (ValueInstantiator)object);
                    }
                    jsonDeserializer = JavaUtilCollectionsDeserializers.findForCollection((DeserializationContext)object4, (JavaType)object3);
                    if (jsonDeserializer != null) {
                        return jsonDeserializer;
                    }
                }
                jsonDeserializer = ((ResolvedType)javaType).hasRawClass(String.class) ? new StringCollectionDeserializer((JavaType)object3, jsonDeserializer2, (ValueInstantiator)object) : new CollectionDeserializer((JavaType)object3, jsonDeserializer2, typeDeserializer, (ValueInstantiator)object);
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyCollectionDeserializer(deserializationConfig, (CollectionType)object3, beanDescription2, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    protected CollectionType _mapAbstractCollectionType(JavaType javaType, DeserializationConfig deserializationConfig) {
        Class<?> clazz = BasicDeserializerFactory$ContainerDefaultMappings.findCollectionFallback(javaType);
        if (clazz != null) {
            return (CollectionType)deserializationConfig.getTypeFactory().constructSpecializedType(javaType, clazz, true);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JsonDeserializer<?> createCollectionLikeDeserializer(DeserializationContext serializable, CollectionLikeType collectionLikeType, BeanDescription beanDescription) {
        void var6_8;
        JsonDeserializer<?> jsonDeserializer = ((JavaType)collectionLikeType).getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)((JavaType)((Object)jsonDeserializer)).getValueHandler();
        serializable = ((DeserializationContext)serializable).getConfig();
        TypeDeserializer object2 = (TypeDeserializer)((JavaType)((Object)jsonDeserializer)).getTypeHandler();
        if (object2 == null) {
            TypeDeserializer typeDeserializer = ((DeserializerFactory)this).findTypeDeserializer((DeserializationConfig)serializable, (JavaType)((Object)jsonDeserializer));
        }
        if ((jsonDeserializer = this._findCustomCollectionLikeDeserializer(collectionLikeType, (DeserializationConfig)serializable, beanDescription, (TypeDeserializer)var6_8, jsonDeserializer2)) != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyCollectionLikeDeserializer((DeserializationConfig)serializable, collectionLikeType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JsonDeserializer<?> createMapDeserializer(DeserializationContext serializable, MapType object, BeanDescription beanDescription) {
        DeserializationConfig deserializationConfig = ((DeserializationContext)serializable).getConfig();
        Object object2 = ((JavaType)object).getKeyType();
        Serializable serializable2 = ((JavaType)object).getContentType();
        JsonDeserializer jsonDeserializer = (JsonDeserializer)((JavaType)serializable2).getValueHandler();
        KeyDeserializer keyDeserializer = (KeyDeserializer)((JavaType)object2).getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)((JavaType)serializable2).getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((DeserializerFactory)this).findTypeDeserializer(deserializationConfig, (JavaType)serializable2);
        }
        if ((serializable2 = this._findCustomMapDeserializer((MapType)object, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer)) == null) {
            Class<?> clazz = ((ResolvedType)object).getRawClass();
            if (EnumMap.class.isAssignableFrom(clazz)) {
                void var11_13;
                if (clazz == EnumMap.class) {
                    Object object3 = null;
                } else {
                    ValueInstantiator valueInstantiator = ((DeserializerFactory)this).findValueInstantiator((DeserializationContext)serializable, beanDescription);
                }
                if (!((JavaType)object2).isEnumImplType()) {
                    throw new IllegalArgumentException("Cannot construct EnumMap; generic (key) type not available");
                }
                serializable2 = new EnumMapDeserializer((JavaType)object, (ValueInstantiator)var11_13, null, jsonDeserializer, typeDeserializer, null);
            }
            if (serializable2 == null) {
                if (((ResolvedType)object).isInterface() || ((ResolvedType)object).isAbstract()) {
                    MapType mapType = this._mapAbstractMapType((JavaType)object, deserializationConfig);
                    if (mapType != null) {
                        object = mapType;
                        ((ResolvedType)object).getRawClass();
                        beanDescription = deserializationConfig.introspectForCreation((JavaType)object);
                    } else {
                        if (((JavaType)object).getTypeHandler() == null) {
                            throw new IllegalArgumentException("Cannot find a deserializer for non-concrete Map type " + object);
                        }
                        serializable2 = AbstractDeserializer.constructForNonPOJO(beanDescription);
                    }
                } else {
                    serializable2 = JavaUtilCollectionsDeserializers.findForMap((DeserializationContext)serializable, (JavaType)object);
                    if (serializable2 != null) {
                        return serializable2;
                    }
                }
                if (serializable2 == null) {
                    ValueInstantiator valueInstantiator = ((DeserializerFactory)this).findValueInstantiator((DeserializationContext)serializable, beanDescription);
                    serializable = new MapDeserializer((JavaType)object, valueInstantiator, keyDeserializer, jsonDeserializer, typeDeserializer);
                    object2 = ((MapperConfig)deserializationConfig).getDefaultPropertyIgnorals(Map.class, beanDescription.getClassInfo());
                    object2 = object2 == null ? null : ((JsonIgnoreProperties$Value)object2).findIgnoredForDeserialization();
                    ((MapDeserializer)serializable).setIgnorableProperties((Set<String>)object2);
                    object2 = ((MapperConfig)deserializationConfig).getDefaultPropertyInclusions(Map.class, beanDescription.getClassInfo());
                    object2 = object2 == null ? null : ((JsonIncludeProperties$Value)object2).getIncluded();
                    ((MapDeserializer)serializable).setIncludableProperties((Set<String>)object2);
                    serializable2 = serializable;
                }
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                serializable2 = beanDeserializerModifier.modifyMapDeserializer(deserializationConfig, (MapType)object, beanDescription, (JsonDeserializer<?>)((Object)serializable2));
            }
        }
        return serializable2;
    }

    protected MapType _mapAbstractMapType(JavaType javaType, DeserializationConfig deserializationConfig) {
        Class<?> clazz = BasicDeserializerFactory$ContainerDefaultMappings.findMapFallback(javaType);
        if (clazz != null) {
            return (MapType)deserializationConfig.getTypeFactory().constructSpecializedType(javaType, clazz, true);
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createMapLikeDeserializer(DeserializationContext serializable, MapLikeType mapLikeType, BeanDescription beanDescription) {
        JsonDeserializer<?> jsonDeserializer = ((JavaType)mapLikeType).getKeyType();
        JavaType javaType = ((JavaType)mapLikeType).getContentType();
        serializable = ((DeserializationContext)serializable).getConfig();
        JsonDeserializer object2 = (JsonDeserializer)javaType.getValueHandler();
        jsonDeserializer = (KeyDeserializer)((JavaType)((Object)jsonDeserializer)).getValueHandler();
        TypeDeserializer typeDeserializer = (TypeDeserializer)javaType.getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((DeserializerFactory)this).findTypeDeserializer((DeserializationConfig)serializable, javaType);
        }
        if ((jsonDeserializer = this._findCustomMapLikeDeserializer(mapLikeType, (DeserializationConfig)serializable, beanDescription, (KeyDeserializer)((Object)jsonDeserializer), typeDeserializer, object2)) != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyMapLikeDeserializer((DeserializationConfig)serializable, mapLikeType, beanDescription, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createEnumDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        Class<?> clazz = ((ResolvedType)javaType).getRawClass();
        Object object = this._findCustomEnumDeserializer(clazz, deserializationConfig, beanDescription);
        if (object == null) {
            if (clazz == Enum.class) {
                return AbstractDeserializer.constructForNonPOJO(beanDescription);
            }
            ValueInstantiator valueInstantiator = this._constructDefaultValueInstantiator(deserializationContext, beanDescription);
            SettableBeanProperty[] settableBeanPropertyArray = valueInstantiator == null ? null : valueInstantiator.getFromObjectArguments(deserializationContext.getConfig());
            for (AnnotatedMethod annotatedMethod : beanDescription.getFactoryMethods()) {
                if (!this._hasCreatorAnnotation(deserializationContext, annotatedMethod)) continue;
                if (((AnnotatedWithParams)annotatedMethod).getParameterCount() == 0) {
                    object = EnumDeserializer.deserializerForNoArgsCreator(deserializationConfig, clazz, annotatedMethod);
                    break;
                }
                object = annotatedMethod.getRawReturnType();
                if (!((Class)object).isAssignableFrom(clazz)) {
                    ((DatabindContext)deserializationContext).reportBadDefinition(javaType, String.format("Invalid `@JsonCreator` annotated Enum factory method [%s]: needs to return compatible type", ((Annotated)annotatedMethod).toString()));
                }
                object = EnumDeserializer.deserializerForCreator(deserializationConfig, clazz, annotatedMethod, valueInstantiator, settableBeanPropertyArray);
                break;
            }
            if (object == null) {
                object = new EnumDeserializer(this.constructEnumResolver(clazz, deserializationConfig, beanDescription.findJsonValueAccessor()), (Boolean)deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS));
            }
        }
        if (this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                object = beanDeserializerModifier.modifyEnumDeserializer(deserializationConfig, javaType, beanDescription, (JsonDeserializer<?>)object);
            }
        }
        return object;
    }

    @Override
    public JsonDeserializer<?> createTreeDeserializer(DeserializationConfig jsonDeserializer, JavaType type, BeanDescription beanDescription) {
        jsonDeserializer = this._findCustomTreeNodeDeserializer((Class<? extends JsonNode>)(type = ((ResolvedType)((Object)type)).getRawClass()), (DeserializationConfig)((Object)jsonDeserializer), beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        return JsonNodeDeserializer.getDeserializer(type);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JsonDeserializer<?> createReferenceDeserializer(DeserializationContext object2, ReferenceType referenceType, BeanDescription beanDescription) {
        void var3_8;
        void var2_7;
        JsonDeserializer<?> jsonDeserializer = var2_7.getContentType();
        JsonDeserializer jsonDeserializer2 = (JsonDeserializer)((JavaType)((Object)jsonDeserializer)).getValueHandler();
        DeserializationConfig deserializationConfig = ((DeserializationContext)object2).getConfig();
        TypeDeserializer typeDeserializer = (TypeDeserializer)((JavaType)((Object)jsonDeserializer)).getTypeHandler();
        if (typeDeserializer == null) {
            typeDeserializer = ((DeserializerFactory)this).findTypeDeserializer(deserializationConfig, (JavaType)((Object)jsonDeserializer));
        }
        if ((jsonDeserializer = this._findCustomReferenceDeserializer((ReferenceType)var2_7, deserializationConfig, (BeanDescription)var3_8, typeDeserializer, jsonDeserializer2)) == null && var2_7.isTypeOrSubTypeOf(AtomicReference.class)) {
            void var1_4;
            Class<?> clazz = var2_7.getRawClass();
            if (clazz == AtomicReference.class) {
                Object var1_2 = null;
            } else {
                ValueInstantiator valueInstantiator = ((DeserializerFactory)this).findValueInstantiator((DeserializationContext)object2, (BeanDescription)var3_8);
            }
            return new AtomicReferenceDeserializer((JavaType)var2_7, (ValueInstantiator)var1_4, typeDeserializer, jsonDeserializer2);
        }
        if (jsonDeserializer != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                jsonDeserializer = beanDeserializerModifier.modifyReferenceDeserializer(deserializationConfig, (ReferenceType)var2_7, (BeanDescription)var3_8, jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    @Override
    public TypeDeserializer findTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType) {
        Object object = deserializationConfig.introspectClassAnnotations(((ResolvedType)javaType).getRawClass());
        object = ((BeanDescription)object).getClassInfo();
        TypeResolverBuilder<?> typeResolverBuilder = deserializationConfig.getAnnotationIntrospector();
        typeResolverBuilder = ((AnnotationIntrospector)((Object)typeResolverBuilder)).findTypeResolver(deserializationConfig, (AnnotatedClass)object, javaType);
        Collection<NamedType> collection = null;
        if (typeResolverBuilder == null) {
            typeResolverBuilder = deserializationConfig.getDefaultTyper(javaType);
            if (typeResolverBuilder == null) {
                return null;
            }
        } else {
            collection = ((MapperConfig)deserializationConfig).getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, (AnnotatedClass)object);
        }
        if (typeResolverBuilder.getDefaultImpl() == null && ((ResolvedType)javaType).isAbstract() && (object = ((DeserializerFactory)this).mapAbstractType(deserializationConfig, javaType)) != null && !((ResolvedType)object).hasRawClass(((ResolvedType)javaType).getRawClass())) {
            typeResolverBuilder = typeResolverBuilder.withDefaultImpl(((ResolvedType)object).getRawClass());
        }
        try {
            return typeResolverBuilder.buildTypeDeserializer(deserializationConfig, javaType, collection);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            throw InvalidDefinitionException.from(null, ClassUtil.exceptionMessage(runtimeException), javaType).withCause(runtimeException);
        }
    }

    protected JsonDeserializer<?> findOptionalStdDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanDescription beanDescription) {
        return OptionalHandlerFactory.instance.findDeserializer(javaType, deserializationContext.getConfig(), beanDescription);
    }

    @Override
    public KeyDeserializer createKeyDeserializer(DeserializationContext deserializationContext, JavaType javaType) {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        BeanDescription beanDescription = null;
        KeyDeserializer keyDeserializer = null;
        if (this._factoryConfig.hasKeyDeserializers()) {
            KeyDeserializers object;
            beanDescription = deserializationConfig.introspectClassAnnotations(javaType);
            Iterator<Object> iterator = this._factoryConfig.keyDeserializers().iterator();
            while (iterator.hasNext() && (keyDeserializer = (object = iterator.next()).findKeyDeserializer(javaType, deserializationConfig, beanDescription)) == null) {
            }
        }
        if (keyDeserializer == null) {
            if (beanDescription == null) {
                beanDescription = deserializationConfig.introspectClassAnnotations(((ResolvedType)javaType).getRawClass());
            }
            if ((keyDeserializer = this.findKeyDeserializerFromAnnotation(deserializationContext, beanDescription.getClassInfo())) == null) {
                keyDeserializer = ((ResolvedType)javaType).isEnumType() ? this._createEnumKeyDeserializer(deserializationContext, javaType) : StdKeyDeserializers.findStringBasedKeyDeserializer(deserializationConfig, javaType);
            }
        }
        if (keyDeserializer != null && this._factoryConfig.hasDeserializerModifiers()) {
            for (BeanDeserializerModifier beanDeserializerModifier : this._factoryConfig.deserializerModifiers()) {
                keyDeserializer = beanDeserializerModifier.modifyKeyDeserializer(deserializationConfig, javaType, keyDeserializer);
            }
        }
        return keyDeserializer;
    }

    private KeyDeserializer _createEnumKeyDeserializer(DeserializationContext deserializationContext, JavaType serializable2) {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        Class<?> clazz = ((ResolvedType)((Object)serializable2)).getRawClass();
        Object object = deserializationConfig.introspect((JavaType)serializable2);
        JsonDeserializer<?> jsonDeserializer = this.findKeyDeserializerFromAnnotation(deserializationContext, ((BeanDescription)object).getClassInfo());
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        jsonDeserializer = this._findCustomEnumDeserializer(clazz, deserializationConfig, (BeanDescription)object);
        if (jsonDeserializer != null) {
            return StdKeyDeserializers.constructDelegatingKeyDeserializer(deserializationConfig, (JavaType)serializable2, jsonDeserializer);
        }
        JsonDeserializer<Object> jsonDeserializer2 = this.findDeserializerFromAnnotation(deserializationContext, ((BeanDescription)object).getClassInfo());
        if (jsonDeserializer2 != null) {
            return StdKeyDeserializers.constructDelegatingKeyDeserializer(deserializationConfig, (JavaType)serializable2, jsonDeserializer2);
        }
        jsonDeserializer = this.constructEnumResolver(clazz, deserializationConfig, ((BeanDescription)object).findJsonValueAccessor());
        for (AnnotatedMethod annotatedMethod : ((BeanDescription)object).getFactoryMethods()) {
            if (!this._hasCreatorAnnotation(deserializationContext, annotatedMethod)) continue;
            int n2 = ((AnnotatedWithParams)annotatedMethod).getParameterCount();
            if (n2 == 1 && ((Class)(object = annotatedMethod.getRawReturnType())).isAssignableFrom(clazz)) {
                if (((AnnotatedWithParams)annotatedMethod).getRawParameterType(0) != String.class) continue;
                if (deserializationConfig.canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), ((DatabindContext)deserializationContext).isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                }
                return StdKeyDeserializers.constructEnumKeyDeserializer((EnumResolver)((Object)jsonDeserializer), annotatedMethod);
            }
            throw new IllegalArgumentException("Unsuitable method (" + annotatedMethod + ") decorated with @JsonCreator (for Enum type " + clazz.getName() + ")");
        }
        return StdKeyDeserializers.constructEnumKeyDeserializer((EnumResolver)((Object)jsonDeserializer));
    }

    @Override
    public boolean hasExplicitDeserializerFor(DeserializationConfig object, Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return true;
        }
        object = clazz.getName();
        if (((String)object).startsWith("java.")) {
            if (Collection.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return NumberDeserializers.find(clazz, (String)object) != null;
            }
            if (JdkDeserializers.hasDeserializerFor(clazz) || clazz == CLASS_STRING || clazz == Boolean.class || clazz == EnumMap.class || clazz == AtomicReference.class) {
                return true;
            }
            return DateDeserializers.hasDeserializerFor(clazz);
        }
        if (((String)object).startsWith("com.fasterxml.")) {
            return JsonNode.class.isAssignableFrom(clazz) || clazz == TokenBuffer.class;
        }
        return OptionalHandlerFactory.instance.hasDeserializerFor(clazz);
    }

    public TypeDeserializer findPropertyTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, AnnotatedMember object) {
        Object object2 = deserializationConfig.getAnnotationIntrospector();
        if ((object2 = ((AnnotationIntrospector)object2).findPropertyTypeResolver(deserializationConfig, (AnnotatedMember)object, javaType)) == null) {
            return ((DeserializerFactory)this).findTypeDeserializer(deserializationConfig, javaType);
        }
        object = ((MapperConfig)deserializationConfig).getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, (AnnotatedMember)object, javaType);
        try {
            return object2.buildTypeDeserializer(deserializationConfig, javaType, (Collection<NamedType>)object);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            throw InvalidDefinitionException.from(null, ClassUtil.exceptionMessage(runtimeException), javaType).withCause(runtimeException);
        }
    }

    public TypeDeserializer findPropertyContentTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, AnnotatedMember object) {
        Object object2 = deserializationConfig.getAnnotationIntrospector();
        object2 = ((AnnotationIntrospector)object2).findPropertyContentTypeResolver(deserializationConfig, (AnnotatedMember)object, javaType);
        javaType = javaType.getContentType();
        if (object2 == null) {
            return ((DeserializerFactory)this).findTypeDeserializer(deserializationConfig, javaType);
        }
        object = ((MapperConfig)deserializationConfig).getSubtypeResolver().collectAndResolveSubtypesByTypeId(deserializationConfig, (AnnotatedMember)object, javaType);
        return object2.buildTypeDeserializer(deserializationConfig, javaType, (Collection<NamedType>)object);
    }

    public JsonDeserializer<?> findDefaultDeserializer(DeserializationContext object, JavaType javaType, BeanDescription beanDescription) {
        JsonDeserializer<?> jsonDeserializer;
        Object object2 = ((ResolvedType)javaType).getRawClass();
        if (object2 == CLASS_OBJECT || object2 == CLASS_SERIALIZABLE) {
            JavaType javaType2;
            DeserializationConfig deserializationConfig = ((DeserializationContext)object).getConfig();
            if (this._factoryConfig.hasAbstractTypeResolvers()) {
                javaType2 = this._findRemappedType(deserializationConfig, List.class);
                object2 = this._findRemappedType(deserializationConfig, Map.class);
            } else {
                object2 = null;
                javaType2 = null;
            }
            return new UntypedObjectDeserializer(javaType2, (JavaType)object2);
        }
        if (object2 == CLASS_STRING || object2 == CLASS_CHAR_SEQUENCE) {
            return StringDeserializer.instance;
        }
        if (object2 == CLASS_ITERABLE) {
            TypeFactory typeFactory = ((DatabindContext)object).getTypeFactory();
            Object object3 = typeFactory.findTypeParameters(javaType, CLASS_ITERABLE);
            object2 = object3 == null || ((JavaType[])object3).length != 1 ? TypeFactory.unknownType() : object3[0];
            object3 = typeFactory.constructCollectionType(Collection.class, (JavaType)object2);
            return ((DeserializerFactory)this).createCollectionDeserializer((DeserializationContext)object, (CollectionType)object3, beanDescription);
        }
        if (object2 == CLASS_MAP_ENTRY) {
            JavaType javaType3 = javaType.containedTypeOrUnknown(0);
            Object object4 = javaType.containedTypeOrUnknown(1);
            object2 = (TypeDeserializer)((JavaType)object4).getTypeHandler();
            if (object2 == null) {
                object2 = ((DeserializerFactory)this).findTypeDeserializer(((DeserializationContext)object).getConfig(), (JavaType)object4);
            }
            object4 = (JsonDeserializer)((JavaType)object4).getValueHandler();
            object = (KeyDeserializer)javaType3.getValueHandler();
            return new MapEntryDeserializer(javaType, (KeyDeserializer)object, (JsonDeserializer<Object>)object4, (TypeDeserializer)object2);
        }
        String string = ((Class)object2).getName();
        if (((Class)object2).isPrimitive() || string.startsWith("java.")) {
            jsonDeserializer = NumberDeserializers.find(object2, string);
            if (jsonDeserializer == null) {
                jsonDeserializer = DateDeserializers.find(object2, string);
            }
            if (jsonDeserializer != null) {
                return jsonDeserializer;
            }
        }
        if (object2 == TokenBuffer.class) {
            return new TokenBufferDeserializer();
        }
        jsonDeserializer = this.findOptionalStdDeserializer((DeserializationContext)object, javaType, beanDescription);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        return JdkDeserializers.find(object2, string);
    }

    protected JavaType _findRemappedType(DeserializationConfig serializable, Class<?> clazz) {
        DeserializationConfig deserializationConfig = serializable;
        serializable = ((DeserializerFactory)this).mapAbstractType(deserializationConfig, deserializationConfig.constructType(clazz));
        if (serializable == null || ((ResolvedType)((Object)serializable)).hasRawClass(clazz)) {
            return null;
        }
        return serializable;
    }

    protected JsonDeserializer<?> _findCustomTreeNodeDeserializer(Class<? extends JsonNode> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findTreeNodeDeserializer(clazz, deserializationConfig, beanDescription);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomReferenceDeserializer(ReferenceType referenceType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findReferenceDeserializer(referenceType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<Object> _findCustomBeanDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<Object> object = deserializers.findBeanDeserializer(javaType, deserializationConfig, beanDescription);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomArrayDeserializer(ArrayType arrayType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findArrayDeserializer(arrayType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomCollectionDeserializer(CollectionType collectionType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findCollectionDeserializer(collectionType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomCollectionLikeDeserializer(CollectionLikeType collectionLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findCollectionLikeDeserializer(collectionLikeType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomEnumDeserializer(Class<?> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findEnumDeserializer(clazz, deserializationConfig, beanDescription);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomMapDeserializer(MapType mapType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findMapDeserializer(mapType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<?> _findCustomMapLikeDeserializer(MapLikeType mapLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        for (Deserializers deserializers : this._factoryConfig.deserializers()) {
            JsonDeserializer<?> object = deserializers.findMapLikeDeserializer(mapLikeType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) {
        Object object = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (object != null && (object = ((AnnotationIntrospector)object).findDeserializer(annotated)) != null) {
            return deserializationContext.deserializerInstance(annotated, object);
        }
        return null;
    }

    protected KeyDeserializer findKeyDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) {
        Object object = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (object != null && (object = ((AnnotationIntrospector)object).findKeyDeserializer(annotated)) != null) {
            return deserializationContext.keyDeserializerInstance(annotated, object);
        }
        return null;
    }

    protected JsonDeserializer<Object> findContentDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) {
        Object object = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (object != null && (object = ((AnnotationIntrospector)object).findContentDeserializer(annotated)) != null) {
            return deserializationContext.deserializerInstance(annotated, object);
        }
        return null;
    }

    protected JavaType resolveMemberAndTypeAnnotations(DeserializationContext deserializationContext, AnnotatedMember annotatedMember, JavaType javaType) {
        Object object;
        AnnotationIntrospector annotationIntrospector = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            return javaType;
        }
        if (((ResolvedType)javaType).isMapLikeType() && (object = javaType.getKeyType()) != null) {
            object = annotationIntrospector.findKeyDeserializer(annotatedMember);
            if ((object = deserializationContext.keyDeserializerInstance(annotatedMember, object)) != null) {
                javaType = ((MapLikeType)javaType).withKeyValueHandler(object);
                javaType.getKeyType();
            }
        }
        if (javaType.hasContentType()) {
            object = annotationIntrospector.findContentDeserializer(annotatedMember);
            if ((object = deserializationContext.deserializerInstance(annotatedMember, object)) != null) {
                javaType = javaType.withContentValueHandler(object);
            }
            if ((object = this.findPropertyContentTypeDeserializer(deserializationContext.getConfig(), javaType, annotatedMember)) != null) {
                javaType = javaType.withContentTypeHandler(object);
            }
        }
        if ((object = this.findPropertyTypeDeserializer(deserializationContext.getConfig(), javaType, annotatedMember)) != null) {
            javaType = javaType.withTypeHandler(object);
        }
        javaType = annotationIntrospector.refineDeserializationType(deserializationContext.getConfig(), annotatedMember, javaType);
        return javaType;
    }

    protected EnumResolver constructEnumResolver(Class<?> clazz, DeserializationConfig deserializationConfig, AnnotatedMember annotatedMember) {
        if (annotatedMember != null) {
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(annotatedMember.getMember(), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return EnumResolver.constructUsingMethod(deserializationConfig, clazz, annotatedMember);
        }
        return EnumResolver.constructFor(deserializationConfig, clazz);
    }

    protected boolean _hasCreatorAnnotation(DeserializationContext object, Annotated annotated) {
        AnnotationIntrospector annotationIntrospector = ((DatabindContext)object).getAnnotationIntrospector();
        if (annotationIntrospector != null) {
            return (object = annotationIntrospector.findCreatorAnnotation(object.getConfig(), annotated)) != null && object != JsonCreator$Mode.DISABLED;
        }
        return false;
    }

    @Deprecated
    protected JavaType modifyTypeByAnnotation(DeserializationContext deserializationContext, Annotated annotated, JavaType javaType) {
        AnnotationIntrospector annotationIntrospector = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            return javaType;
        }
        return annotationIntrospector.refineDeserializationType(deserializationContext.getConfig(), annotated, javaType);
    }

    @Deprecated
    protected JavaType resolveType(DeserializationContext deserializationContext, BeanDescription beanDescription, JavaType javaType, AnnotatedMember annotatedMember) {
        return this.resolveMemberAndTypeAnnotations(deserializationContext, annotatedMember, javaType);
    }

    @Deprecated
    protected AnnotatedMethod _findJsonValueFor(DeserializationConfig object, JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        object = ((DeserializationConfig)object).introspect(javaType);
        return ((BeanDescription)object).findJsonValueMethod();
    }
}

