/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JsonFormat$Shape;
import com.fasterxml.jackson.annotation.JsonFormat$Value;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonDeserializer$None;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.LRUMap;
import java.io.Serializable;
import java.util.HashMap;

public final class DeserializerCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final LRUMap<JavaType, JsonDeserializer<Object>> _cachedDeserializers;
    protected final HashMap<JavaType, JsonDeserializer<Object>> _incompleteDeserializers = new HashMap(8);

    public DeserializerCache() {
        this(2000);
    }

    public DeserializerCache(int n2) {
        int n3 = Math.min(64, n2 >> 2);
        this._cachedDeserializers = new LRUMap(n3, n2);
    }

    final Object writeReplace() {
        this._incompleteDeserializers.clear();
        return this;
    }

    public final int cachedDeserializersCount() {
        return this._cachedDeserializers.size();
    }

    public final void flushCachedDeserializers() {
        this._cachedDeserializers.clear();
    }

    public final JsonDeserializer<Object> findValueDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType) {
        JsonDeserializer<Object> jsonDeserializer = this._findCachedDeserializer(javaType);
        if (jsonDeserializer == null && (jsonDeserializer = this._createAndCacheValueDeserializer(deserializationContext, deserializerFactory, javaType)) == null) {
            jsonDeserializer = this._handleUnknownValueDeserializer(deserializationContext, javaType);
        }
        return jsonDeserializer;
    }

    public final KeyDeserializer findKeyDeserializer(DeserializationContext deserializationContext, DeserializerFactory object, JavaType javaType) {
        if ((object = ((DeserializerFactory)object).createKeyDeserializer(deserializationContext, javaType)) == null) {
            return this._handleUnknownKeyDeserializer(deserializationContext, javaType);
        }
        if (object instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)object).resolve(deserializationContext);
        }
        return object;
    }

    public final boolean hasValueDeserializerFor(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType) {
        JsonDeserializer<Object> jsonDeserializer = this._findCachedDeserializer(javaType);
        if (jsonDeserializer == null) {
            jsonDeserializer = this._createAndCacheValueDeserializer(deserializationContext, deserializerFactory, javaType);
        }
        return jsonDeserializer != null;
    }

    protected final JsonDeserializer<Object> _findCachedDeserializer(JavaType javaType) {
        if (javaType == null) {
            throw new IllegalArgumentException("Null JavaType passed");
        }
        if (this._hasCustomHandlers(javaType)) {
            return null;
        }
        return this._cachedDeserializers.get(javaType);
    }

    protected final JsonDeserializer<Object> _createAndCacheValueDeserializer(DeserializationContext object, DeserializerFactory deserializerFactory, JavaType javaType) {
        HashMap<JavaType, JsonDeserializer<Object>> hashMap = this._incompleteDeserializers;
        synchronized (hashMap) {
            block9: {
                JsonDeserializer<Object> jsonDeserializer = this._findCachedDeserializer(javaType);
                if (jsonDeserializer != null) {
                    return jsonDeserializer;
                }
                int n2 = this._incompleteDeserializers.size();
                if (n2 > 0 && (jsonDeserializer = this._incompleteDeserializers.get(javaType)) != null) {
                    return jsonDeserializer;
                }
                try {
                    object = this._createAndCache2((DeserializationContext)object, deserializerFactory, javaType);
                    if (n2 != 0 || this._incompleteDeserializers.size() <= 0) break block9;
                    this._incompleteDeserializers.clear();
                }
                catch (Throwable throwable) {
                    if (n2 == 0 && this._incompleteDeserializers.size() > 0) {
                        this._incompleteDeserializers.clear();
                    }
                    throw throwable;
                }
            }
            return object;
        }
    }

    protected final JsonDeserializer<Object> _createAndCache2(DeserializationContext deserializationContext, DeserializerFactory object, JavaType javaType) {
        boolean bl;
        try {
            object = this._createDeserializer(deserializationContext, (DeserializerFactory)object, javaType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ((DatabindContext)deserializationContext).reportBadDefinition(javaType, ClassUtil.exceptionMessage(illegalArgumentException));
            object = null;
        }
        if (object == null) {
            return null;
        }
        boolean bl2 = bl = !this._hasCustomHandlers(javaType) && ((JsonDeserializer)object).isCachable();
        if (object instanceof ResolvableDeserializer) {
            this._incompleteDeserializers.put(javaType, (JsonDeserializer<Object>)object);
            ((ResolvableDeserializer)object).resolve(deserializationContext);
            this._incompleteDeserializers.remove(javaType);
        }
        if (bl) {
            this._cachedDeserializers.put(javaType, (JsonDeserializer<Object>)object);
        }
        return object;
    }

    protected final JsonDeserializer<Object> _createDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType object) {
        BeanDescription beanDescription;
        Converter<Object, Object> converter;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        if (((ResolvedType)object).isAbstract() || ((ResolvedType)object).isMapLikeType() || ((ResolvedType)object).isCollectionLikeType()) {
            object = deserializerFactory.mapAbstractType(deserializationConfig, (JavaType)object);
        }
        if ((converter = this.findDeserializerFromAnnotation(deserializationContext, (beanDescription = deserializationConfig.introspect((JavaType)object)).getClassInfo())) != null) {
            return converter;
        }
        converter = this.modifyTypeByAnnotation(deserializationContext, beanDescription.getClassInfo(), (JavaType)object);
        if (converter != object) {
            object = converter;
            beanDescription = deserializationConfig.introspect((JavaType)((Object)converter));
        }
        if ((converter = beanDescription.findPOJOBuilder()) != null) {
            return deserializerFactory.createBuilderBasedDeserializer(deserializationContext, (JavaType)object, beanDescription, (Class<?>)((Object)converter));
        }
        converter = beanDescription.findDeserializationConverter();
        if (converter == null) {
            return this._createDeserializer2(deserializationContext, deserializerFactory, (JavaType)object, beanDescription);
        }
        JavaType javaType = converter.getInputType(((DatabindContext)deserializationContext).getTypeFactory());
        if (!((ResolvedType)javaType).hasRawClass(((ResolvedType)object).getRawClass())) {
            beanDescription = deserializationConfig.introspect(javaType);
        }
        return new StdDelegatingDeserializer<Object>(converter, javaType, this._createDeserializer2(deserializationContext, deserializerFactory, javaType, beanDescription));
    }

    protected final JsonDeserializer<?> _createDeserializer2(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType, BeanDescription beanDescription) {
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        if (((ResolvedType)javaType).isEnumType()) {
            return deserializerFactory.createEnumDeserializer(deserializationContext, javaType, beanDescription);
        }
        if (((ResolvedType)javaType).isContainerType()) {
            JsonFormat$Value jsonFormat$Value;
            if (((ResolvedType)javaType).isArrayType()) {
                return deserializerFactory.createArrayDeserializer(deserializationContext, (ArrayType)javaType, beanDescription);
            }
            if (((ResolvedType)javaType).isMapLikeType() && (jsonFormat$Value = beanDescription.findExpectedFormat(null)).getShape() != JsonFormat$Shape.OBJECT) {
                if ((javaType = (MapLikeType)javaType) instanceof MapType) {
                    return deserializerFactory.createMapDeserializer(deserializationContext, (MapType)javaType, beanDescription);
                }
                return deserializerFactory.createMapLikeDeserializer(deserializationContext, (MapLikeType)javaType, beanDescription);
            }
            if (((ResolvedType)javaType).isCollectionLikeType() && (jsonFormat$Value = beanDescription.findExpectedFormat(null)).getShape() != JsonFormat$Shape.OBJECT) {
                if ((javaType = (CollectionLikeType)javaType) instanceof CollectionType) {
                    return deserializerFactory.createCollectionDeserializer(deserializationContext, (CollectionType)javaType, beanDescription);
                }
                return deserializerFactory.createCollectionLikeDeserializer(deserializationContext, (CollectionLikeType)javaType, beanDescription);
            }
        }
        if (javaType.isReferenceType()) {
            return deserializerFactory.createReferenceDeserializer(deserializationContext, (ReferenceType)javaType, beanDescription);
        }
        if (JsonNode.class.isAssignableFrom(((ResolvedType)javaType).getRawClass())) {
            return deserializerFactory.createTreeDeserializer(deserializationConfig, javaType, beanDescription);
        }
        return deserializerFactory.createBeanDeserializer(deserializationContext, javaType, beanDescription);
    }

    protected final JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) {
        JsonDeserializer<Object> jsonDeserializer = ((DatabindContext)deserializationContext).getAnnotationIntrospector().findDeserializer(annotated);
        if (jsonDeserializer == null) {
            return null;
        }
        jsonDeserializer = deserializationContext.deserializerInstance(annotated, jsonDeserializer);
        return this.findConvertingDeserializer(deserializationContext, annotated, jsonDeserializer);
    }

    protected final JsonDeserializer<Object> findConvertingDeserializer(DeserializationContext serializable, Annotated object, JsonDeserializer<Object> jsonDeserializer) {
        if ((object = this.findConverter((DeserializationContext)serializable, (Annotated)object)) == null) {
            return jsonDeserializer;
        }
        serializable = object.getInputType(((DatabindContext)((Object)serializable)).getTypeFactory());
        return new StdDelegatingDeserializer<Object>((Converter<Object, Object>)object, (JavaType)serializable, jsonDeserializer);
    }

    protected final Converter<Object, Object> findConverter(DeserializationContext deserializationContext, Annotated annotated) {
        Object object = ((DatabindContext)deserializationContext).getAnnotationIntrospector().findDeserializationConverter(annotated);
        if (object == null) {
            return null;
        }
        return deserializationContext.converterInstance(annotated, object);
    }

    private JavaType modifyTypeByAnnotation(DeserializationContext deserializationContext, Annotated annotated, JavaType javaType) {
        JsonDeserializer<Object> jsonDeserializer;
        Class<?> clazz;
        AnnotationIntrospector annotationIntrospector = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (annotationIntrospector == null) {
            return javaType;
        }
        if (((ResolvedType)javaType).isMapLikeType() && (clazz = javaType.getKeyType()) != null && ((JavaType)((Object)clazz)).getValueHandler() == null && (clazz = annotationIntrospector.findKeyDeserializer(annotated)) != null && (jsonDeserializer = deserializationContext.keyDeserializerInstance(annotated, clazz)) != null) {
            javaType = ((MapLikeType)javaType).withKeyValueHandler(jsonDeserializer);
        }
        if ((clazz = javaType.getContentType()) != null && ((JavaType)((Object)clazz)).getValueHandler() == null && (clazz = annotationIntrospector.findContentDeserializer(annotated)) != null) {
            jsonDeserializer = null;
            if (clazz instanceof JsonDeserializer) {
                jsonDeserializer = (JsonDeserializer)((Object)clazz);
            } else if ((clazz = this._verifyAsClass(clazz, "findContentDeserializer", JsonDeserializer$None.class)) != null) {
                jsonDeserializer = deserializationContext.deserializerInstance(annotated, clazz);
            }
            if (jsonDeserializer != null) {
                javaType = javaType.withContentValueHandler(jsonDeserializer);
            }
        }
        javaType = annotationIntrospector.refineDeserializationType(deserializationContext.getConfig(), annotated, javaType);
        return javaType;
    }

    private boolean _hasCustomHandlers(JavaType javaType) {
        if (((ResolvedType)javaType).isContainerType()) {
            JavaType javaType2 = javaType.getContentType();
            if (javaType2 != null && (javaType2.getValueHandler() != null || javaType2.getTypeHandler() != null)) {
                return true;
            }
            if (((ResolvedType)javaType).isMapLikeType() && (javaType = javaType.getKeyType()).getValueHandler() != null) {
                return true;
            }
        }
        return false;
    }

    private Class<?> _verifyAsClass(Object object, String string, Class<?> clazz) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector." + string + "() returned value of type " + object.getClass().getName() + ": expected type JsonSerializer or Class<JsonSerializer> instead");
        }
        if ((object = (Class)object) == clazz || ClassUtil.isBogusClass(object)) {
            return null;
        }
        return object;
    }

    protected final JsonDeserializer<Object> _handleUnknownValueDeserializer(DeserializationContext deserializationContext, JavaType javaType) {
        Class<?> clazz = ((ResolvedType)javaType).getRawClass();
        if (!ClassUtil.isConcrete(clazz)) {
            return (JsonDeserializer)((DatabindContext)deserializationContext).reportBadDefinition(javaType, "Cannot find a Value deserializer for abstract type " + javaType);
        }
        return (JsonDeserializer)((DatabindContext)deserializationContext).reportBadDefinition(javaType, "Cannot find a Value deserializer for type " + javaType);
    }

    protected final KeyDeserializer _handleUnknownKeyDeserializer(DeserializationContext deserializationContext, JavaType javaType) {
        return (KeyDeserializer)((DatabindContext)deserializationContext).reportBadDefinition(javaType, "Cannot find a (Map) Key deserializer for type " + javaType);
    }
}

