/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty$AnySetterReferring;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId$Referring;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.Map;

public class SettableAnyProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final BeanProperty _property;
    protected final AnnotatedMember _setter;
    final boolean _setterIsField;
    protected final JavaType _type;
    protected JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final KeyDeserializer _keyDeserializer;

    public SettableAnyProperty(BeanProperty beanProperty, AnnotatedMember annotatedMember, JavaType javaType, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        this._property = beanProperty;
        this._setter = annotatedMember;
        this._type = javaType;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._keyDeserializer = keyDeserializer;
        this._setterIsField = annotatedMember instanceof AnnotatedField;
    }

    @Deprecated
    public SettableAnyProperty(BeanProperty beanProperty, AnnotatedMember annotatedMember, JavaType javaType, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        this(beanProperty, annotatedMember, javaType, null, jsonDeserializer, typeDeserializer);
    }

    public SettableAnyProperty withValueDeserializer(JsonDeserializer<Object> jsonDeserializer) {
        return new SettableAnyProperty(this._property, this._setter, this._type, this._keyDeserializer, jsonDeserializer, this._valueTypeDeserializer);
    }

    public void fixAccess(DeserializationConfig deserializationConfig) {
        this._setter.fixAccess(deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    Object readResolve() {
        if (this._setter == null || this._setter.getAnnotated() == null) {
            throw new IllegalArgumentException("Missing method (broken JDK (de)serialization?)");
        }
        return this;
    }

    public BeanProperty getProperty() {
        return this._property;
    }

    public boolean hasValueDeserializer() {
        return this._valueDeserializer != null;
    }

    public JavaType getType() {
        return this._type;
    }

    public final void deserializeAndSet(JsonParser object, DeserializationContext deserializationContext, Object object2, String string) {
        try {
            String string2 = this._keyDeserializer == null ? string : this._keyDeserializer.deserializeKey(string, deserializationContext);
            this.set(object2, string2, this.deserialize((JsonParser)object, deserializationContext));
            return;
        }
        catch (UnresolvedForwardReference unresolvedForwardReference) {
            if (this._valueDeserializer.getObjectIdReader() == null) {
                throw JsonMappingException.from((JsonParser)object, "Unresolved forward reference but no identity info.", (Throwable)unresolvedForwardReference);
            }
            object = new SettableAnyProperty$AnySetterReferring(this, unresolvedForwardReference, ((ResolvedType)this._type).getRawClass(), object2, string);
            unresolvedForwardReference.getRoid().appendReferring((ReadableObjectId$Referring)object);
            return;
        }
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            return this._valueDeserializer.getNullValue(deserializationContext);
        }
        if (this._valueTypeDeserializer != null) {
            return this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
        }
        return this._valueDeserializer.deserialize(jsonParser, deserializationContext);
    }

    public void set(Object object, Object object2, Object object3) {
        block4: {
            try {
                if (this._setterIsField) {
                    AnnotatedField annotatedField = (AnnotatedField)this._setter;
                    if ((object = (Map)((AnnotatedMember)annotatedField).getValue(object)) != null) {
                        object.put(object2, object3);
                    }
                    break block4;
                }
                ((AnnotatedMethod)this._setter).callOnWith(object, object2, object3);
                return;
            }
            catch (Exception exception) {
                this._throwAsIOE(exception, object2, object3);
            }
        }
    }

    protected void _throwAsIOE(Exception exception, Object object, Object object2) {
        if (exception instanceof IllegalArgumentException) {
            object2 = ClassUtil.classNameOf(object2);
            object = new StringBuilder("Problem deserializing \"any\" property '").append(object);
            ((StringBuilder)object).append("' of class " + this.getClassName() + " (expected type: ").append(this._type);
            ((StringBuilder)object).append("; actual type: ").append((String)object2).append(")");
            object2 = ClassUtil.exceptionMessage(exception);
            if (object2 != null) {
                ((StringBuilder)object).append(", problem: ").append((String)object2);
            } else {
                ((StringBuilder)object).append(" (no error message provided)");
            }
            throw new JsonMappingException(null, ((StringBuilder)object).toString(), (Throwable)exception);
        }
        ClassUtil.throwIfIOE(exception);
        ClassUtil.throwIfRTE(exception);
        object2 = ClassUtil.getRootCause(exception);
        throw new JsonMappingException(null, ClassUtil.exceptionMessage((Throwable)object2), (Throwable)object2);
    }

    private String getClassName() {
        return this._setter.getDeclaringClass().getName();
    }

    public String toString() {
        return "[any property on class " + this.getClassName() + "]";
    }
}

