/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.util.Set;

public class BeanAsArrayBuilderDeserializer
extends BeanDeserializerBase {
    private static final long serialVersionUID = 1L;
    protected final BeanDeserializerBase _delegate;
    protected final SettableBeanProperty[] _orderedProperties;
    protected final AnnotatedMethod _buildMethod;
    protected final JavaType _targetType;

    public BeanAsArrayBuilderDeserializer(BeanDeserializerBase beanDeserializerBase, JavaType javaType, SettableBeanProperty[] settableBeanPropertyArray, AnnotatedMethod annotatedMethod) {
        super(beanDeserializerBase);
        this._delegate = beanDeserializerBase;
        this._targetType = javaType;
        this._orderedProperties = settableBeanPropertyArray;
        this._buildMethod = annotatedMethod;
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer nameTransformer) {
        return ((JsonDeserializer)this._delegate).unwrappingDeserializer(nameTransformer);
    }

    @Override
    public BeanDeserializerBase withObjectIdReader(ObjectIdReader objectIdReader) {
        return new BeanAsArrayBuilderDeserializer(this._delegate.withObjectIdReader(objectIdReader), this._targetType, this._orderedProperties, this._buildMethod);
    }

    @Override
    public BeanDeserializerBase withByNameInclusion(Set<String> set, Set<String> set2) {
        return new BeanAsArrayBuilderDeserializer(this._delegate.withByNameInclusion(set, set2), this._targetType, this._orderedProperties, this._buildMethod);
    }

    @Override
    public BeanDeserializerBase withIgnoreAllUnknown(boolean bl) {
        return new BeanAsArrayBuilderDeserializer(this._delegate.withIgnoreAllUnknown(bl), this._targetType, this._orderedProperties, this._buildMethod);
    }

    @Override
    public BeanDeserializerBase withBeanProperties(BeanPropertyMap beanPropertyMap) {
        return new BeanAsArrayBuilderDeserializer(this._delegate.withBeanProperties(beanPropertyMap), this._targetType, this._orderedProperties, this._buildMethod);
    }

    @Override
    public BeanDeserializerBase asArrayDeserializer() {
        return this;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.FALSE;
    }

    protected final Object finishBuild(DeserializationContext deserializationContext, Object object) {
        try {
            return this._buildMethod.getMember().invoke(object, null);
        }
        catch (Exception exception) {
            return this.wrapInstantiationProblem(exception, deserializationContext);
        }
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.finishBuild(deserializationContext, this._deserializeFromNonArray(jsonParser, deserializationContext));
        }
        if (!this._vanillaProcessing) {
            return this.finishBuild(deserializationContext, this._deserializeNonVanilla(jsonParser, deserializationContext));
        }
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n2 = 0;
        int n3 = settableBeanPropertyArray.length;
        while (true) {
            if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                return this.finishBuild(deserializationContext, object);
            }
            if (n2 == n3) break;
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[n2];
            if (settableBeanProperty != null) {
                try {
                    object = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow(exception, object, settableBeanProperty.getName(), deserializationContext);
                }
            } else {
                jsonParser.skipChildren();
            }
            ++n2;
        }
        if (!this._ignoreAllUnknown && deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            deserializationContext.reportInputMismatch(((JsonDeserializer)this).handledType(), "Unexpected JSON values; expected at most %d properties (in JSON Array)", n3);
        }
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            jsonParser.skipChildren();
        }
        return this.finishBuild(deserializationContext, object);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        return this._delegate.deserialize(jsonParser, deserializationContext, object);
    }

    @Override
    public Object deserializeFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) {
        return this._deserializeFromNonArray(jsonParser, deserializationContext);
    }

    protected Object _deserializeNonVanilla(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (this._nonStandardCreation) {
            return this.deserializeFromObjectUsingNonDefault(jsonParser, deserializationContext);
        }
        Object object = this._valueInstantiator.createUsingDefault(deserializationContext);
        if (this._injectables != null) {
            this.injectValues(deserializationContext, object);
        }
        Class<?> clazz = this._needViewProcesing ? ((DatabindContext)deserializationContext).getActiveView() : null;
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n2 = 0;
        int n3 = settableBeanPropertyArray.length;
        while (true) {
            if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                return object;
            }
            if (n2 == n3) break;
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[n2];
            ++n2;
            if (settableBeanProperty != null && (clazz == null || settableBeanProperty.visibleInView(clazz))) {
                try {
                    settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                }
                catch (Exception exception) {
                    this.wrapAndThrow(exception, object, settableBeanProperty.getName(), deserializationContext);
                }
                continue;
            }
            jsonParser.skipChildren();
        }
        if (!this._ignoreAllUnknown && deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            deserializationContext.reportWrongTokenException(this, JsonToken.END_ARRAY, "Unexpected JSON value(s); expected at most %d properties (in JSON Array)", n3);
        }
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            jsonParser.skipChildren();
        }
        return object;
    }

    @Override
    public final Object _deserializeUsingPropertyBased(JsonParser jsonParser, DeserializationContext deserializationContext) {
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, this._objectIdReader);
        SettableBeanProperty[] settableBeanPropertyArray = this._orderedProperties;
        int n2 = this._orderedProperties.length;
        Class<?> clazz = this._needViewProcesing ? ((DatabindContext)deserializationContext).getActiveView() : null;
        int n3 = 0;
        Object object = null;
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            block19: {
                SettableBeanProperty settableBeanProperty = n3 < n2 ? settableBeanPropertyArray[n3] : null;
                if (settableBeanProperty == null) {
                    jsonParser.skipChildren();
                } else if (clazz != null && !settableBeanProperty.visibleInView(clazz)) {
                    jsonParser.skipChildren();
                } else if (object != null) {
                    try {
                        object = settableBeanProperty.deserializeSetAndReturn(jsonParser, deserializationContext, object);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(exception, object, settableBeanProperty.getName(), deserializationContext);
                    }
                } else {
                    String string = settableBeanProperty.getName();
                    SettableBeanProperty settableBeanProperty2 = propertyBasedCreator.findCreatorProperty(string);
                    if (!propertyValueBuffer.readIdProperty(string) || settableBeanProperty2 != null) {
                        if (settableBeanProperty2 != null) {
                            SettableBeanProperty settableBeanProperty3 = settableBeanProperty2;
                            if (propertyValueBuffer.assignParameter(settableBeanProperty3, settableBeanProperty3.deserialize(jsonParser, deserializationContext))) {
                                try {
                                    object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                                }
                                catch (Exception exception) {
                                    this.wrapAndThrow(exception, ((ResolvedType)this._beanType).getRawClass(), string, deserializationContext);
                                    break block19;
                                }
                                if (object.getClass() != ((ResolvedType)this._beanType).getRawClass()) {
                                    return ((DatabindContext)deserializationContext).reportBadDefinition(this._beanType, String.format("Cannot support implicit polymorphic deserialization for POJOs-as-Arrays style: nominal type %s, actual type %s", ClassUtil.getTypeDescription(this._beanType), object.getClass().getName()));
                                }
                            }
                        } else {
                            SettableBeanProperty settableBeanProperty4 = settableBeanProperty;
                            propertyValueBuffer.bufferProperty(settableBeanProperty4, settableBeanProperty4.deserialize(jsonParser, deserializationContext));
                        }
                    }
                }
            }
            ++n3;
        }
        if (object == null) {
            try {
                object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
            }
            catch (Exception exception) {
                return this.wrapInstantiationProblem(exception, deserializationContext);
            }
        }
        return object;
    }

    protected Object _deserializeFromNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        String string = "Cannot deserialize a POJO (of type %s) from non-Array representation (token: %s): type/property designed to be serialized as JSON Array";
        return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser.currentToken(), jsonParser, string, new Object[]{((ResolvedType)this._beanType).getRawClass().getName(), jsonParser.currentToken()});
    }
}

