/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler$Builder;
import com.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler$ExtTypedProperty;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.introspect.ConcreteBeanPropertyBase;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExternalTypeHandler {
    private final JavaType _beanType;
    private final ExternalTypeHandler$ExtTypedProperty[] _properties;
    private final Map<String, Object> _nameToPropertyIndex;
    private final String[] _typeIds;
    private final TokenBuffer[] _tokens;

    protected ExternalTypeHandler(JavaType javaType, ExternalTypeHandler$ExtTypedProperty[] externalTypeHandler$ExtTypedPropertyArray, Map<String, Object> map, String[] stringArray, TokenBuffer[] tokenBufferArray) {
        this._beanType = javaType;
        this._properties = externalTypeHandler$ExtTypedPropertyArray;
        this._nameToPropertyIndex = map;
        this._typeIds = stringArray;
        this._tokens = tokenBufferArray;
    }

    protected ExternalTypeHandler(ExternalTypeHandler externalTypeHandler) {
        this._beanType = externalTypeHandler._beanType;
        this._properties = externalTypeHandler._properties;
        this._nameToPropertyIndex = externalTypeHandler._nameToPropertyIndex;
        int n2 = this._properties.length;
        this._typeIds = new String[n2];
        this._tokens = new TokenBuffer[n2];
    }

    public static ExternalTypeHandler$Builder builder(JavaType javaType) {
        return new ExternalTypeHandler$Builder(javaType);
    }

    public ExternalTypeHandler start() {
        return new ExternalTypeHandler(this);
    }

    public boolean handleTypePropertyValue(JsonParser jsonParser, DeserializationContext deserializationContext, String string, Object object) {
        Iterator iterator = this._nameToPropertyIndex.get(string);
        if (iterator == null) {
            return false;
        }
        String string2 = jsonParser.getText();
        if (iterator instanceof List) {
            boolean bl = false;
            for (Integer n2 : (List)((Object)iterator)) {
                if (!this._handleTypePropertyValue(jsonParser, deserializationContext, string, object, string2, n2)) continue;
                bl = true;
            }
            return bl;
        }
        return this._handleTypePropertyValue(jsonParser, deserializationContext, string, object, string2, (Integer)((Object)iterator));
    }

    private final boolean _handleTypePropertyValue(JsonParser jsonParser, DeserializationContext deserializationContext, String string, Object object, String string2, int n2) {
        ExternalTypeHandler$ExtTypedProperty externalTypeHandler$ExtTypedProperty = this._properties[n2];
        if (!externalTypeHandler$ExtTypedProperty.hasTypePropertyName(string)) {
            return false;
        }
        boolean bl = object != null && this._tokens[n2] != null;
        if (bl) {
            this._deserializeAndSet(jsonParser, deserializationContext, object, n2, string2);
            this._tokens[n2] = null;
        } else {
            this._typeIds[n2] = string2;
        }
        return true;
    }

    public boolean handlePropertyValue(JsonParser jsonParser, DeserializationContext deserializationContext, String object, Object object2) {
        boolean bl;
        Iterator iterator = this._nameToPropertyIndex.get(object);
        if (iterator == null) {
            return false;
        }
        if (iterator instanceof List) {
            Integer n2 = (Integer)(iterator = ((List)((Object)iterator)).iterator()).next();
            ExternalTypeHandler$ExtTypedProperty externalTypeHandler$ExtTypedProperty = this._properties[n2];
            if (externalTypeHandler$ExtTypedProperty.hasTypePropertyName((String)object)) {
                object = jsonParser.getText();
                jsonParser.skipChildren();
                this._typeIds[n2.intValue()] = object;
                while (iterator.hasNext()) {
                    this._typeIds[((Integer)iterator.next()).intValue()] = object;
                }
            } else {
                this._tokens[n2.intValue()] = object = deserializationContext.bufferAsCopyOfValue(jsonParser);
                while (iterator.hasNext()) {
                    this._tokens[((Integer)iterator.next()).intValue()] = object;
                }
            }
            return true;
        }
        int n3 = (Integer)((Object)iterator);
        ExternalTypeHandler$ExtTypedProperty externalTypeHandler$ExtTypedProperty = this._properties[n3];
        if (externalTypeHandler$ExtTypedProperty.hasTypePropertyName((String)object)) {
            this._typeIds[n3] = jsonParser.getValueAsString();
            jsonParser.skipChildren();
            bl = object2 != null && this._tokens[n3] != null;
        } else {
            this._tokens[n3] = object = deserializationContext.bufferAsCopyOfValue(jsonParser);
            boolean bl2 = bl = object2 != null && this._typeIds[n3] != null;
        }
        if (bl) {
            object = this._typeIds[n3];
            this._typeIds[n3] = null;
            this._deserializeAndSet(jsonParser, deserializationContext, object2, n3, (String)object);
            this._tokens[n3] = null;
        }
        return true;
    }

    public Object complete(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        int n2 = this._properties.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2;
            String string = this._typeIds[i2];
            ExternalTypeHandler$ExtTypedProperty externalTypeHandler$ExtTypedProperty = this._properties[i2];
            if (string == null) {
                object2 = this._tokens[i2];
                if (object2 == null) continue;
                Object object3 = ((TokenBuffer)object2).firstToken();
                if (object3.isScalarValue()) {
                    object2 = ((TokenBuffer)object2).asParser(jsonParser);
                    ((JsonParser)object2).nextToken();
                    object3 = externalTypeHandler$ExtTypedProperty.getProperty();
                    object2 = TypeDeserializer.deserializeIfNatural((JsonParser)object2, deserializationContext, ((SettableBeanProperty)object3).getType());
                    if (object2 != null) {
                        ((SettableBeanProperty)object3).set(object, object2);
                        continue;
                    }
                }
                if (!externalTypeHandler$ExtTypedProperty.hasDefaultType()) {
                    deserializationContext.reportPropertyInputMismatch(this._beanType, externalTypeHandler$ExtTypedProperty.getProperty().getName(), "Missing external type id property '%s' (and no 'defaultImpl' specified)", externalTypeHandler$ExtTypedProperty.getTypePropertyName());
                } else {
                    string = externalTypeHandler$ExtTypedProperty.getDefaultTypeId();
                    if (string == null) {
                        deserializationContext.reportPropertyInputMismatch(this._beanType, externalTypeHandler$ExtTypedProperty.getProperty().getName(), "Invalid default type id for property '%s': `null` returned by TypeIdResolver", externalTypeHandler$ExtTypedProperty.getTypePropertyName());
                    }
                }
            } else if (this._tokens[i2] == null) {
                object2 = externalTypeHandler$ExtTypedProperty.getProperty();
                if (((ConcreteBeanPropertyBase)object2).isRequired() || deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_MISSING_EXTERNAL_TYPE_ID_PROPERTY)) {
                    deserializationContext.reportPropertyInputMismatch(object.getClass(), ((SettableBeanProperty)object2).getName(), "Missing property '%s' for external type id '%s'", ((SettableBeanProperty)object2).getName(), externalTypeHandler$ExtTypedProperty.getTypePropertyName());
                }
                return object;
            }
            this._deserializeAndSet(jsonParser, deserializationContext, object, i2, string);
        }
        return object;
    }

    public Object complete(JsonParser jsonParser, DeserializationContext deserializationContext, PropertyValueBuffer propertyValueBuffer, PropertyBasedCreator propertyBasedCreator) {
        Object object;
        int n2 = this._properties.length;
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2;
            Object object3 = this._typeIds[i2];
            object = this._properties[i2];
            if (object3 == null) {
                object2 = this._tokens[i2];
                if (object2 == null || ((TokenBuffer)object2).firstToken() == JsonToken.VALUE_NULL) continue;
                if (!((ExternalTypeHandler$ExtTypedProperty)object).hasDefaultType()) {
                    deserializationContext.reportPropertyInputMismatch(this._beanType, ((ExternalTypeHandler$ExtTypedProperty)object).getProperty().getName(), "Missing external type id property '%s'", ((ExternalTypeHandler$ExtTypedProperty)object).getTypePropertyName());
                } else {
                    object3 = ((ExternalTypeHandler$ExtTypedProperty)object).getDefaultTypeId();
                }
            } else if (this._tokens[i2] == null && (((ConcreteBeanPropertyBase)(object2 = ((ExternalTypeHandler$ExtTypedProperty)object).getProperty())).isRequired() || deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_MISSING_EXTERNAL_TYPE_ID_PROPERTY))) {
                deserializationContext.reportPropertyInputMismatch(this._beanType, ((SettableBeanProperty)object2).getName(), "Missing property '%s' for external type id '%s'", ((SettableBeanProperty)object2).getName(), this._properties[i2].getTypePropertyName());
            }
            if (this._tokens[i2] != null) {
                objectArray[i2] = this._deserialize(jsonParser, deserializationContext, i2, (String)object3);
            }
            if (((SettableBeanProperty)(object2 = ((ExternalTypeHandler$ExtTypedProperty)object).getProperty())).getCreatorIndex() < 0) continue;
            propertyValueBuffer.assignParameter((SettableBeanProperty)object2, objectArray[i2]);
            object = ((ExternalTypeHandler$ExtTypedProperty)object).getTypeProperty();
            if (object == null || ((SettableBeanProperty)object).getCreatorIndex() < 0) continue;
            if (!((ResolvedType)((SettableBeanProperty)object).getType()).hasRawClass(String.class)) {
                object2 = deserializationContext.bufferForInputBuffering(jsonParser);
                ((JsonGenerator)object2).writeString((String)object3);
                object3 = ((SettableBeanProperty)object).getValueDeserializer().deserialize(((TokenBuffer)object2).asParserOnFirstToken(), deserializationContext);
                ((JsonGenerator)object2).close();
            }
            propertyValueBuffer.assignParameter((SettableBeanProperty)object, object3);
        }
        Object object4 = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        for (int i3 = 0; i3 < n2; ++i3) {
            object = this._properties[i3].getProperty();
            if (((SettableBeanProperty)object).getCreatorIndex() >= 0) continue;
            ((SettableBeanProperty)object).set(object4, objectArray[i3]);
        }
        return object4;
    }

    protected final Object _deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, int n2, String string) {
        JsonParser jsonParser2 = this._tokens[n2].asParser(jsonParser);
        Object object = jsonParser2.nextToken();
        if (object == JsonToken.VALUE_NULL) {
            return null;
        }
        object = deserializationContext.bufferForInputBuffering(jsonParser);
        ((JsonGenerator)object).writeStartArray();
        ((JsonGenerator)object).writeString(string);
        ((JsonGenerator)object).copyCurrentStructure(jsonParser2);
        ((JsonGenerator)object).writeEndArray();
        jsonParser = ((TokenBuffer)object).asParser(jsonParser);
        jsonParser.nextToken();
        return this._properties[n2].getProperty().deserialize(jsonParser, deserializationContext);
    }

    protected final void _deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, int n2, String string) {
        JsonParser jsonParser2;
        Object object2;
        if (string == null) {
            deserializationContext.reportInputMismatch(this._beanType, "Internal error in external Type Id handling: `null` type id passed", new Object[0]);
        }
        if ((object2 = (jsonParser2 = this._tokens[n2].asParser(jsonParser)).nextToken()) == JsonToken.VALUE_NULL) {
            this._properties[n2].getProperty().set(object, null);
            return;
        }
        object2 = deserializationContext.bufferForInputBuffering(jsonParser);
        ((JsonGenerator)object2).writeStartArray();
        ((JsonGenerator)object2).writeString(string);
        ((JsonGenerator)object2).copyCurrentStructure(jsonParser2);
        ((JsonGenerator)object2).writeEndArray();
        jsonParser = ((TokenBuffer)object2).asParser(jsonParser);
        jsonParser.nextToken();
        this._properties[n2].getProperty().deserializeAndSet(jsonParser, deserializationContext, object);
    }
}

