/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public final class FieldProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedField _annotated;
    protected final transient Field _field;
    protected final boolean _skipNulls;

    public FieldProperty(BeanPropertyDefinition beanPropertyDefinition, JavaType javaType, TypeDeserializer typeDeserializer, Annotations annotations, AnnotatedField annotatedField) {
        super(beanPropertyDefinition, javaType, typeDeserializer, annotations);
        this._annotated = annotatedField;
        this._field = annotatedField.getAnnotated();
        this._skipNulls = NullsConstantProvider.isSkipper(this._nullProvider);
    }

    protected FieldProperty(FieldProperty fieldProperty, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider) {
        super(fieldProperty, jsonDeserializer, nullValueProvider);
        this._annotated = fieldProperty._annotated;
        this._field = fieldProperty._field;
        this._skipNulls = NullsConstantProvider.isSkipper(nullValueProvider);
    }

    protected FieldProperty(FieldProperty fieldProperty, PropertyName propertyName) {
        super(fieldProperty, propertyName);
        this._annotated = fieldProperty._annotated;
        this._field = fieldProperty._field;
        this._skipNulls = fieldProperty._skipNulls;
    }

    protected FieldProperty(FieldProperty fieldProperty) {
        super(fieldProperty);
        this._annotated = fieldProperty._annotated;
        Field field = this._annotated.getAnnotated();
        if (field == null) {
            throw new IllegalArgumentException("Missing field (broken JDK (de)serialization?)");
        }
        this._field = field;
        this._skipNulls = fieldProperty._skipNulls;
    }

    @Override
    public final SettableBeanProperty withName(PropertyName propertyName) {
        return new FieldProperty(this, propertyName);
    }

    @Override
    public final SettableBeanProperty withValueDeserializer(JsonDeserializer<?> jsonDeserializer) {
        if (this._valueDeserializer == jsonDeserializer) {
            return this;
        }
        NullValueProvider nullValueProvider = this._valueDeserializer == this._nullProvider ? jsonDeserializer : this._nullProvider;
        return new FieldProperty(this, jsonDeserializer, nullValueProvider);
    }

    @Override
    public final SettableBeanProperty withNullProvider(NullValueProvider nullValueProvider) {
        FieldProperty fieldProperty = this;
        return new FieldProperty(fieldProperty, fieldProperty._valueDeserializer, nullValueProvider);
    }

    @Override
    public final void fixAccess(DeserializationConfig deserializationConfig) {
        ClassUtil.checkAndFixAccess(this._field, deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    @Override
    public final <A extends Annotation> A getAnnotation(Class<A> clazz) {
        if (this._annotated == null) {
            return null;
        }
        return ((Annotated)this._annotated).getAnnotation(clazz);
    }

    @Override
    public final AnnotatedMember getMember() {
        return this._annotated;
    }

    @Override
    public final void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        Object object2;
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return;
            }
            object2 = this._nullProvider.getNullValue(deserializationContext);
        } else if (this._valueTypeDeserializer == null) {
            object2 = this._valueDeserializer.deserialize(jsonParser, deserializationContext);
            if (object2 == null) {
                if (this._skipNulls) {
                    return;
                }
                object2 = this._nullProvider.getNullValue(deserializationContext);
            }
        } else {
            object2 = this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
        }
        try {
            this._field.set(object, object2);
            return;
        }
        catch (Exception exception) {
            this._throwAsIOE(jsonParser, exception, object2);
            return;
        }
    }

    @Override
    public final Object deserializeSetAndReturn(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        Object object2;
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return object;
            }
            object2 = this._nullProvider.getNullValue(deserializationContext);
        } else if (this._valueTypeDeserializer == null) {
            object2 = this._valueDeserializer.deserialize(jsonParser, deserializationContext);
            if (object2 == null) {
                if (this._skipNulls) {
                    return object;
                }
                object2 = this._nullProvider.getNullValue(deserializationContext);
            }
        } else {
            object2 = this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
        }
        try {
            this._field.set(object, object2);
        }
        catch (Exception exception) {
            this._throwAsIOE(jsonParser, exception, object2);
        }
        return object;
    }

    @Override
    public final void set(Object object, Object object2) {
        try {
            this._field.set(object, object2);
            return;
        }
        catch (Exception exception) {
            this._throwAsIOE(exception, object2);
            return;
        }
    }

    @Override
    public final Object setAndReturn(Object object, Object object2) {
        try {
            this._field.set(object, object2);
        }
        catch (Exception exception) {
            this._throwAsIOE(exception, object2);
        }
        return object;
    }

    final Object readResolve() {
        return new FieldProperty(this);
    }
}

