/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty$Delegating;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Constructor;

public final class InnerClassProperty
extends SettableBeanProperty$Delegating {
    private static final long serialVersionUID = 1L;
    protected final transient Constructor<?> _creator;
    protected AnnotatedConstructor _annotated;

    public InnerClassProperty(SettableBeanProperty settableBeanProperty, Constructor<?> constructor) {
        super(settableBeanProperty);
        this._creator = constructor;
    }

    protected InnerClassProperty(SettableBeanProperty settableBeanProperty, AnnotatedConstructor annotatedConstructor) {
        super(settableBeanProperty);
        this._annotated = annotatedConstructor;
        Constructor<?> constructor = this._creator = this._annotated == null ? null : this._annotated.getAnnotated();
        if (this._creator == null) {
            throw new IllegalArgumentException("Missing constructor (broken JDK (de)serialization?)");
        }
    }

    @Override
    public final SettableBeanProperty withDelegate(SettableBeanProperty settableBeanProperty) {
        if (settableBeanProperty == this.delegate) {
            return this;
        }
        return new InnerClassProperty(settableBeanProperty, this._creator);
    }

    @Override
    public final void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        Object object2 = jsonParser.currentToken();
        if (object2 == JsonToken.VALUE_NULL) {
            object2 = this._valueDeserializer.getNullValue(deserializationContext);
        } else if (this._valueTypeDeserializer != null) {
            object2 = this._valueDeserializer.deserializeWithType(jsonParser, deserializationContext, this._valueTypeDeserializer);
        } else {
            try {
                object2 = this._creator.newInstance(object);
            }
            catch (Exception exception) {
                object2 = exception;
                ClassUtil.unwrapAndThrowAsIAE(exception, String.format("Failed to instantiate class %s, problem: %s", this._creator.getDeclaringClass().getName(), ((Throwable)object2).getMessage()));
                object2 = null;
            }
            this._valueDeserializer.deserialize(jsonParser, deserializationContext, object2);
        }
        ((SettableBeanProperty)this).set(object, object2);
    }

    @Override
    public final Object deserializeSetAndReturn(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        return ((SettableBeanProperty)this).setAndReturn(object, this.deserialize(jsonParser, deserializationContext));
    }

    final Object readResolve() {
        InnerClassProperty innerClassProperty = this;
        return new InnerClassProperty((SettableBeanProperty)innerClassProperty, innerClassProperty._annotated);
    }

    final Object writeReplace() {
        if (this._annotated == null) {
            return new InnerClassProperty((SettableBeanProperty)this, new AnnotatedConstructor(null, this._creator, null, null));
        }
        return this;
    }
}

