/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyValue;
import com.fasterxml.jackson.databind.deser.impl.PropertyValue$Any;
import com.fasterxml.jackson.databind.deser.impl.PropertyValue$Map;
import com.fasterxml.jackson.databind.deser.impl.PropertyValue$Regular;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import java.util.BitSet;

public class PropertyValueBuffer {
    protected final JsonParser _parser;
    protected final DeserializationContext _context;
    protected final ObjectIdReader _objectIdReader;
    protected final Object[] _creatorParameters;
    protected int _paramsNeeded;
    protected int _paramsSeen;
    protected final BitSet _paramsSeenBig;
    protected PropertyValue _buffered;
    protected Object _idValue;

    public PropertyValueBuffer(JsonParser jsonParser, DeserializationContext deserializationContext, int n2, ObjectIdReader objectIdReader) {
        this._parser = jsonParser;
        this._context = deserializationContext;
        this._paramsNeeded = n2;
        this._objectIdReader = objectIdReader;
        this._creatorParameters = new Object[n2];
        if (n2 < 32) {
            this._paramsSeenBig = null;
            return;
        }
        this._paramsSeenBig = new BitSet();
    }

    public final boolean hasParameter(SettableBeanProperty settableBeanProperty) {
        if (this._paramsSeenBig == null) {
            return (this._paramsSeen >> settableBeanProperty.getCreatorIndex() & 1) == 1;
        }
        return this._paramsSeenBig.get(settableBeanProperty.getCreatorIndex());
    }

    public Object getParameter(SettableBeanProperty settableBeanProperty) {
        Object object;
        if (this.hasParameter(settableBeanProperty)) {
            object = this._creatorParameters[settableBeanProperty.getCreatorIndex()];
        } else {
            Object object2 = this._findMissing(settableBeanProperty);
            this._creatorParameters[settableBeanProperty.getCreatorIndex()] = object2;
            object = object2;
        }
        if (object == null && this._context.isEnabled(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES)) {
            return this._context.reportInputMismatch(settableBeanProperty, "Null value for creator property '%s' (index %d); `DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES` enabled", settableBeanProperty.getName(), settableBeanProperty.getCreatorIndex());
        }
        return object;
    }

    public Object[] getParameters(SettableBeanProperty[] settableBeanPropertyArray) {
        int n2;
        if (this._paramsNeeded > 0) {
            int n3;
            if (this._paramsSeenBig == null) {
                n2 = this._paramsSeen;
                n3 = 0;
                int n4 = this._creatorParameters.length;
                while (n3 < n4) {
                    if ((n2 & 1) == 0) {
                        this._creatorParameters[n3] = this._findMissing(settableBeanPropertyArray[n3]);
                    }
                    ++n3;
                    n2 >>= 1;
                }
            } else {
                n2 = this._creatorParameters.length;
                n3 = 0;
                while ((n3 = this._paramsSeenBig.nextClearBit(n3)) < n2) {
                    this._creatorParameters[n3] = this._findMissing(settableBeanPropertyArray[n3]);
                    ++n3;
                }
            }
        }
        if (this._context.isEnabled(DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES)) {
            for (n2 = 0; n2 < settableBeanPropertyArray.length; ++n2) {
                if (this._creatorParameters[n2] != null) continue;
                SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[n2];
                this._context.reportInputMismatch(settableBeanProperty, "Null value for creator property '%s' (index %d); `DeserializationFeature.FAIL_ON_NULL_CREATOR_PROPERTIES` enabled", settableBeanProperty.getName(), settableBeanPropertyArray[n2].getCreatorIndex());
            }
        }
        return this._creatorParameters;
    }

    protected Object _findMissing(SettableBeanProperty settableBeanProperty) {
        Object object = settableBeanProperty.getInjectableValueId();
        if (object != null) {
            return this._context.findInjectableValue(settableBeanProperty.getInjectableValueId(), settableBeanProperty, null);
        }
        if (settableBeanProperty.isRequired()) {
            this._context.reportInputMismatch(settableBeanProperty, "Missing required creator property '%s' (index %d)", settableBeanProperty.getName(), settableBeanProperty.getCreatorIndex());
        }
        if (this._context.isEnabled(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES)) {
            this._context.reportInputMismatch(settableBeanProperty, "Missing creator property '%s' (index %d); `DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES` enabled", settableBeanProperty.getName(), settableBeanProperty.getCreatorIndex());
        }
        try {
            object = settableBeanProperty.getNullValueProvider().getAbsentValue(this._context);
            if (object != null) {
                return object;
            }
            JsonDeserializer<Object> jsonDeserializer = settableBeanProperty.getValueDeserializer();
            return jsonDeserializer.getAbsentValue(this._context);
        }
        catch (DatabindException databindException) {
            AnnotatedMember annotatedMember = settableBeanProperty.getMember();
            if (annotatedMember != null) {
                databindException.prependPath(annotatedMember.getDeclaringClass(), settableBeanProperty.getName());
            }
            throw databindException;
        }
    }

    public boolean readIdProperty(String string) {
        if (this._objectIdReader != null && string.equals(this._objectIdReader.propertyName.getSimpleName())) {
            this._idValue = this._objectIdReader.readObjectReference(this._parser, this._context);
            return true;
        }
        return false;
    }

    public Object handleIdValue(DeserializationContext object, Object object2) {
        if (this._objectIdReader != null) {
            if (this._idValue != null) {
                object = ((DeserializationContext)object).findObjectId(this._idValue, this._objectIdReader.generator, this._objectIdReader.resolver);
                ((ReadableObjectId)object).bindItem(object2);
                object = this._objectIdReader.idProperty;
                if (object != null) {
                    return ((SettableBeanProperty)object).setAndReturn(object2, this._idValue);
                }
            } else {
                ((DeserializationContext)object).reportUnresolvedObjectId(this._objectIdReader, object2);
            }
        }
        return object2;
    }

    protected PropertyValue buffered() {
        return this._buffered;
    }

    public boolean isComplete() {
        return this._paramsNeeded <= 0;
    }

    public boolean assignParameter(SettableBeanProperty settableBeanProperty, Object object) {
        int n2 = settableBeanProperty.getCreatorIndex();
        this._creatorParameters[n2] = object;
        if (this._paramsSeenBig == null) {
            int n3 = this._paramsSeen;
            if (n3 != (n2 = n3 | 1 << n2)) {
                this._paramsSeen = n2;
                if (--this._paramsNeeded <= 0) {
                    return this._objectIdReader == null || this._idValue != null;
                }
            }
        } else if (!this._paramsSeenBig.get(n2)) {
            this._paramsSeenBig.set(n2);
            --this._paramsNeeded;
        }
        return false;
    }

    public void bufferProperty(SettableBeanProperty settableBeanProperty, Object object) {
        this._buffered = new PropertyValue$Regular(this._buffered, object, settableBeanProperty);
    }

    public void bufferAnyProperty(SettableAnyProperty settableAnyProperty, String string, Object object) {
        this._buffered = new PropertyValue$Any(this._buffered, object, settableAnyProperty, string);
    }

    public void bufferMapProperty(Object object, Object object2) {
        this._buffered = new PropertyValue$Map(this._buffered, object2, object);
    }
}

