/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.Annotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public final class SetterlessProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedMethod _annotated;
    protected final Method _getter;

    public SetterlessProperty(BeanPropertyDefinition beanPropertyDefinition, JavaType javaType, TypeDeserializer typeDeserializer, Annotations annotations, AnnotatedMethod annotatedMethod) {
        super(beanPropertyDefinition, javaType, typeDeserializer, annotations);
        this._annotated = annotatedMethod;
        this._getter = annotatedMethod.getAnnotated();
    }

    protected SetterlessProperty(SetterlessProperty setterlessProperty, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider) {
        super(setterlessProperty, jsonDeserializer, nullValueProvider);
        this._annotated = setterlessProperty._annotated;
        this._getter = setterlessProperty._getter;
    }

    protected SetterlessProperty(SetterlessProperty setterlessProperty, PropertyName propertyName) {
        super(setterlessProperty, propertyName);
        this._annotated = setterlessProperty._annotated;
        this._getter = setterlessProperty._getter;
    }

    @Override
    public final SettableBeanProperty withName(PropertyName propertyName) {
        return new SetterlessProperty(this, propertyName);
    }

    @Override
    public final SettableBeanProperty withValueDeserializer(JsonDeserializer<?> jsonDeserializer) {
        if (this._valueDeserializer == jsonDeserializer) {
            return this;
        }
        NullValueProvider nullValueProvider = this._valueDeserializer == this._nullProvider ? jsonDeserializer : this._nullProvider;
        return new SetterlessProperty(this, jsonDeserializer, nullValueProvider);
    }

    @Override
    public final SettableBeanProperty withNullProvider(NullValueProvider nullValueProvider) {
        SetterlessProperty setterlessProperty = this;
        return new SetterlessProperty(setterlessProperty, setterlessProperty._valueDeserializer, nullValueProvider);
    }

    @Override
    public final void fixAccess(DeserializationConfig deserializationConfig) {
        this._annotated.fixAccess(deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    @Override
    public final <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return ((Annotated)this._annotated).getAnnotation(clazz);
    }

    @Override
    public final AnnotatedMember getMember() {
        return this._annotated;
    }

    @Override
    public final void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            return;
        }
        if (this._valueTypeDeserializer != null) {
            ((DatabindContext)deserializationContext).reportBadDefinition(this.getType(), String.format("Problem deserializing 'setterless' property (\"%s\"): no way to handle typed deser with setterless yet", this.getName()));
        }
        try {
            object = this._getter.invoke(object, null);
        }
        catch (Exception exception) {
            this._throwAsIOE(jsonParser, exception);
            return;
        }
        if (object == null) {
            ((DatabindContext)deserializationContext).reportBadDefinition(this.getType(), String.format("Problem deserializing 'setterless' property '%s': get method returned null", this.getName()));
        }
        this._valueDeserializer.deserialize(jsonParser, deserializationContext, object);
    }

    @Override
    public final Object deserializeSetAndReturn(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        ((SettableBeanProperty)this).deserializeAndSet(jsonParser, deserializationContext, object);
        return object;
    }

    @Override
    public final void set(Object object, Object object2) {
        throw new UnsupportedOperationException("Should never call `set()` on setterless property ('" + this.getName() + "')");
    }

    @Override
    public final Object setAndReturn(Object object, Object object2) {
        ((SettableBeanProperty)this).set(object, object2);
        return object;
    }
}

