/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.Serializable;
import java.util.Collection;

public final class TypeWrappedDeserializer
extends JsonDeserializer<Object>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final TypeDeserializer _typeDeserializer;
    protected final JsonDeserializer<Object> _deserializer;

    public TypeWrappedDeserializer(TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        this._typeDeserializer = typeDeserializer;
        this._deserializer = jsonDeserializer;
    }

    @Override
    public final LogicalType logicalType() {
        return this._deserializer.logicalType();
    }

    @Override
    public final Class<?> handledType() {
        return this._deserializer.handledType();
    }

    @Override
    public final Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return this._deserializer.supportsUpdate(deserializationConfig);
    }

    @Override
    public final JsonDeserializer<?> getDelegatee() {
        return this._deserializer.getDelegatee();
    }

    @Override
    public final Collection<Object> getKnownPropertyNames() {
        return this._deserializer.getKnownPropertyNames();
    }

    @Override
    public final Object getNullValue(DeserializationContext deserializationContext) {
        return this._deserializer.getNullValue(deserializationContext);
    }

    @Override
    public final Object getEmptyValue(DeserializationContext deserializationContext) {
        return this._deserializer.getEmptyValue(deserializationContext);
    }

    @Override
    public final Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        return this._deserializer.deserializeWithType(jsonParser, deserializationContext, this._typeDeserializer);
    }

    @Override
    public final Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        throw new IllegalStateException("Type-wrapped deserializer's deserializeWithType should never get called");
    }

    @Override
    public final Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        return this._deserializer.deserialize(jsonParser, deserializationContext, object);
    }
}

