/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonParser$NumberType;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.BaseNodeDeserializer$ContainerStack;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.RawValue;

abstract class BaseNodeDeserializer<T extends JsonNode>
extends StdDeserializer<T> {
    protected final Boolean _supportsUpdates;

    public BaseNodeDeserializer(Class<T> clazz, Boolean bl) {
        super(clazz);
        this._supportsUpdates = bl;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Untyped;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return this._supportsUpdates;
    }

    protected void _handleDuplicateField(JsonParser object, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory, String string, ObjectNode objectNode, JsonNode jsonNode, JsonNode jsonNode2) {
        if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY)) {
            deserializationContext.reportInputMismatch(JsonNode.class, "Duplicate field '%s' for `ObjectNode`: not allowed when `DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY` enabled", string);
        }
        if (deserializationContext.isEnabled(StreamReadCapability.DUPLICATE_PROPERTIES)) {
            if (jsonNode.isArray()) {
                ((ArrayNode)jsonNode).add(jsonNode2);
                objectNode.replace(string, jsonNode);
                return;
            }
            object = jsonNodeFactory.arrayNode();
            ((ArrayNode)object).add(jsonNode);
            ((ArrayNode)object).add(jsonNode2);
            objectNode.replace(string, (JsonNode)object);
        }
    }

    protected final ObjectNode _deserializeObjectAtName(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory, BaseNodeDeserializer$ContainerStack baseNodeDeserializer$ContainerStack) {
        ObjectNode objectNode = jsonNodeFactory.objectNode();
        String string = jsonParser.currentName();
        while (string != null) {
            Object object = jsonParser.nextToken();
            if (object == null) {
                object = JsonToken.NOT_AVAILABLE;
            }
            switch (object.id()) {
                case 1: {
                    object = this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, baseNodeDeserializer$ContainerStack, jsonNodeFactory.objectNode());
                    break;
                }
                case 3: {
                    object = this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, baseNodeDeserializer$ContainerStack, jsonNodeFactory.arrayNode());
                    break;
                }
                default: {
                    object = this._deserializeAnyScalar(jsonParser, deserializationContext);
                }
            }
            JsonNode jsonNode = objectNode.replace(string, (JsonNode)object);
            if (jsonNode != null) {
                this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, string, objectNode, jsonNode, (JsonNode)object);
            }
            string = jsonParser.nextFieldName();
        }
        return objectNode;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected final JsonNode updateObject(JsonParser var1_1, DeserializationContext var2_2, ObjectNode var3_3, BaseNodeDeserializer$ContainerStack var4_4) {
        if (var1_1.isExpectedStartObjectToken()) {
            var5_5 = var1_1.nextFieldName();
        } else {
            if (!var1_1.hasToken(JsonToken.FIELD_NAME)) {
                return (JsonNode)this.deserialize(var1_1, var2_2);
            }
            var5_5 = var1_1.currentName();
        }
        var6_6 = var2_2.getNodeFactory();
        while (var5_5 != null) {
            block18: {
                block17: {
                    var7_7 /* !! */  = var1_1.nextToken();
                    var8_8 = var3_3.get(var5_5);
                    if (var8_8 == null) ** GOTO lbl-1000
                    if (!(var8_8 instanceof ObjectNode)) break block17;
                    if (var7_7 /* !! */  != JsonToken.START_OBJECT) ** GOTO lbl-1000
                    var7_7 /* !! */  = this.updateObject(var1_1, var2_2, (ObjectNode)var8_8, var4_4);
                    if (var7_7 /* !! */  != var8_8) {
                        var3_3.set(var5_5, (JsonNode)var7_7 /* !! */ );
                    }
                    break block18;
                }
                if (var8_8 instanceof ArrayNode && var7_7 /* !! */  == JsonToken.START_ARRAY) {
                    this._deserializeContainerNoRecursion(var1_1, var2_2, var6_6, var4_4, (ArrayNode)var8_8);
                } else lbl-1000:
                // 3 sources

                {
                    if (var7_7 /* !! */  == null) {
                        var7_7 /* !! */  = JsonToken.NOT_AVAILABLE;
                    }
                    switch (var7_7 /* !! */ .id()) {
                        case 1: {
                            var7_7 /* !! */  = this._deserializeContainerNoRecursion(var1_1, var2_2, var6_6, var4_4, var6_6.objectNode());
                            break;
                        }
                        case 3: {
                            var7_7 /* !! */  = this._deserializeContainerNoRecursion(var1_1, var2_2, var6_6, var4_4, var6_6.arrayNode());
                            break;
                        }
                        case 6: {
                            var7_7 /* !! */  = var6_6.textNode(var1_1.getText());
                            break;
                        }
                        case 7: {
                            var7_7 /* !! */  = this._fromInt(var1_1, var2_2, var6_6);
                            break;
                        }
                        case 9: {
                            var7_7 /* !! */  = var6_6.booleanNode(true);
                            break;
                        }
                        case 10: {
                            var7_7 /* !! */  = var6_6.booleanNode(false);
                            break;
                        }
                        case 11: {
                            var7_7 /* !! */  = var6_6.nullNode();
                            break;
                        }
                        default: {
                            var7_7 /* !! */  = this._deserializeRareScalar(var1_1, var2_2);
                        }
                    }
                    var3_3.set(var5_5, (JsonNode)var7_7 /* !! */ );
                }
            }
            var5_5 = var1_1.nextFieldName();
        }
        return var3_3;
    }

    protected final ContainerNode<?> _deserializeContainerNoRecursion(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory, BaseNodeDeserializer$ContainerStack baseNodeDeserializer$ContainerStack, ContainerNode<?> containerNode) {
        ContainerNode containerNode2 = containerNode;
        int n2 = deserializationContext.getDeserializationFeatures() & F_MASK_INT_COERCIONS;
        block21: do {
            block31: {
                Object object;
                ContainerNode containerNode3;
                block29: {
                    if (!(containerNode2 instanceof ObjectNode)) break block29;
                    containerNode3 = (ObjectNode)containerNode2;
                    object = jsonParser.nextFieldName();
                    while (object != null) {
                        block30: {
                            JsonNode jsonNode;
                            Object object2 = jsonParser.nextToken();
                            if (object2 == null) {
                                object2 = JsonToken.NOT_AVAILABLE;
                            }
                            switch (object2.id()) {
                                case 1: {
                                    jsonNode = jsonNodeFactory.objectNode();
                                    object2 = ((ObjectNode)containerNode3).replace((String)object, jsonNode);
                                    if (object2 != null) {
                                        this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, (String)object, (ObjectNode)containerNode3, (JsonNode)object2, jsonNode);
                                    }
                                    baseNodeDeserializer$ContainerStack.push(containerNode2);
                                    containerNode2 = containerNode3 = jsonNode;
                                    break block30;
                                }
                                case 3: {
                                    jsonNode = jsonNodeFactory.arrayNode();
                                    object2 = ((ObjectNode)containerNode3).replace((String)object, jsonNode);
                                    if (object2 != null) {
                                        this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, (String)object, (ObjectNode)containerNode3, (JsonNode)object2, jsonNode);
                                    }
                                    baseNodeDeserializer$ContainerStack.push(containerNode2);
                                    containerNode2 = jsonNode;
                                    continue block21;
                                }
                                case 6: {
                                    object2 = jsonNodeFactory.textNode(jsonParser.getText());
                                    break;
                                }
                                case 7: {
                                    object2 = this._fromInt(jsonParser, n2, jsonNodeFactory);
                                    break;
                                }
                                case 8: {
                                    object2 = this._fromFloat(jsonParser, deserializationContext, jsonNodeFactory);
                                    break;
                                }
                                case 9: {
                                    object2 = jsonNodeFactory.booleanNode(true);
                                    break;
                                }
                                case 10: {
                                    object2 = jsonNodeFactory.booleanNode(false);
                                    break;
                                }
                                case 11: {
                                    object2 = jsonNodeFactory.nullNode();
                                    break;
                                }
                                default: {
                                    object2 = this._deserializeRareScalar(jsonParser, deserializationContext);
                                }
                            }
                            jsonNode = ((ObjectNode)containerNode3).replace((String)object, (JsonNode)object2);
                            if (jsonNode != null) {
                                this._handleDuplicateField(jsonParser, deserializationContext, jsonNodeFactory, (String)object, (ObjectNode)containerNode3, jsonNode, (JsonNode)object2);
                            }
                        }
                        object = jsonParser.nextFieldName();
                    }
                    break block31;
                }
                containerNode3 = (ArrayNode)containerNode2;
                block23: while (true) {
                    if ((object = jsonParser.nextToken()) == null) {
                        object = JsonToken.NOT_AVAILABLE;
                    }
                    switch (((JsonToken)((Object)object)).id()) {
                        case 1: {
                            baseNodeDeserializer$ContainerStack.push(containerNode2);
                            containerNode2 = jsonNodeFactory.objectNode();
                            ((ArrayNode)containerNode3).add(containerNode2);
                            continue block21;
                        }
                        case 3: {
                            baseNodeDeserializer$ContainerStack.push(containerNode2);
                            containerNode2 = jsonNodeFactory.arrayNode();
                            ((ArrayNode)containerNode3).add(containerNode2);
                            continue block21;
                        }
                        case 4: {
                            break block23;
                        }
                        case 6: {
                            ((ArrayNode)containerNode3).add(jsonNodeFactory.textNode(jsonParser.getText()));
                            continue block23;
                        }
                        case 7: {
                            ((ArrayNode)containerNode3).add(this._fromInt(jsonParser, n2, jsonNodeFactory));
                            continue block23;
                        }
                        case 8: {
                            ((ArrayNode)containerNode3).add(this._fromFloat(jsonParser, deserializationContext, jsonNodeFactory));
                            continue block23;
                        }
                        case 9: {
                            ((ArrayNode)containerNode3).add(jsonNodeFactory.booleanNode(true));
                            continue block23;
                        }
                        case 10: {
                            ((ArrayNode)containerNode3).add(jsonNodeFactory.booleanNode(false));
                            continue block23;
                        }
                        case 11: {
                            ((ArrayNode)containerNode3).add(jsonNodeFactory.nullNode());
                            continue block23;
                        }
                        default: {
                            ((ArrayNode)containerNode3).add(this._deserializeRareScalar(jsonParser, deserializationContext));
                            continue block23;
                        }
                    }
                    break;
                }
            }
            containerNode2 = baseNodeDeserializer$ContainerStack.popOrNull();
        } while (containerNode2 != null);
        return containerNode;
    }

    protected final JsonNode _deserializeAnyScalar(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonNodeFactory jsonNodeFactory = deserializationContext.getNodeFactory();
        switch (jsonParser.currentTokenId()) {
            case 2: {
                return jsonNodeFactory.objectNode();
            }
            case 6: {
                return jsonNodeFactory.textNode(jsonParser.getText());
            }
            case 7: {
                return this._fromInt(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case 8: {
                return this._fromFloat(jsonParser, deserializationContext, jsonNodeFactory);
            }
            case 9: {
                return jsonNodeFactory.booleanNode(true);
            }
            case 10: {
                return jsonNodeFactory.booleanNode(false);
            }
            case 11: {
                return jsonNodeFactory.nullNode();
            }
            case 12: {
                return this._fromEmbedded(jsonParser, deserializationContext);
            }
        }
        return (JsonNode)deserializationContext.handleUnexpectedToken(((JsonDeserializer)this).handledType(), jsonParser);
    }

    protected final JsonNode _deserializeRareScalar(JsonParser jsonParser, DeserializationContext deserializationContext) {
        switch (jsonParser.currentTokenId()) {
            case 2: {
                return deserializationContext.getNodeFactory().objectNode();
            }
            case 8: {
                DeserializationContext deserializationContext2 = deserializationContext;
                return this._fromFloat(jsonParser, deserializationContext2, deserializationContext2.getNodeFactory());
            }
            case 12: {
                return this._fromEmbedded(jsonParser, deserializationContext);
            }
        }
        return (JsonNode)deserializationContext.handleUnexpectedToken(((JsonDeserializer)this).handledType(), jsonParser);
    }

    protected final JsonNode _fromInt(JsonParser jsonParser, int n2, JsonNodeFactory jsonNodeFactory) {
        if (n2 != 0) {
            if (DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.enabledIn(n2)) {
                return jsonNodeFactory.numberNode(jsonParser.getBigIntegerValue());
            }
            return jsonNodeFactory.numberNode(jsonParser.getLongValue());
        }
        JsonParser$NumberType jsonParser$NumberType = jsonParser.getNumberType();
        if (jsonParser$NumberType == JsonParser$NumberType.INT) {
            return jsonNodeFactory.numberNode(jsonParser.getIntValue());
        }
        if (jsonParser$NumberType == JsonParser$NumberType.LONG) {
            return jsonNodeFactory.numberNode(jsonParser.getLongValue());
        }
        return jsonNodeFactory.numberNode(jsonParser.getBigIntegerValue());
    }

    protected final JsonNode _fromInt(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) {
        int n2 = deserializationContext.getDeserializationFeatures();
        JsonParser$NumberType jsonParser$NumberType = (n2 & F_MASK_INT_COERCIONS) != 0 ? (DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.enabledIn(n2) ? JsonParser$NumberType.BIG_INTEGER : (DeserializationFeature.USE_LONG_FOR_INTS.enabledIn(n2) ? JsonParser$NumberType.LONG : jsonParser.getNumberType())) : jsonParser.getNumberType();
        if (jsonParser$NumberType == JsonParser$NumberType.INT) {
            return jsonNodeFactory.numberNode(jsonParser.getIntValue());
        }
        if (jsonParser$NumberType == JsonParser$NumberType.LONG) {
            return jsonNodeFactory.numberNode(jsonParser.getLongValue());
        }
        return jsonNodeFactory.numberNode(jsonParser.getBigIntegerValue());
    }

    protected final JsonNode _fromFloat(JsonParser jsonParser, DeserializationContext deserializationContext, JsonNodeFactory jsonNodeFactory) {
        JsonParser$NumberType jsonParser$NumberType = jsonParser.getNumberType();
        if (jsonParser$NumberType == JsonParser$NumberType.BIG_DECIMAL) {
            return jsonNodeFactory.numberNode(jsonParser.getDecimalValue());
        }
        if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            if (jsonParser.isNaN()) {
                return jsonNodeFactory.numberNode(jsonParser.getDoubleValue());
            }
            return jsonNodeFactory.numberNode(jsonParser.getDecimalValue());
        }
        if (jsonParser$NumberType == JsonParser$NumberType.FLOAT) {
            return jsonNodeFactory.numberNode(jsonParser.getFloatValue());
        }
        return jsonNodeFactory.numberNode(jsonParser.getDoubleValue());
    }

    protected final JsonNode _fromEmbedded(JsonParser object, DeserializationContext serializable) {
        serializable = ((DeserializationContext)serializable).getNodeFactory();
        if ((object = ((JsonParser)object).getEmbeddedObject()) == null) {
            return ((JsonNodeFactory)serializable).nullNode();
        }
        Class<?> clazz = object.getClass();
        if (clazz == byte[].class) {
            return ((JsonNodeFactory)serializable).binaryNode((byte[])object);
        }
        if (object instanceof RawValue) {
            return ((JsonNodeFactory)serializable).rawValueNode((RawValue)object);
        }
        if (object instanceof JsonNode) {
            return (JsonNode)object;
        }
        return ((JsonNodeFactory)serializable).pojoNode(object);
    }
}

