/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.ValueInstantiator$Gettable;
import com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.AccessPattern;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public abstract class ContainerDeserializerBase<T>
extends StdDeserializer<T>
implements ValueInstantiator$Gettable {
    protected final JavaType _containerType;
    protected final NullValueProvider _nullProvider;
    protected final boolean _skipNullValues;
    protected final Boolean _unwrapSingle;

    protected ContainerDeserializerBase(JavaType javaType, NullValueProvider nullValueProvider, Boolean bl) {
        super(javaType);
        this._containerType = javaType;
        this._unwrapSingle = bl;
        this._nullProvider = nullValueProvider;
        this._skipNullValues = NullsConstantProvider.isSkipper(nullValueProvider);
    }

    protected ContainerDeserializerBase(JavaType javaType) {
        this(javaType, null, null);
    }

    protected ContainerDeserializerBase(ContainerDeserializerBase<?> containerDeserializerBase) {
        ContainerDeserializerBase<?> containerDeserializerBase2 = containerDeserializerBase;
        this(containerDeserializerBase2, containerDeserializerBase2._nullProvider, containerDeserializerBase._unwrapSingle);
    }

    protected ContainerDeserializerBase(ContainerDeserializerBase<?> containerDeserializerBase, NullValueProvider nullValueProvider, Boolean bl) {
        super(containerDeserializerBase._containerType);
        this._containerType = containerDeserializerBase._containerType;
        this._nullProvider = nullValueProvider;
        this._unwrapSingle = bl;
        this._skipNullValues = NullsConstantProvider.isSkipper(nullValueProvider);
    }

    @Override
    public JavaType getValueType() {
        return this._containerType;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.TRUE;
    }

    @Override
    public SettableBeanProperty findBackReference(String string) {
        JsonDeserializer<Object> jsonDeserializer = this.getContentDeserializer();
        if (jsonDeserializer == null) {
            throw new IllegalArgumentException(String.format("Cannot handle managed/back reference '%s': type: container deserializer of type %s returned null for 'getContentDeserializer()'", string, this.getClass().getName()));
        }
        return jsonDeserializer.findBackReference(string);
    }

    public JavaType getContentType() {
        if (this._containerType == null) {
            return TypeFactory.unknownType();
        }
        return this._containerType.getContentType();
    }

    public abstract JsonDeserializer<Object> getContentDeserializer();

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.DYNAMIC;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        ValueInstantiator valueInstantiator = this.getValueInstantiator();
        if (valueInstantiator == null || !valueInstantiator.canCreateUsingDefault()) {
            JavaType javaType = ((StdDeserializer)this).getValueType();
            ((DatabindContext)deserializationContext).reportBadDefinition(javaType, String.format("Cannot create empty instance of %s, no default Creator", javaType));
        }
        try {
            return valueInstantiator.createUsingDefault(deserializationContext);
        }
        catch (IOException iOException) {
            return ClassUtil.throwAsMappingException(deserializationContext, iOException);
        }
    }

    @Deprecated
    protected <BOGUS> BOGUS wrapAndThrow(Throwable throwable, Object object, String string) {
        return this.wrapAndThrow(null, throwable, object, string);
    }

    protected <BOGUS> BOGUS wrapAndThrow(DeserializationContext deserializationContext, Throwable throwable, Object object, String string) {
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        ClassUtil.throwIfError(throwable);
        if (deserializationContext != null && !deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS)) {
            ClassUtil.throwIfRTE(throwable);
        }
        if (throwable instanceof IOException && !(throwable instanceof JsonMappingException)) {
            throw (IOException)throwable;
        }
        throw JsonMappingException.wrapWithPath(throwable, object, ClassUtil.nonNull(string, "N/A"));
    }
}

