/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat$Feature;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.EnumDeserializer$1;
import com.fasterxml.jackson.databind.deser.std.FactoryBasedEnumDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.CompactStringObjectMap;
import com.fasterxml.jackson.databind.util.EnumResolver;
import java.util.Objects;

@JacksonStdImpl
public class EnumDeserializer
extends StdScalarDeserializer<Object>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected Object[] _enumsByIndex;
    private final Enum<?> _enumDefaultValue;
    protected final CompactStringObjectMap _lookupByName;
    protected CompactStringObjectMap _lookupByToString;
    protected final Boolean _caseInsensitive;
    protected final boolean _isFromIntValue;

    public EnumDeserializer(EnumResolver enumResolver, Boolean bl) {
        super(enumResolver.getEnumClass());
        this._lookupByName = enumResolver.constructLookup();
        this._enumsByIndex = enumResolver.getRawEnums();
        this._enumDefaultValue = enumResolver.getDefaultValue();
        this._caseInsensitive = bl;
        this._isFromIntValue = enumResolver.isFromIntValue();
    }

    protected EnumDeserializer(EnumDeserializer enumDeserializer, Boolean bl) {
        super(enumDeserializer);
        this._lookupByName = enumDeserializer._lookupByName;
        this._enumsByIndex = enumDeserializer._enumsByIndex;
        this._enumDefaultValue = enumDeserializer._enumDefaultValue;
        this._caseInsensitive = bl;
        this._isFromIntValue = enumDeserializer._isFromIntValue;
    }

    @Deprecated
    public EnumDeserializer(EnumResolver enumResolver) {
        this(enumResolver, null);
    }

    @Deprecated
    public static JsonDeserializer<?> deserializerForCreator(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedMethod annotatedMethod) {
        return EnumDeserializer.deserializerForCreator(deserializationConfig, clazz, annotatedMethod, null, null);
    }

    public static JsonDeserializer<?> deserializerForCreator(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedMethod annotatedMethod, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray) {
        if (deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        AnnotatedMethod annotatedMethod2 = annotatedMethod;
        return new FactoryBasedEnumDeserializer(clazz, annotatedMethod2, ((AnnotatedWithParams)annotatedMethod2).getParameterType(0), valueInstantiator, settableBeanPropertyArray);
    }

    public static JsonDeserializer<?> deserializerForNoArgsCreator(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedMethod annotatedMethod) {
        if (deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(annotatedMethod.getMember(), deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        return new FactoryBasedEnumDeserializer(clazz, annotatedMethod);
    }

    public EnumDeserializer withResolved(Boolean bl) {
        if (Objects.equals(this._caseInsensitive, bl)) {
            return this;
        }
        return new EnumDeserializer(this, bl);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext serializable, BeanProperty beanProperty) {
        if ((serializable = this.findFormatFeature((DeserializationContext)serializable, beanProperty, ((JsonDeserializer)this).handledType(), JsonFormat$Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES)) == null) {
            serializable = this._caseInsensitive;
        }
        return this.withResolved((Boolean)serializable);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Enum;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return this._enumDefaultValue;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
        }
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            if (this._isFromIntValue) {
                return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
            }
            return this._fromInteger(jsonParser, deserializationContext, jsonParser.getIntValue());
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            DeserializationContext deserializationContext2 = deserializationContext;
            EnumDeserializer enumDeserializer = this;
            return this._fromString(jsonParser, deserializationContext2, deserializationContext2.extractScalarFromObject(jsonParser, enumDeserializer, enumDeserializer._valueClass));
        }
        return this._deserializeOther(jsonParser, deserializationContext);
    }

    protected Object _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) {
        String string2;
        CompactStringObjectMap compactStringObjectMap = deserializationContext.isEnabled(DeserializationFeature.READ_ENUMS_USING_TO_STRING) ? this._getToStringLookup(deserializationContext) : this._lookupByName;
        Object object = compactStringObjectMap.find(string);
        if (object == null && ((string2 = string.trim()) == string || (object = compactStringObjectMap.find(string2)) == null)) {
            return this._deserializeAltString(jsonParser, deserializationContext, compactStringObjectMap, string2);
        }
        return object;
    }

    protected Object _fromInteger(JsonParser object, DeserializationContext deserializationContext, int n2) {
        object = deserializationContext.findCoercionAction(((JsonDeserializer)this).logicalType(), ((JsonDeserializer)this).handledType(), CoercionInputShape.Integer);
        if (object == CoercionAction.Fail) {
            if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS)) {
                return deserializationContext.handleWeirdNumberValue(this._enumClass(), n2, "not allowed to deserialize Enum value out of number: disable DeserializationConfig.DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS to allow", new Object[0]);
            }
            this._checkCoercionFail(deserializationContext, (CoercionAction)((Object)object), ((JsonDeserializer)this).handledType(), n2, "Integer value (" + n2 + ")");
        }
        switch (EnumDeserializer$1.$SwitchMap$com$fasterxml$jackson$databind$cfg$CoercionAction[((Enum)object).ordinal()]) {
            case 1: {
                return null;
            }
            case 2: {
                return ((JsonDeserializer)this).getEmptyValue(deserializationContext);
            }
        }
        if (n2 >= 0 && n2 < this._enumsByIndex.length) {
            return this._enumsByIndex[n2];
        }
        if (this._enumDefaultValue != null && deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE)) {
            return this._enumDefaultValue;
        }
        if (!deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
            return deserializationContext.handleWeirdNumberValue(this._enumClass(), n2, "index value outside legal index range [0..%s]", this._enumsByIndex.length - 1);
        }
        return null;
    }

    private final Object _deserializeAltString(JsonParser object, DeserializationContext deserializationContext, CompactStringObjectMap compactStringObjectMap, String string) {
        char c2;
        object = string.trim();
        if (((String)object).isEmpty()) {
            CoercionAction coercionAction;
            if (this._enumDefaultValue != null && deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE)) {
                return this._enumDefaultValue;
            }
            if (deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                return null;
            }
            if (string.isEmpty()) {
                coercionAction = this._findCoercionFromEmptyString(deserializationContext);
                coercionAction = this._checkCoercionFail(deserializationContext, coercionAction, ((JsonDeserializer)this).handledType(), string, "empty String (\"\")");
            } else {
                coercionAction = this._findCoercionFromBlankString(deserializationContext);
                coercionAction = this._checkCoercionFail(deserializationContext, coercionAction, ((JsonDeserializer)this).handledType(), string, "blank String (all whitespace)");
            }
            switch (coercionAction) {
                case AsEmpty: 
                case TryConvert: {
                    return ((JsonDeserializer)this).getEmptyValue(deserializationContext);
                }
            }
            return null;
        }
        if (Boolean.TRUE.equals(this._caseInsensitive)) {
            Object object2 = compactStringObjectMap.findCaseInsensitive((String)object);
            if (object2 != null) {
                return object2;
            }
        } else if (!deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS) && !this._isFromIntValue && (c2 = ((String)object).charAt(0)) >= '0' && c2 <= '9') {
            try {
                int n2 = Integer.parseInt((String)object);
                if (!((DatabindContext)deserializationContext).isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
                    return deserializationContext.handleWeirdStringValue(this._enumClass(), (String)object, "value looks like quoted Enum index, but `MapperFeature.ALLOW_COERCION_OF_SCALARS` prevents use", new Object[0]);
                }
                if (n2 >= 0 && n2 < this._enumsByIndex.length) {
                    return this._enumsByIndex[n2];
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this._enumDefaultValue != null && deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE)) {
            return this._enumDefaultValue;
        }
        if (deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
            return null;
        }
        return deserializationContext.handleWeirdStringValue(this._enumClass(), (String)object, "not one of the values accepted for Enum class: %s", compactStringObjectMap.keys());
    }

    protected Object _deserializeOther(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.hasToken(JsonToken.START_ARRAY)) {
            return this._deserializeFromArray(jsonParser, deserializationContext);
        }
        return deserializationContext.handleUnexpectedToken(this._enumClass(), jsonParser);
    }

    protected Class<?> _enumClass() {
        return ((JsonDeserializer)this).handledType();
    }

    protected CompactStringObjectMap _getToStringLookup(DeserializationContext deserializationContext) {
        CompactStringObjectMap compactStringObjectMap = this._lookupByToString;
        if (compactStringObjectMap == null) {
            EnumDeserializer enumDeserializer = this;
            synchronized (enumDeserializer) {
                compactStringObjectMap = EnumResolver.constructUsingToString(deserializationContext.getConfig(), this._enumClass()).constructLookup();
            }
            this._lookupByToString = compactStringObjectMap;
        }
        return compactStringObjectMap;
    }
}

