/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class FromStringDeserializer$Std
extends FromStringDeserializer<Object> {
    private static final long serialVersionUID = 1L;
    public static final int STD_FILE = 1;
    public static final int STD_URL = 2;
    public static final int STD_URI = 3;
    public static final int STD_CLASS = 4;
    public static final int STD_JAVA_TYPE = 5;
    public static final int STD_CURRENCY = 6;
    public static final int STD_PATTERN = 7;
    public static final int STD_LOCALE = 8;
    public static final int STD_CHARSET = 9;
    public static final int STD_TIME_ZONE = 10;
    public static final int STD_INET_ADDRESS = 11;
    public static final int STD_INET_SOCKET_ADDRESS = 12;
    protected static final String LOCALE_EXT_MARKER = "_#";
    protected final int _kind;

    protected FromStringDeserializer$Std(Class<?> clazz, int n2) {
        super(clazz);
        this._kind = n2;
    }

    @Override
    protected Object _deserialize(String string, DeserializationContext deserializationContext) {
        switch (this._kind) {
            case 1: {
                return new File(string);
            }
            case 2: {
                return new URL(string);
            }
            case 3: {
                return URI.create(string);
            }
            case 4: {
                try {
                    return deserializationContext.findClass(string);
                }
                catch (Exception exception) {
                    return deserializationContext.handleInstantiationProblem(this._valueClass, string, ClassUtil.getRootCause(exception));
                }
            }
            case 5: {
                return ((DatabindContext)deserializationContext).getTypeFactory().constructFromCanonical(string);
            }
            case 6: {
                return Currency.getInstance(string);
            }
            case 7: {
                return Pattern.compile(string);
            }
            case 8: {
                return this._deserializeLocale(string, deserializationContext);
            }
            case 9: {
                return Charset.forName(string);
            }
            case 10: {
                return TimeZone.getTimeZone(string);
            }
            case 11: {
                return InetAddress.getByName(string);
            }
            case 12: {
                if (string.startsWith("[")) {
                    int n2 = string.lastIndexOf(93);
                    if (n2 == -1) {
                        throw new InvalidFormatException(deserializationContext.getParser(), "Bracketed IPv6 address must contain closing bracket", (Object)string, InetSocketAddress.class);
                    }
                    int n3 = string.indexOf(58, n2);
                    n3 = n3 >= 0 ? Integer.parseInt(string.substring(n3 + 1)) : 0;
                    return new InetSocketAddress(string.substring(0, n2 + 1), n3);
                }
                int n4 = string.indexOf(58);
                if (n4 >= 0 && string.indexOf(58, n4 + 1) < 0) {
                    int n5 = Integer.parseInt(string.substring(n4 + 1));
                    return new InetSocketAddress(string.substring(0, n4), n5);
                }
                return new InetSocketAddress(string, 0);
            }
        }
        VersionUtil.throwInternal();
        return null;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        switch (this._kind) {
            case 3: {
                return URI.create("");
            }
            case 8: {
                return Locale.ROOT;
            }
        }
        return super.getEmptyValue(deserializationContext);
    }

    @Override
    protected Object _deserializeFromEmptyStringDefault(DeserializationContext deserializationContext) {
        return ((JsonDeserializer)this).getEmptyValue(deserializationContext);
    }

    @Override
    protected boolean _shouldTrim() {
        return this._kind != 7;
    }

    protected int _firstHyphenOrUnderscore(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '_' && c2 != '-') continue;
            return i2;
        }
        return -1;
    }

    private Locale _deserializeLocale(String string, DeserializationContext deserializationContext) {
        int n2 = this._firstHyphenOrUnderscore(string);
        if (n2 < 0) {
            return new Locale(string);
        }
        String string2 = string.substring(0, n2);
        if ((n2 = this._firstHyphenOrUnderscore(string = string.substring(n2 + 1))) < 0) {
            return new Locale(string2, string);
        }
        String string3 = string.substring(0, n2);
        int n3 = string.indexOf(LOCALE_EXT_MARKER);
        if (n3 < 0) {
            return new Locale(string2, string3, string.substring(n2 + 1));
        }
        return this._deSerializeBCP47Locale(string, n2, string2, string3, n3);
    }

    private Locale _deSerializeBCP47Locale(String string, int n2, String string2, String string3, int n3) {
        String string4 = "";
        try {
            if (n3 > 0 && n3 > n2) {
                string4 = string.substring(n2 + 1, n3);
            }
            if ((string = string.substring(n3 + 2)).indexOf(95) < 0 && string.indexOf(45) < 0) {
                return new Locale.Builder().setLanguage(string2).setRegion(string3).setVariant(string4).setScript(string).build();
            }
            if (string.indexOf(95) < 0) {
                n2 = string.indexOf(45);
                return new Locale.Builder().setLanguage(string2).setRegion(string3).setVariant(string4).setExtension(string.charAt(0), string.substring(n2 + 1)).build();
            }
            n2 = string.indexOf(95);
            return new Locale.Builder().setLanguage(string2).setRegion(string3).setVariant(string4).setScript(string.substring(0, n2)).setExtension(string.charAt(n2 + 1), string.substring(n2 + 3)).build();
        }
        catch (IllformedLocaleException illformedLocaleException) {
            return new Locale(string2, string3, string4);
        }
    }
}

