/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.BaseNodeDeserializer;
import com.fasterxml.jackson.databind.deser.std.BaseNodeDeserializer$ContainerStack;
import com.fasterxml.jackson.databind.deser.std.JsonNodeDeserializer$ArrayDeserializer;
import com.fasterxml.jackson.databind.deser.std.JsonNodeDeserializer$ObjectDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class JsonNodeDeserializer
extends BaseNodeDeserializer<JsonNode> {
    private static final JsonNodeDeserializer instance = new JsonNodeDeserializer();

    protected JsonNodeDeserializer() {
        super(JsonNode.class, null);
    }

    public static JsonDeserializer<? extends JsonNode> getDeserializer(Class<?> clazz) {
        if (clazz == ObjectNode.class) {
            return JsonNodeDeserializer$ObjectDeserializer.getInstance();
        }
        if (clazz == ArrayNode.class) {
            return JsonNodeDeserializer$ArrayDeserializer.getInstance();
        }
        return instance;
    }

    @Override
    public JsonNode getNullValue(DeserializationContext deserializationContext) {
        return deserializationContext.getNodeFactory().nullNode();
    }

    @Override
    public Object getAbsentValue(DeserializationContext deserializationContext) {
        return null;
    }

    @Override
    public JsonNode deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        BaseNodeDeserializer$ContainerStack baseNodeDeserializer$ContainerStack = new BaseNodeDeserializer$ContainerStack();
        JsonNodeFactory jsonNodeFactory = deserializationContext.getNodeFactory();
        switch (jsonParser.currentTokenId()) {
            case 1: {
                return this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, baseNodeDeserializer$ContainerStack, jsonNodeFactory.objectNode());
            }
            case 2: {
                return jsonNodeFactory.objectNode();
            }
            case 3: {
                return this._deserializeContainerNoRecursion(jsonParser, deserializationContext, jsonNodeFactory, baseNodeDeserializer$ContainerStack, jsonNodeFactory.arrayNode());
            }
            case 5: {
                return this._deserializeObjectAtName(jsonParser, deserializationContext, jsonNodeFactory, baseNodeDeserializer$ContainerStack);
            }
        }
        return this._deserializeAnyScalar(jsonParser, deserializationContext);
    }
}

