/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties$Value;
import com.fasterxml.jackson.annotation.JsonIncludeProperties$Value;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId$Referring;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.deser.std.MapDeserializer$MapReferringAccumulator;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.IgnorePropertiesUtil;
import com.fasterxml.jackson.databind.util.IgnorePropertiesUtil$Checker;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@JacksonStdImpl
public class MapDeserializer
extends ContainerDeserializerBase<Map<Object, Object>>
implements ContextualDeserializer,
ResolvableDeserializer {
    private static final long serialVersionUID = 1L;
    protected final KeyDeserializer _keyDeserializer;
    protected boolean _standardStringKey;
    protected final JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected JsonDeserializer<Object> _delegateDeserializer;
    protected PropertyBasedCreator _propertyBasedCreator;
    protected final boolean _hasDefaultCreator;
    protected Set<String> _ignorableProperties;
    protected Set<String> _includableProperties;
    protected IgnorePropertiesUtil$Checker _inclusionChecker;

    public MapDeserializer(JavaType javaType, ValueInstantiator valueInstantiator, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        super(javaType, null, null);
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._valueInstantiator = valueInstantiator;
        this._hasDefaultCreator = valueInstantiator.canCreateUsingDefault();
        this._delegateDeserializer = null;
        this._propertyBasedCreator = null;
        this._standardStringKey = this._isStdKeyDeser(javaType, keyDeserializer);
        this._inclusionChecker = null;
    }

    protected MapDeserializer(MapDeserializer mapDeserializer) {
        super(mapDeserializer);
        this._keyDeserializer = mapDeserializer._keyDeserializer;
        this._valueDeserializer = mapDeserializer._valueDeserializer;
        this._valueTypeDeserializer = mapDeserializer._valueTypeDeserializer;
        this._valueInstantiator = mapDeserializer._valueInstantiator;
        this._propertyBasedCreator = mapDeserializer._propertyBasedCreator;
        this._delegateDeserializer = mapDeserializer._delegateDeserializer;
        this._hasDefaultCreator = mapDeserializer._hasDefaultCreator;
        this._ignorableProperties = mapDeserializer._ignorableProperties;
        this._includableProperties = mapDeserializer._includableProperties;
        this._inclusionChecker = mapDeserializer._inclusionChecker;
        this._standardStringKey = mapDeserializer._standardStringKey;
    }

    protected MapDeserializer(MapDeserializer mapDeserializer, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider, Set<String> set) {
        this(mapDeserializer, keyDeserializer, jsonDeserializer, typeDeserializer, nullValueProvider, set, null);
    }

    protected MapDeserializer(MapDeserializer mapDeserializer, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider, Set<String> set, Set<String> set2) {
        super(mapDeserializer, nullValueProvider, mapDeserializer._unwrapSingle);
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._valueInstantiator = mapDeserializer._valueInstantiator;
        this._propertyBasedCreator = mapDeserializer._propertyBasedCreator;
        this._delegateDeserializer = mapDeserializer._delegateDeserializer;
        this._hasDefaultCreator = mapDeserializer._hasDefaultCreator;
        this._ignorableProperties = set;
        this._includableProperties = set2;
        this._inclusionChecker = IgnorePropertiesUtil.buildCheckerIfNeeded(set, set2);
        this._standardStringKey = this._isStdKeyDeser(this._containerType, keyDeserializer);
    }

    protected MapDeserializer withResolved(KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider, Set<String> set) {
        return this.withResolved(keyDeserializer, typeDeserializer, jsonDeserializer, nullValueProvider, set, this._includableProperties);
    }

    protected MapDeserializer withResolved(KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider, Set<String> set, Set<String> set2) {
        if (this._keyDeserializer == keyDeserializer && this._valueDeserializer == jsonDeserializer && this._valueTypeDeserializer == typeDeserializer && this._nullProvider == nullValueProvider && this._ignorableProperties == set && this._includableProperties == set2) {
            return this;
        }
        return new MapDeserializer(this, keyDeserializer, jsonDeserializer, typeDeserializer, nullValueProvider, set, set2);
    }

    protected final boolean _isStdKeyDeser(JavaType type, KeyDeserializer keyDeserializer) {
        if (keyDeserializer == null) {
            return true;
        }
        if ((type = type.getKeyType()) == null) {
            return true;
        }
        return ((type = ((ResolvedType)((Object)type)).getRawClass()) == String.class || type == Object.class) && this.isDefaultKeyDeserializer(keyDeserializer);
    }

    @Deprecated
    public void setIgnorableProperties(String[] stringArray) {
        this._ignorableProperties = stringArray == null || stringArray.length == 0 ? null : ArrayBuilders.arrayToSet(stringArray);
        this._inclusionChecker = IgnorePropertiesUtil.buildCheckerIfNeeded(this._ignorableProperties, this._includableProperties);
    }

    public void setIgnorableProperties(Set<String> set) {
        this._ignorableProperties = set == null || set.size() == 0 ? null : set;
        this._inclusionChecker = IgnorePropertiesUtil.buildCheckerIfNeeded(this._ignorableProperties, this._includableProperties);
    }

    public void setIncludableProperties(Set<String> set) {
        this._includableProperties = set;
        this._inclusionChecker = IgnorePropertiesUtil.buildCheckerIfNeeded(this._ignorableProperties, this._includableProperties);
    }

    @Override
    public void resolve(DeserializationContext deserializationContext) {
        Object object;
        if (this._valueInstantiator.canCreateUsingDelegate()) {
            object = this._valueInstantiator.getDelegateType(deserializationContext.getConfig());
            if (object == null) {
                ((DatabindContext)deserializationContext).reportBadDefinition(this._containerType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingDelegate()', but null for 'getDelegateType()'", this._containerType, this._valueInstantiator.getClass().getName()));
            }
            this._delegateDeserializer = this.findDeserializer(deserializationContext, (JavaType)object, null);
        } else if (this._valueInstantiator.canCreateUsingArrayDelegate()) {
            object = this._valueInstantiator.getArrayDelegateType(deserializationContext.getConfig());
            if (object == null) {
                ((DatabindContext)deserializationContext).reportBadDefinition(this._containerType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingArrayDelegate()', but null for 'getArrayDelegateType()'", this._containerType, this._valueInstantiator.getClass().getName()));
            }
            this._delegateDeserializer = this.findDeserializer(deserializationContext, (JavaType)object, null);
        }
        if (this._valueInstantiator.canCreateFromObjectWith()) {
            object = this._valueInstantiator.getFromObjectArguments(deserializationContext.getConfig());
            this._propertyBasedCreator = PropertyBasedCreator.construct(deserializationContext, this._valueInstantiator, object, ((DatabindContext)deserializationContext).isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES));
        }
        this._standardStringKey = this._isStdKeyDeser(this._containerType, this._keyDeserializer);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        Object object;
        KeyDeserializer keyDeserializer = this._keyDeserializer;
        if (keyDeserializer == null) {
            keyDeserializer = deserializationContext.findKeyDeserializer(this._containerType.getKeyType(), beanProperty);
        } else if (keyDeserializer instanceof ContextualKeyDeserializer) {
            keyDeserializer = ((ContextualKeyDeserializer)((Object)keyDeserializer)).createContextual(deserializationContext, beanProperty);
        }
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        if (beanProperty != null) {
            jsonDeserializer = this.findConvertingContentDeserializer(deserializationContext, beanProperty, jsonDeserializer);
        }
        Object object2 = this._containerType.getContentType();
        jsonDeserializer = jsonDeserializer == null ? deserializationContext.findContextualValueDeserializer((JavaType)object2, beanProperty) : deserializationContext.handleSecondaryContextualization(jsonDeserializer, beanProperty, (JavaType)object2);
        object2 = this._valueTypeDeserializer;
        if (object2 != null) {
            object2 = ((TypeDeserializer)object2).forProperty(beanProperty);
        }
        Set<String> set = this._ignorableProperties;
        Set<String> set2 = this._includableProperties;
        Object object3 = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        if (MapDeserializer._neitherNull(object3, beanProperty) && (object = beanProperty.getMember()) != null) {
            HashSet<String> hashSet;
            DeserializationConfig deserializationConfig = deserializationContext.getConfig();
            Object object4 = ((AnnotationIntrospector)object3).findPropertyIgnoralByName(deserializationConfig, (Annotated)object);
            if (object4 != null && !(object4 = ((JsonIgnoreProperties$Value)object4).findIgnoredForDeserialization()).isEmpty()) {
                set = set == null ? new HashSet<String>() : new HashSet<String>(set);
                object4 = object4.iterator();
                while (object4.hasNext()) {
                    hashSet = (String)object4.next();
                    set.add((String)((Object)hashSet));
                }
            }
            if ((object4 = ((AnnotationIntrospector)object3).findPropertyInclusionByName(deserializationConfig, (Annotated)object)) != null && (object4 = ((JsonIncludeProperties$Value)object4).getIncluded()) != null) {
                hashSet = new HashSet();
                if (set2 == null) {
                    hashSet = new HashSet<String>((Collection<String>)object4);
                } else {
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object = (String)object3.next();
                        if (!set2.contains(object)) continue;
                        hashSet.add((String)object);
                    }
                }
                set2 = hashSet;
            }
        }
        return this.withResolved(keyDeserializer, (TypeDeserializer)object2, jsonDeserializer, this.findContentNullProvider(deserializationContext, beanProperty, jsonDeserializer), set, set2);
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._keyDeserializer == null && this._valueTypeDeserializer == null && this._ignorableProperties == null && this._includableProperties == null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Map;
    }

    @Override
    public Map<Object, Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingCreator(jsonParser, deserializationContext);
        }
        if (this._delegateDeserializer != null) {
            return (Map)this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (!this._hasDefaultCreator) {
            return (Map)deserializationContext.handleMissingInstantiator(this.getMapClass(), ((StdDeserializer)this).getValueInstantiator(), jsonParser, "no default constructor found", new Object[0]);
        }
        switch (jsonParser.currentTokenId()) {
            case 1: 
            case 2: 
            case 5: {
                Map map = (Map)this._valueInstantiator.createUsingDefault(deserializationContext);
                if (this._standardStringKey) {
                    this._readAndBindStringKeyMap(jsonParser, deserializationContext, map);
                    return map;
                }
                this._readAndBind(jsonParser, deserializationContext, map);
                return map;
            }
            case 6: {
                return (Map)this._deserializeFromString(jsonParser, deserializationContext);
            }
            case 3: {
                return (Map)this._deserializeFromArray(jsonParser, deserializationContext);
            }
        }
        return (Map)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
    }

    @Override
    public Map<Object, Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map) {
        jsonParser.setCurrentValue(map);
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken != JsonToken.START_OBJECT && jsonToken != JsonToken.FIELD_NAME) {
            return (Map)deserializationContext.handleUnexpectedToken(this.getMapClass(), jsonParser);
        }
        if (this._standardStringKey) {
            this._readAndUpdateStringKeyMap(jsonParser, deserializationContext, map);
            return map;
        }
        this._readAndUpdate(jsonParser, deserializationContext, map);
        return map;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext);
    }

    public final Class<?> getMapClass() {
        return ((ResolvedType)this._containerType).getRawClass();
    }

    @Override
    public JavaType getValueType() {
        return this._containerType;
    }

    protected final void _readAndBind(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map) {
        Object object;
        String string;
        KeyDeserializer keyDeserializer = this._keyDeserializer;
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        MapDeserializer$MapReferringAccumulator mapDeserializer$MapReferringAccumulator = null;
        boolean bl = jsonDeserializer.getObjectIdReader() != null;
        if (bl) {
            mapDeserializer$MapReferringAccumulator = new MapDeserializer$MapReferringAccumulator(((ResolvedType)this._containerType.getContentType()).getRawClass(), map);
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            string = jsonParser.nextFieldName();
        } else {
            object = jsonParser.currentToken();
            if (object != JsonToken.FIELD_NAME) {
                if (object == JsonToken.END_OBJECT) {
                    return;
                }
                deserializationContext.reportWrongTokenException(this, JsonToken.FIELD_NAME, null, new Object[0]);
            }
            string = jsonParser.currentName();
        }
        while (string != null) {
            block15: {
                object = keyDeserializer.deserializeKey(string, deserializationContext);
                Object object2 = jsonParser.nextToken();
                if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(string)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        if (object2 == JsonToken.VALUE_NULL) {
                            if (this._skipNullValues) break block15;
                            object2 = this._nullProvider.getNullValue(deserializationContext);
                        } else {
                            object2 = typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
                        }
                        if (bl) {
                            mapDeserializer$MapReferringAccumulator.put(object, object2);
                        } else {
                            map.put(object, object2);
                        }
                    }
                    catch (UnresolvedForwardReference unresolvedForwardReference) {
                        this.handleUnresolvedReference(deserializationContext, mapDeserializer$MapReferringAccumulator, object, unresolvedForwardReference);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(deserializationContext, exception, map, string);
                    }
                }
            }
            string = jsonParser.nextFieldName();
        }
    }

    protected final void _readAndBindStringKeyMap(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map) {
        Object object;
        String string;
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        MapDeserializer$MapReferringAccumulator mapDeserializer$MapReferringAccumulator = null;
        boolean bl = jsonDeserializer.getObjectIdReader() != null;
        if (bl) {
            mapDeserializer$MapReferringAccumulator = new MapDeserializer$MapReferringAccumulator(((ResolvedType)this._containerType.getContentType()).getRawClass(), map);
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            string = jsonParser.nextFieldName();
        } else {
            object = jsonParser.currentToken();
            if (object == JsonToken.END_OBJECT) {
                return;
            }
            if (object != JsonToken.FIELD_NAME) {
                deserializationContext.reportWrongTokenException(this, JsonToken.FIELD_NAME, null, new Object[0]);
            }
            string = jsonParser.currentName();
        }
        while (string != null) {
            block15: {
                object = jsonParser.nextToken();
                if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(string)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        if (object == JsonToken.VALUE_NULL) {
                            if (this._skipNullValues) break block15;
                            object = this._nullProvider.getNullValue(deserializationContext);
                        } else {
                            object = typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
                        }
                        if (bl) {
                            mapDeserializer$MapReferringAccumulator.put(string, object);
                        } else {
                            map.put(string, object);
                        }
                    }
                    catch (UnresolvedForwardReference unresolvedForwardReference) {
                        this.handleUnresolvedReference(deserializationContext, mapDeserializer$MapReferringAccumulator, string, unresolvedForwardReference);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(deserializationContext, exception, map, string);
                    }
                }
            }
            string = jsonParser.nextFieldName();
        }
    }

    public Map<Object, Object> _deserializeUsingCreator(JsonParser jsonParser, DeserializationContext deserializationContext) {
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, null);
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        String string = jsonParser.isExpectedStartObjectToken() ? jsonParser.nextFieldName() : (jsonParser.hasToken(JsonToken.FIELD_NAME) ? jsonParser.currentName() : null);
        while (string != null) {
            block13: {
                Object object = jsonParser.nextToken();
                if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(string)) {
                    jsonParser.skipChildren();
                } else {
                    Object object2 = propertyBasedCreator.findCreatorProperty(string);
                    if (object2 != null) {
                        SettableBeanProperty settableBeanProperty = object2;
                        if (propertyValueBuffer.assignParameter(settableBeanProperty, settableBeanProperty.deserialize(jsonParser, deserializationContext))) {
                            jsonParser.nextToken();
                            try {
                                object2 = (Map)propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                            }
                            catch (Exception exception) {
                                return (Map)this.wrapAndThrow(deserializationContext, exception, ((ResolvedType)this._containerType).getRawClass(), string);
                            }
                            this._readAndBind(jsonParser, deserializationContext, (Map<Object, Object>)object2);
                            return object2;
                        }
                    } else {
                        block14: {
                            object2 = this._keyDeserializer.deserializeKey(string, deserializationContext);
                            try {
                                if (object == JsonToken.VALUE_NULL) {
                                    if (this._skipNullValues) break block13;
                                    object = this._nullProvider.getNullValue(deserializationContext);
                                    break block14;
                                }
                                object = typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
                            }
                            catch (Exception exception) {
                                this.wrapAndThrow(deserializationContext, exception, ((ResolvedType)this._containerType).getRawClass(), string);
                                return null;
                            }
                        }
                        propertyValueBuffer.bufferMapProperty(object2, object);
                    }
                }
            }
            string = jsonParser.nextFieldName();
        }
        try {
            return (Map)propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        }
        catch (Exception exception) {
            this.wrapAndThrow(deserializationContext, exception, ((ResolvedType)this._containerType).getRawClass(), string);
            return null;
        }
    }

    protected final void _readAndUpdate(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map) {
        Object object;
        String string;
        KeyDeserializer keyDeserializer = this._keyDeserializer;
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        if (jsonParser.isExpectedStartObjectToken()) {
            string = jsonParser.nextFieldName();
        } else {
            object = jsonParser.currentToken();
            if (object == JsonToken.END_OBJECT) {
                return;
            }
            if (object != JsonToken.FIELD_NAME) {
                deserializationContext.reportWrongTokenException(this, JsonToken.FIELD_NAME, null, new Object[0]);
            }
            string = jsonParser.currentName();
        }
        while (string != null) {
            object = keyDeserializer.deserializeKey(string, deserializationContext);
            Object object2 = jsonParser.nextToken();
            if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(string)) {
                jsonParser.skipChildren();
            } else {
                try {
                    if (object2 == JsonToken.VALUE_NULL) {
                        if (!this._skipNullValues) {
                            map.put(object, this._nullProvider.getNullValue(deserializationContext));
                        }
                    } else {
                        object2 = map.get(object);
                        Object object3 = object2 != null ? (typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext, object2) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer, object2)) : (typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer));
                        if (object3 != object2) {
                            map.put(object, object3);
                        }
                    }
                }
                catch (Exception exception) {
                    this.wrapAndThrow(deserializationContext, exception, map, string);
                }
            }
            string = jsonParser.nextFieldName();
        }
    }

    protected final void _readAndUpdateStringKeyMap(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map) {
        Object object;
        String string;
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        if (jsonParser.isExpectedStartObjectToken()) {
            string = jsonParser.nextFieldName();
        } else {
            object = jsonParser.currentToken();
            if (object == JsonToken.END_OBJECT) {
                return;
            }
            if (object != JsonToken.FIELD_NAME) {
                deserializationContext.reportWrongTokenException(this, JsonToken.FIELD_NAME, null, new Object[0]);
            }
            string = jsonParser.currentName();
        }
        while (string != null) {
            object = jsonParser.nextToken();
            if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(string)) {
                jsonParser.skipChildren();
            } else {
                try {
                    if (object == JsonToken.VALUE_NULL) {
                        if (!this._skipNullValues) {
                            map.put(string, this._nullProvider.getNullValue(deserializationContext));
                        }
                    } else {
                        object = map.get(string);
                        Object object2 = object != null ? (typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext, object) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer, object)) : (typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer));
                        if (object2 != object) {
                            map.put(string, object2);
                        }
                    }
                }
                catch (Exception exception) {
                    this.wrapAndThrow(deserializationContext, exception, map, string);
                }
            }
            string = jsonParser.nextFieldName();
        }
    }

    private void handleUnresolvedReference(DeserializationContext object, MapDeserializer$MapReferringAccumulator mapDeserializer$MapReferringAccumulator, Object object2, UnresolvedForwardReference unresolvedForwardReference) {
        if (mapDeserializer$MapReferringAccumulator == null) {
            ((DeserializationContext)object).reportInputMismatch(this, "Unresolved forward reference but no identity info: " + unresolvedForwardReference, new Object[0]);
        }
        object = mapDeserializer$MapReferringAccumulator.handleUnresolvedReference(unresolvedForwardReference, object2);
        unresolvedForwardReference.getRoid().appendReferring((ReadableObjectId$Referring)object);
    }
}

