/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.math.BigInteger;

@JacksonStdImpl
public class NumberDeserializers$BigIntegerDeserializer
extends StdScalarDeserializer<BigInteger> {
    public static final NumberDeserializers$BigIntegerDeserializer instance = new NumberDeserializers$BigIntegerDeserializer();

    public NumberDeserializers$BigIntegerDeserializer() {
        super(BigInteger.class);
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return BigInteger.ZERO;
    }

    @Override
    public final LogicalType logicalType() {
        return LogicalType.Integer;
    }

    @Override
    public BigInteger deserialize(JsonParser object, DeserializationContext deserializationContext) {
        if (((JsonParser)object).isExpectedNumberIntToken()) {
            return ((JsonParser)object).getBigIntegerValue();
        }
        switch (((JsonParser)object).currentTokenId()) {
            case 6: {
                object = ((JsonParser)object).getText();
                break;
            }
            case 8: {
                CoercionAction coercionAction = this._checkFloatToIntCoercion((JsonParser)object, deserializationContext, this._valueClass);
                if (coercionAction == CoercionAction.AsNull) {
                    return (BigInteger)this.getNullValue(deserializationContext);
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return (BigInteger)((JsonDeserializer)this).getEmptyValue(deserializationContext);
                }
                return ((JsonParser)object).getDecimalValue().toBigInteger();
            }
            case 1: {
                NumberDeserializers$BigIntegerDeserializer numberDeserializers$BigIntegerDeserializer = this;
                object = deserializationContext.extractScalarFromObject((JsonParser)object, numberDeserializers$BigIntegerDeserializer, numberDeserializers$BigIntegerDeserializer._valueClass);
                break;
            }
            case 3: {
                return (BigInteger)this._deserializeFromArray((JsonParser)object, deserializationContext);
            }
            default: {
                return (BigInteger)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), (JsonParser)object);
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
        if (coercionAction == CoercionAction.AsNull) {
            return (BigInteger)this.getNullValue(deserializationContext);
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return (BigInteger)((JsonDeserializer)this).getEmptyValue(deserializationContext);
        }
        if (this._hasTextualNull((String)(object = ((String)object).trim()))) {
            return (BigInteger)this.getNullValue(deserializationContext);
        }
        try {
            return new BigInteger((String)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (BigInteger)deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "not a valid representation", new Object[0]);
        }
    }
}

