/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers$PrimitiveOrWrapperDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;

@JacksonStdImpl
public class NumberDeserializers$ByteDeserializer
extends NumberDeserializers$PrimitiveOrWrapperDeserializer<Byte> {
    private static final long serialVersionUID = 1L;
    static final NumberDeserializers$ByteDeserializer primitiveInstance = new NumberDeserializers$ByteDeserializer(Byte.TYPE, (byte)0);
    static final NumberDeserializers$ByteDeserializer wrapperInstance = new NumberDeserializers$ByteDeserializer(Byte.class, null);

    public NumberDeserializers$ByteDeserializer(Class<Byte> clazz, Byte by) {
        super(clazz, LogicalType.Integer, by, (byte)0);
    }

    @Override
    public Byte deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.isExpectedNumberIntToken()) {
            return jsonParser.getByteValue();
        }
        if (this._primitive) {
            return this._parseBytePrimitive(jsonParser, deserializationContext);
        }
        return this._parseByte(jsonParser, deserializationContext);
    }

    protected Byte _parseByte(JsonParser object, DeserializationContext deserializationContext) {
        int n2;
        switch (((JsonParser)object).currentTokenId()) {
            case 6: {
                object = ((JsonParser)object).getText();
                break;
            }
            case 8: {
                CoercionAction coercionAction = this._checkFloatToIntCoercion((JsonParser)object, deserializationContext, this._valueClass);
                if (coercionAction == CoercionAction.AsNull) {
                    return (Byte)((JsonDeserializer)this).getNullValue(deserializationContext);
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return (Byte)((JsonDeserializer)this).getEmptyValue(deserializationContext);
                }
                return ((JsonParser)object).getByteValue();
            }
            case 11: {
                return (Byte)((JsonDeserializer)this).getNullValue(deserializationContext);
            }
            case 7: {
                return ((JsonParser)object).getByteValue();
            }
            case 3: {
                return (Byte)this._deserializeFromArray((JsonParser)object, deserializationContext);
            }
            case 1: {
                NumberDeserializers$ByteDeserializer numberDeserializers$ByteDeserializer = this;
                object = deserializationContext.extractScalarFromObject((JsonParser)object, numberDeserializers$ByteDeserializer, numberDeserializers$ByteDeserializer._valueClass);
                break;
            }
            default: {
                return (Byte)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), (JsonParser)object);
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
        if (coercionAction == CoercionAction.AsNull) {
            return (Byte)((JsonDeserializer)this).getNullValue(deserializationContext);
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return (Byte)((JsonDeserializer)this).getEmptyValue(deserializationContext);
        }
        if (this._checkTextualNull(deserializationContext, (String)(object = ((String)object).trim()))) {
            return (Byte)((JsonDeserializer)this).getNullValue(deserializationContext);
        }
        try {
            n2 = NumberInput.parseInt((String)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (Byte)deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "not a valid Byte value", new Object[0]);
        }
        if (this._byteOverflow(n2)) {
            return (Byte)deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "overflow, value cannot be represented as 8-bit value", new Object[0]);
        }
        return (byte)n2;
    }
}

