/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers$PrimitiveOrWrapperDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;

@JacksonStdImpl
public class NumberDeserializers$CharacterDeserializer
extends NumberDeserializers$PrimitiveOrWrapperDeserializer<Character> {
    private static final long serialVersionUID = 1L;
    static final NumberDeserializers$CharacterDeserializer primitiveInstance = new NumberDeserializers$CharacterDeserializer(Character.TYPE, Character.valueOf('\u0000'));
    static final NumberDeserializers$CharacterDeserializer wrapperInstance = new NumberDeserializers$CharacterDeserializer(Character.class, null);

    public NumberDeserializers$CharacterDeserializer(Class<Character> clazz, Character c2) {
        super(clazz, LogicalType.Integer, c2, Character.valueOf('\u0000'));
    }

    @Override
    public Character deserialize(JsonParser object, DeserializationContext deserializationContext) {
        switch (((JsonParser)object).currentTokenId()) {
            case 6: {
                object = ((JsonParser)object).getText();
                break;
            }
            case 7: {
                CoercionAction coercionAction = deserializationContext.findCoercionAction(((JsonDeserializer)this).logicalType(), this._valueClass, CoercionInputShape.Integer);
                switch (coercionAction) {
                    case Fail: {
                        this._checkCoercionFail(deserializationContext, coercionAction, this._valueClass, ((JsonParser)object).getNumberValue(), "Integer value (" + ((JsonParser)object).getText() + ")");
                    }
                    case AsNull: {
                        return (Character)((JsonDeserializer)this).getNullValue(deserializationContext);
                    }
                    case AsEmpty: {
                        return (Character)((JsonDeserializer)this).getEmptyValue(deserializationContext);
                    }
                }
                int n2 = ((JsonParser)object).getIntValue();
                if (n2 >= 0 && n2 <= 65535) {
                    return Character.valueOf((char)n2);
                }
                return (Character)deserializationContext.handleWeirdNumberValue(((JsonDeserializer)this).handledType(), n2, "value outside valid Character range (0x0000 - 0xFFFF)", new Object[0]);
            }
            case 11: {
                if (this._primitive) {
                    this._verifyNullForPrimitive(deserializationContext);
                }
                return (Character)((JsonDeserializer)this).getNullValue(deserializationContext);
            }
            case 1: {
                NumberDeserializers$CharacterDeserializer numberDeserializers$CharacterDeserializer = this;
                object = deserializationContext.extractScalarFromObject((JsonParser)object, numberDeserializers$CharacterDeserializer, numberDeserializers$CharacterDeserializer._valueClass);
                break;
            }
            case 3: {
                return (Character)this._deserializeFromArray((JsonParser)object, deserializationContext);
            }
            default: {
                return (Character)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), (JsonParser)object);
            }
        }
        if (((String)object).length() == 1) {
            return Character.valueOf(((String)object).charAt(0));
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
        if (coercionAction == CoercionAction.AsNull) {
            return (Character)((JsonDeserializer)this).getNullValue(deserializationContext);
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return (Character)((JsonDeserializer)this).getEmptyValue(deserializationContext);
        }
        if (this._checkTextualNull(deserializationContext, (String)(object = ((String)object).trim()))) {
            return (Character)((JsonDeserializer)this).getNullValue(deserializationContext);
        }
        return (Character)deserializationContext.handleWeirdStringValue(((JsonDeserializer)this).handledType(), (String)object, "Expected either Integer value code or 1-character String", new Object[0]);
    }
}

