/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.math.BigDecimal;
import java.math.BigInteger;

@JacksonStdImpl
public class NumberDeserializers$NumberDeserializer
extends StdScalarDeserializer<Object> {
    public static final NumberDeserializers$NumberDeserializer instance = new NumberDeserializers$NumberDeserializer();

    public NumberDeserializers$NumberDeserializer() {
        super(Number.class);
    }

    @Override
    public final LogicalType logicalType() {
        return LogicalType.Integer;
    }

    @Override
    public Object deserialize(JsonParser object, DeserializationContext deserializationContext) {
        switch (((JsonParser)object).currentTokenId()) {
            case 6: {
                object = ((JsonParser)object).getText();
                break;
            }
            case 7: {
                if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                    return this._coerceIntegral((JsonParser)object, deserializationContext);
                }
                return ((JsonParser)object).getNumberValue();
            }
            case 8: {
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS) && !((JsonParser)object).isNaN()) {
                    return ((JsonParser)object).getDecimalValue();
                }
                return ((JsonParser)object).getNumberValue();
            }
            case 1: {
                NumberDeserializers$NumberDeserializer numberDeserializers$NumberDeserializer = this;
                object = deserializationContext.extractScalarFromObject((JsonParser)object, numberDeserializers$NumberDeserializer, numberDeserializers$NumberDeserializer._valueClass);
                break;
            }
            case 3: {
                return this._deserializeFromArray((JsonParser)object, deserializationContext);
            }
            default: {
                return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), (JsonParser)object);
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
        if (coercionAction == CoercionAction.AsNull) {
            return this.getNullValue(deserializationContext);
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return this.getEmptyValue(deserializationContext);
        }
        if (this._hasTextualNull((String)(object = ((String)object).trim()))) {
            return this.getNullValue(deserializationContext);
        }
        if (this._isPosInf((String)object)) {
            return Double.POSITIVE_INFINITY;
        }
        if (this._isNegInf((String)object)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._isNaN((String)object)) {
            return Double.NaN;
        }
        try {
            if (!this._isIntNumber((String)object)) {
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return new BigDecimal((String)object);
                }
                return Double.valueOf((String)object);
            }
            if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                return new BigInteger((String)object);
            }
            long l2 = Long.parseLong((String)object);
            if (!deserializationContext.isEnabled(DeserializationFeature.USE_LONG_FOR_INTS) && l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE) {
                return (int)l2;
            }
            return l2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "not a valid number", new Object[0]);
        }
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        switch (jsonParser.currentTokenId()) {
            case 6: 
            case 7: 
            case 8: {
                return ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
            }
        }
        return typeDeserializer.deserializeTypedFromScalar(jsonParser, deserializationContext);
    }
}

