/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat$Feature;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.AccessPattern;
import com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.lang.reflect.Array;
import java.util.Objects;

@JacksonStdImpl
public class ObjectArrayDeserializer
extends ContainerDeserializerBase<Object[]>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final boolean _untyped;
    protected final Class<?> _elementClass;
    protected JsonDeserializer<Object> _elementDeserializer;
    protected final TypeDeserializer _elementTypeDeserializer;
    protected final Object[] _emptyValue;

    public ObjectArrayDeserializer(JavaType javaType, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        super(javaType, null, null);
        javaType = (ArrayType)javaType;
        this._elementClass = ((ResolvedType)javaType.getContentType()).getRawClass();
        this._untyped = this._elementClass == Object.class;
        this._elementDeserializer = jsonDeserializer;
        this._elementTypeDeserializer = typeDeserializer;
        this._emptyValue = ((ArrayType)javaType).getEmptyArray();
    }

    protected ObjectArrayDeserializer(ObjectArrayDeserializer objectArrayDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider, Boolean bl) {
        super(objectArrayDeserializer, nullValueProvider, bl);
        this._elementClass = objectArrayDeserializer._elementClass;
        this._untyped = objectArrayDeserializer._untyped;
        this._emptyValue = objectArrayDeserializer._emptyValue;
        this._elementDeserializer = jsonDeserializer;
        this._elementTypeDeserializer = typeDeserializer;
    }

    public ObjectArrayDeserializer withDeserializer(TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        return this.withResolved(typeDeserializer, jsonDeserializer, this._nullProvider, this._unwrapSingle);
    }

    public ObjectArrayDeserializer withResolved(TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider, Boolean bl) {
        if (Objects.equals(bl, this._unwrapSingle) && nullValueProvider == this._nullProvider && jsonDeserializer == this._elementDeserializer && typeDeserializer == this._elementTypeDeserializer) {
            return this;
        }
        return new ObjectArrayDeserializer(this, jsonDeserializer, typeDeserializer, nullValueProvider, bl);
    }

    @Override
    public boolean isCachable() {
        return this._elementDeserializer == null && this._elementTypeDeserializer == null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Array;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext object, BeanProperty beanProperty) {
        JsonDeserializer<Object> jsonDeserializer = this._elementDeserializer;
        Boolean bl = this.findFormatFeature((DeserializationContext)object, beanProperty, ((ResolvedType)this._containerType).getRawClass(), JsonFormat$Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        jsonDeserializer = this.findConvertingContentDeserializer((DeserializationContext)object, beanProperty, jsonDeserializer);
        Object object2 = this._containerType.getContentType();
        jsonDeserializer = jsonDeserializer == null ? ((DeserializationContext)object).findContextualValueDeserializer((JavaType)object2, beanProperty) : ((DeserializationContext)object).handleSecondaryContextualization(jsonDeserializer, beanProperty, (JavaType)object2);
        object2 = this._elementTypeDeserializer;
        if (object2 != null) {
            object2 = ((TypeDeserializer)object2).forProperty(beanProperty);
        }
        object = this.findContentNullProvider((DeserializationContext)object, beanProperty, jsonDeserializer);
        return this.withResolved((TypeDeserializer)object2, jsonDeserializer, (NullValueProvider)object, bl);
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._elementDeserializer;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return this._emptyValue;
    }

    @Override
    public Object[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object;
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext);
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n2 = 0;
        TypeDeserializer typeDeserializer = this._elementTypeDeserializer;
        try {
            while ((object = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                if (object == JsonToken.VALUE_NULL) {
                    if (this._skipNullValues) continue;
                    object = this._nullProvider.getNullValue(deserializationContext);
                } else {
                    object = typeDeserializer == null ? this._elementDeserializer.deserialize(jsonParser, deserializationContext) : this._elementDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
                }
                if (n2 >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n2 = 0;
                }
                objectArray[n2++] = object;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)objectArray, objectBuffer.bufferedSize() + n2);
        }
        object = this._untyped ? objectBuffer.completeAndClearBuffer(objectArray, n2) : objectBuffer.completeAndClearBuffer(objectArray, n2, this._elementClass);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return object;
    }

    public Object[] deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return (Object[])typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    @Override
    public Object[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object[] object) {
        if (!jsonParser.isExpectedStartArrayToken()) {
            Object[] objectArray = this.handleNonArray(jsonParser, deserializationContext);
            if (objectArray == null) {
                return object;
            }
            int n2 = ((Object[])object).length;
            Object[] objectArray2 = new Object[n2 + objectArray.length];
            System.arraycopy(object, 0, objectArray2, 0, n2);
            System.arraycopy(objectArray, 0, objectArray2, n2, objectArray.length);
            return objectArray2;
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        int n3 = ((Object[])object).length;
        Object[] objectArray = objectBuffer.resetAndStart((Object[])object, n3);
        TypeDeserializer typeDeserializer = this._elementTypeDeserializer;
        try {
            while ((object = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                if (object == JsonToken.VALUE_NULL) {
                    if (this._skipNullValues) continue;
                    object = this._nullProvider.getNullValue(deserializationContext);
                } else {
                    object = typeDeserializer == null ? this._elementDeserializer.deserialize(jsonParser, deserializationContext) : this._elementDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
                }
                if (n3 >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n3 = 0;
                }
                objectArray[n3++] = object;
            }
        }
        catch (Exception exception) {
            object = exception;
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)objectArray, objectBuffer.bufferedSize() + n3);
        }
        object = this._untyped ? objectBuffer.completeAndClearBuffer(objectArray, n3) : objectBuffer.completeAndClearBuffer(objectArray, n3, this._elementClass);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return object;
    }

    protected Byte[] deserializeFromBase64(JsonParser object, DeserializationContext byteArray) {
        byte[] byArray = ((JsonParser)object).getBinaryValue(byteArray.getBase64Variant());
        object = byArray;
        byteArray = new Byte[byArray.length];
        int n2 = ((Object)object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            byteArray[i2] = (byte)object[i2];
        }
        return byteArray;
    }

    protected Object[] handleNonArray(JsonParser object, DeserializationContext objectArray) {
        boolean bl = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && objectArray.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (!bl) {
            if (((JsonParser)object).hasToken(JsonToken.VALUE_STRING)) {
                if (this._elementClass == Byte.class) {
                    return this.deserializeFromBase64((JsonParser)object, (DeserializationContext)objectArray);
                }
                return (Object[])this._deserializeFromString((JsonParser)object, (DeserializationContext)objectArray);
            }
            return (Object[])objectArray.handleUnexpectedToken(this._containerType, (JsonParser)object);
        }
        if (((JsonParser)object).hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNullValues) {
                return this._emptyValue;
            }
            object = this._nullProvider.getNullValue((DeserializationContext)objectArray);
        } else {
            object = this._elementTypeDeserializer == null ? this._elementDeserializer.deserialize((JsonParser)object, (DeserializationContext)objectArray) : this._elementDeserializer.deserializeWithType((JsonParser)object, (DeserializationContext)objectArray, this._elementTypeDeserializer);
        }
        objectArray = this._untyped ? new Object[1] : (Object[])Array.newInstance(this._elementClass, 1);
        objectArray[0] = object;
        return objectArray;
    }
}

