/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers;
import com.fasterxml.jackson.databind.util.ArrayBuilders$BooleanBuilder;
import java.util.Arrays;

@JacksonStdImpl
final class PrimitiveArrayDeserializers$BooleanDeser
extends PrimitiveArrayDeserializers<boolean[]> {
    private static final long serialVersionUID = 1L;

    public PrimitiveArrayDeserializers$BooleanDeser() {
        super(boolean[].class);
    }

    protected PrimitiveArrayDeserializers$BooleanDeser(PrimitiveArrayDeserializers$BooleanDeser primitiveArrayDeserializers$BooleanDeser, NullValueProvider nullValueProvider, Boolean bl) {
        super(primitiveArrayDeserializers$BooleanDeser, nullValueProvider, bl);
    }

    @Override
    protected final PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl) {
        return new PrimitiveArrayDeserializers$BooleanDeser(this, nullValueProvider, bl);
    }

    @Override
    protected final boolean[] _constructEmpty() {
        return new boolean[0];
    }

    @Override
    public final boolean[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return (boolean[])this.handleNonArray(jsonParser, deserializationContext);
        }
        ArrayBuilders$BooleanBuilder arrayBuilders$BooleanBuilder = deserializationContext.getArrayBuilders().getBooleanBuilder();
        boolean[] blArray = (boolean[])arrayBuilders$BooleanBuilder.resetAndStart();
        int n2 = 0;
        try {
            JsonToken jsonToken;
            while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                boolean bl;
                if (jsonToken == JsonToken.VALUE_TRUE) {
                    bl = true;
                } else if (jsonToken == JsonToken.VALUE_FALSE) {
                    bl = false;
                } else if (jsonToken == JsonToken.VALUE_NULL) {
                    if (this._nuller != null) {
                        this._nuller.getNullValue(deserializationContext);
                        continue;
                    }
                    this._verifyNullForPrimitive(deserializationContext);
                    bl = false;
                } else {
                    bl = this._parseBooleanPrimitive(jsonParser, deserializationContext);
                }
                if (n2 >= blArray.length) {
                    blArray = arrayBuilders$BooleanBuilder.appendCompletedChunk(blArray, n2);
                    n2 = 0;
                }
                blArray[n2++] = bl;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)blArray, arrayBuilders$BooleanBuilder.bufferedSize() + n2);
        }
        return arrayBuilders$BooleanBuilder.completeAndClearBuffer(blArray, n2);
    }

    @Override
    protected final boolean[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) {
        return new boolean[]{this._parseBooleanPrimitive(jsonParser, deserializationContext)};
    }

    @Override
    protected final boolean[] _concat(boolean[] blArray, boolean[] blArray2) {
        int n2 = blArray.length;
        int n3 = blArray2.length;
        blArray = Arrays.copyOf(blArray, n2 + n3);
        System.arraycopy(blArray2, 0, blArray, n2, n3);
        return blArray;
    }
}

