/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.PrimitiveArrayBuilder;
import java.util.Arrays;

@JacksonStdImpl
final class PrimitiveArrayDeserializers$ByteDeser
extends PrimitiveArrayDeserializers<byte[]> {
    private static final long serialVersionUID = 1L;

    public PrimitiveArrayDeserializers$ByteDeser() {
        super(byte[].class);
    }

    protected PrimitiveArrayDeserializers$ByteDeser(PrimitiveArrayDeserializers$ByteDeser primitiveArrayDeserializers$ByteDeser, NullValueProvider nullValueProvider, Boolean bl) {
        super(primitiveArrayDeserializers$ByteDeser, nullValueProvider, bl);
    }

    @Override
    protected final PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl) {
        return new PrimitiveArrayDeserializers$ByteDeser(this, nullValueProvider, bl);
    }

    @Override
    protected final byte[] _constructEmpty() {
        return new byte[0];
    }

    @Override
    public final LogicalType logicalType() {
        return LogicalType.Binary;
    }

    @Override
    public final byte[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object;
        Object object2;
        Object object3;
        block16: {
            object3 = jsonParser.currentToken();
            if (object3 == JsonToken.VALUE_STRING) {
                try {
                    return jsonParser.getBinaryValue(deserializationContext.getBase64Variant());
                }
                catch (StreamReadException streamReadException) {
                    object2 = streamReadException;
                    object = ((JacksonException)streamReadException).getOriginalMessage();
                    if (!((String)object).contains("base64")) break block16;
                    return (byte[])deserializationContext.handleWeirdStringValue(byte[].class, jsonParser.getText(), (String)object, new Object[0]);
                }
            }
        }
        if (object3 == JsonToken.VALUE_EMBEDDED_OBJECT) {
            object2 = jsonParser.getEmbeddedObject();
            if (object2 == null) {
                return null;
            }
            if (object2 instanceof byte[]) {
                return (byte[])object2;
            }
        }
        if (!jsonParser.isExpectedStartArrayToken()) {
            return (byte[])this.handleNonArray(jsonParser, deserializationContext);
        }
        object2 = deserializationContext.getArrayBuilders().getByteBuilder();
        object = (byte[])((PrimitiveArrayBuilder)object2).resetAndStart();
        int n2 = 0;
        try {
            JsonToken jsonToken;
            while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                byte by;
                if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                    by = jsonParser.getByteValue();
                } else if (jsonToken == JsonToken.VALUE_NULL) {
                    if (this._nuller != null) {
                        this._nuller.getNullValue(deserializationContext);
                        continue;
                    }
                    this._verifyNullForPrimitive(deserializationContext);
                    by = 0;
                } else {
                    by = this._parseBytePrimitive(jsonParser, deserializationContext);
                }
                if (n2 >= ((Object)object).length) {
                    object = (byte[])((PrimitiveArrayBuilder)object2).appendCompletedChunk(object, n2);
                    n2 = 0;
                }
                object[n2++] = by;
            }
        }
        catch (Exception exception) {
            object3 = exception;
            throw JsonMappingException.wrapWithPath((Throwable)exception, object, ((PrimitiveArrayBuilder)object2).bufferedSize() + n2);
        }
        return (byte[])((PrimitiveArrayBuilder)object2).completeAndClearBuffer(object, n2);
    }

    @Override
    protected final byte[] handleSingleElementUnwrapped(JsonParser object, DeserializationContext deserializationContext) {
        byte by;
        JsonToken jsonToken = ((JsonParser)object).currentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            by = ((JsonParser)object).getByteValue();
        } else {
            if (jsonToken == JsonToken.VALUE_NULL) {
                if (this._nuller != null) {
                    this._nuller.getNullValue(deserializationContext);
                    return (byte[])((JsonDeserializer)this).getEmptyValue(deserializationContext);
                }
                this._verifyNullForPrimitive(deserializationContext);
                return null;
            }
            object = (Number)deserializationContext.handleUnexpectedToken(this._valueClass.getComponentType(), (JsonParser)object);
            by = ((Number)object).byteValue();
        }
        return new byte[]{by};
    }

    @Override
    protected final byte[] _concat(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        int n3 = byArray2.length;
        byArray = Arrays.copyOf(byArray, n2 + n3);
        System.arraycopy(byArray2, 0, byArray, n2, n3);
        return byArray;
    }
}

